/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.transformation.AbstractFeatureTransformation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.tools.WekaTools;
import java.util.List;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalComponentsTransformation
extends AbstractFeatureTransformation {
    public static final String PARAMETER_MIN_VARIANCE_COVERAGE = "min_variance_coverage";

    public PrincipalComponentsTransformation(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        PrincipalComponents transformation = new PrincipalComponents();
        transformation.setNormalize(false);
        transformation.setVarianceCovered(this.getParameterAsDouble(PARAMETER_MIN_VARIANCE_COVERAGE));
        this.log(String.valueOf(this.getName()) + ": Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "PCAInstances", 0);
        try {
            this.log(String.valueOf(this.getName()) + ": Building principal components.");
            transformation.buildEvaluator(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, "PrincipalComponents", e);
        }
        ExampleSet result = null;
        try {
            Instances transformed = transformation.transformedData(instances);
            result = WekaTools.toRapidMinerExampleSet(transformed, "pc");
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 905, "Principal Components Transformation", "Cannot convert to principal components (" + e.getMessage() + ")");
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_MIN_VARIANCE_COVERAGE, "The minimum variance to cover in the original data to determine the number of principal components.", 0.0, 1.0, 0.95);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

