/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.generator;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.generator.TargetFunction;
import com.rapidminer.tools.RandomGenerator;

public class DrillerOscillationFunction
implements TargetFunction {
    private static final double SKEW_CATASTROPHY_EXPONENT = 1.2;
    private double TURN_PERIODS = 16.0;
    private static double GENERAL_NOISE = 0.02;
    private static double INITIAL_SKEW_RATE_VARIANCE = 0.2;
    private static double LAST_SKEW_CHANGE_PROBABILITY = 0.2;
    private static double MAXIMAL_SKEW_CHANGE = 0.1;
    private static double CRITICAL_FREQUENCY_SKEW = 2.7;
    private static double SKEW_FASTER_PREFERENCE = 0.3;
    private int periodLength;
    private int period = 0;
    private double[] frequencePeriod;
    private double[] skew;
    private double[] skewChangeDirection;
    private double[] crashed;

    public double calculate(double[] args) throws TargetFunction.FunctionException {
        return 0.0;
    }

    public double[] createArguments(int dimension, RandomGenerator random) throws TargetFunction.FunctionException {
        if (this.skew == null) {
            this.skew = new double[dimension - 1];
            int i = 0;
            while (i < dimension - 1) {
                this.skew[i] = 1.0 + random.nextDoubleInRange(-INITIAL_SKEW_RATE_VARIANCE, INITIAL_SKEW_RATE_VARIANCE);
                ++i;
            }
            this.skewChangeDirection = new double[dimension - 1];
            i = 0;
            while (i < dimension - 1) {
                this.skewChangeDirection[i] = random.nextDouble() - SKEW_FASTER_PREFERENCE;
                ++i;
            }
            this.crashed = new double[dimension];
            this.frequencePeriod = new double[dimension - 1];
        }
        double[] values = new double[dimension];
        --dimension;
        double neededProbability = Math.pow((double)this.period / (double)this.periodLength, 1.5) * LAST_SKEW_CHANGE_PROBABILITY;
        int i = 0;
        while (i < dimension) {
            if (this.skew[i] > CRITICAL_FREQUENCY_SKEW) {
                this.skew[i] = Math.pow(this.skew[i], 1.2);
                this.crashed[i] = 1.0;
            } else {
                double dice = random.nextDouble();
                if (dice <= neededProbability) {
                    double skewChange = this.skew[i] * random.nextDoubleInRange(0.0, MAXIMAL_SKEW_CHANGE);
                    this.skew[i] = random.nextDouble() <= this.skewChangeDirection[i] ? this.skew[i] - skewChange : this.skew[i] + skewChange;
                }
            }
            ++i;
        }
        i = 0;
        while (i < dimension) {
            this.frequencePeriod[i] = this.frequencePeriod[i] + Math.PI * this.skew[i] / this.TURN_PERIODS;
            values[i] = Math.sin(this.frequencePeriod[i]);
            values[i] = values[i] * random.nextDoubleInRange(1.0 - GENERAL_NOISE, 1.0 + GENERAL_NOISE);
            ++i;
        }
        values[1] = this.skew[0];
        values[dimension] = this.period;
        ++this.period;
        if (this.period == this.periodLength) {
            this.crashed[dimension] = this.period;
            return this.crashed;
        }
        return values;
    }

    public Attribute getLabel() {
        return null;
    }

    public void init(RandomGenerator random) {
    }

    public void setLowerArgumentBound(double lower) {
    }

    public void setTotalNumberOfAttributes(int number) {
    }

    public void setTotalNumberOfExamples(int number) {
        this.periodLength = number;
    }

    public void setUpperArgumentBound(double upper) {
    }
}

