/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.DatabaseExampleSource;
import com.rapidminer.operator.io.ExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.OperatorService;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessExampleSource
extends ExampleSource {
    public static final String PARAMETER_DATABASE_FILE = "database_file";
    public static final String PARAMETER_USERNAME = "username";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_TABLE_NAME = "table_name";
    public static final String PARAMETER_LABEL_ATTRIBUTE = "label_attribute";
    public static final String PARAMETER_ID_ATTRIBUTE = "id_attribute";

    public AccessExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        try {
            String password;
            DatabaseExampleSource source = OperatorService.createOperator(DatabaseExampleSource.class);
            source.setParameter("database_system", "ODBC Bridge (e.g. Access)");
            File databaseFile = this.getParameterAsFile(PARAMETER_DATABASE_FILE);
            source.setParameter("database_url", "jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + databaseFile.getAbsolutePath());
            source.setParameter(PARAMETER_TABLE_NAME, this.getParameterAsString(PARAMETER_TABLE_NAME));
            source.setParameter(PARAMETER_LABEL_ATTRIBUTE, this.getParameterAsString(PARAMETER_LABEL_ATTRIBUTE));
            source.setParameter(PARAMETER_ID_ATTRIBUTE, this.getParameterAsString(PARAMETER_ID_ATTRIBUTE));
            String userName = this.getParameterAsString(PARAMETER_USERNAME);
            if (userName == null) {
                userName = "noUser";
            }
            if ((password = this.getParameterAsString(PARAMETER_PASSWORD)) == null) {
                password = "noPassword";
            }
            source.setParameter(PARAMETER_USERNAME, userName);
            source.setParameter(PARAMETER_PASSWORD, password);
            return source.createExampleSet();
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Could not create DatabaseExampleSource Operator:", e.getCause());
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(new ParameterTypeFile(PARAMETER_DATABASE_FILE, "The mdb file of your access database.", "mdb", false));
        types.add(new ParameterTypeString(PARAMETER_TABLE_NAME, "The name of the table or querry within your access database", false));
        types.add(new ParameterTypeString(PARAMETER_LABEL_ATTRIBUTE, "The (case sensitive) name of the label attribute"));
        types.add(new ParameterTypeString(PARAMETER_ID_ATTRIBUTE, "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString(PARAMETER_USERNAME, "Database username."));
        types.add(new ParameterTypePassword(PARAMETER_PASSWORD, "Password for the database."));
        return types;
    }
}

