/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.FileDataRowReader;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.att.AttributeDataSource;
import com.rapidminer.tools.att.AttributeDataSourceCreator;
import com.rapidminer.tools.att.AttributeDataSources;
import com.rapidminer.tools.att.AttributeSet;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_LABEL_NAME = "label_name";
    public static final String PARAMETER_LABEL_COLUMN = "label_column";
    public static final String PARAMETER_ID_NAME = "id_name";
    public static final String PARAMETER_ID_COLUMN = "id_column";
    public static final String PARAMETER_WEIGHT_NAME = "weight_name";
    public static final String PARAMETER_WEIGHT_COLUMN = "weight_column";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_USE_COMMENT_CHARACTERS = "use_comment_characters";
    public static final String PARAMETER_COMMENT_CHARS = "comment_chars";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_READ_ATTRIBUTE_NAMES = "read_attribute_names";
    public static final String PARAMETER_USE_QUOTES = "use_quotes";
    public static final String PARAMETER_TRIM_LINES = "trim_lines";
    public static final String PARAMETER_SKIP_ERROR_LINES = "skip_error_lines";
    public static final String PARAMETER_COLUMN_SEPARATORS = "column_separators";

    public SimpleExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_FILENAME);
        double sampleRatio = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
        int maxLines = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        String separatorRegExpr = this.getParameterAsString(PARAMETER_COLUMN_SEPARATORS);
        char[] comments = null;
        if (this.getParameterAsBoolean(PARAMETER_USE_COMMENT_CHARACTERS)) {
            comments = this.getParameterAsString(PARAMETER_COMMENT_CHARS).toCharArray();
        }
        int dataRowType = this.getParameterAsInt(PARAMETER_DATAMANAGEMENT);
        boolean useQuotes = this.getParameterAsBoolean(PARAMETER_USE_QUOTES);
        boolean trimLines = this.getParameterAsBoolean(PARAMETER_TRIM_LINES);
        boolean skipErrorLines = this.getParameterAsBoolean(PARAMETER_SKIP_ERROR_LINES);
        char decimalPointCharacter = this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0);
        AttributeDataSourceCreator adsCreator = new AttributeDataSourceCreator();
        try {
            adsCreator.loadData(file, comments, separatorRegExpr, decimalPointCharacter, useQuotes, '\"', '\\', trimLines, this.getParameterAsBoolean(PARAMETER_READ_ATTRIBUTE_NAMES), -1, skipErrorLines, this.getEncoding(), this);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, file, e.getMessage());
        }
        List<AttributeDataSource> attributeDataSources = adsCreator.getAttributeDataSources();
        this.resetAttributeType(attributeDataSources, PARAMETER_LABEL_NAME, PARAMETER_LABEL_COLUMN, "label");
        this.resetAttributeType(attributeDataSources, PARAMETER_ID_NAME, PARAMETER_ID_COLUMN, "id");
        this.resetAttributeType(attributeDataSources, PARAMETER_WEIGHT_NAME, PARAMETER_WEIGHT_COLUMN, "weight");
        FileDataRowReader reader = null;
        try {
            reader = new FileDataRowReader(new DataRowFactory(dataRowType, decimalPointCharacter), attributeDataSources, sampleRatio, maxLines, separatorRegExpr, comments, useQuotes, '\"', '\\', trimLines, skipErrorLines, this.getEncoding(), RandomGenerator.getRandomGenerator(-1));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, file, e.getMessage());
        }
        if (this.getParameterAsBoolean(PARAMETER_READ_ATTRIBUTE_NAMES)) {
            reader.skipLine();
        }
        AttributeSet attributeSet = new AttributeSet(new AttributeDataSources(attributeDataSources, file));
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes(), reader);
        ExampleSet result = table.createExampleSet(attributeSet);
        return result;
    }

    private void resetAttributeType(List<AttributeDataSource> attributeDataSources, String attributeName, String columnName, String typeName) throws OperatorException {
        block4: {
            String attribute;
            block3: {
                attribute = this.getParameterAsString(attributeName);
                if (attribute != null && attribute.length() != 0) break block3;
                int column = this.getParameterAsInt(columnName);
                if (column == 0) break block4;
                if (column < 0) {
                    column = attributeDataSources.size() + column + 1;
                }
                if (column < 1 || column >= attributeDataSources.size() + 1) {
                    throw new UserError((Operator)this, 111, String.valueOf(columnName) + " = " + column);
                }
                attributeDataSources.get(--column).setType(typeName);
                break block4;
            }
            for (AttributeDataSource ads : attributeDataSources) {
                if (!ads.getAttribute().getName().equals(attribute)) continue;
                ads.setType(typeName);
                break;
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_FILENAME, "Name of the file to read the data from.", "dat", false));
        ParameterTypeSingle type = new ParameterTypeBoolean(PARAMETER_READ_ATTRIBUTE_NAMES, "Read attribute names from file (assumes the attribute names are in the first line of the file).", false);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeString(PARAMETER_LABEL_NAME, "Name of the label attribute (if empty, the column defined by label_column will be used)", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LABEL_COLUMN, "Column number of the label attribute (only used if label_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString(PARAMETER_ID_NAME, "Name of the id attribute (if empty, the column defined by id_column will be used)", true));
        types.add(new ParameterTypeInt(PARAMETER_ID_COLUMN, "Column number of the id attribute (only used if id_name is empty; 0 = none; negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        types.add(new ParameterTypeString(PARAMETER_WEIGHT_NAME, "Name of the weight attribute (if empty, the column defined by weight_column will be used)", true));
        types.add(new ParameterTypeInt(PARAMETER_WEIGHT_COLUMN, "Column number of the weight attribute (only used if weight_name is empty; 0 = none, negative values are counted from the last column)", Integer.MIN_VALUE, Integer.MAX_VALUE, 0));
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = use sample ratio; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString(PARAMETER_COLUMN_SEPARATORS, "Column separators for data files (regular expression)", ",\\s*|;\\s*|\\s+"));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_COMMENT_CHARACTERS, "Indicates if qa comment character should be used.", true));
        types.add(new ParameterTypeString(PARAMETER_COMMENT_CHARS, "Lines beginning with these characters are ignored.", "#"));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_QUOTES, "Indicates if quotes should be regarded (slower!).", false));
        types.add(new ParameterTypeBoolean(PARAMETER_TRIM_LINES, "Indicates if lines should be trimmed (empty spaces are removed at the beginning and the end) before the column split is performed.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_SKIP_ERROR_LINES, "Indicates if lines which can not be read should be skipped instead of letting this operator fail its execution.", false));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        return types;
    }
}

