/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.learner.functions.kernel.KernelModel;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.learner.functions.kernel.rvm.Model;

public class RVMModel
extends KernelModel {
    private static final long serialVersionUID = -26935964796619097L;
    private Model model = null;

    public RVMModel(ExampleSet exampleSet, Model model) {
        super(exampleSet);
        this.model = model;
    }

    public boolean isClassificationModel() {
        return this.getLabel().isNominal();
    }

    public double getAlpha(int index) {
        return this.model.getWeight(index);
    }

    public double getBias() {
        return 0.0;
    }

    public SupportVector getSupportVector(int index) {
        return null;
    }

    public String getId(int index) {
        return null;
    }

    public int getNumberOfSupportVectors() {
        return this.model.getNumberOfRelevanceVectors();
    }

    public int getNumberOfAttributes() {
        return 0;
    }

    public double getAttributeValue(int exampleIndex, int attributeIndex) {
        return Double.NaN;
    }

    public String getClassificationLabel(int index) {
        return "?";
    }

    public double getRegressionLabel(int index) {
        return Double.NaN;
    }

    public double getFunctionValue(int index) {
        return Double.NaN;
    }

    public static double[] makeInputVector(Example e) {
        double[] vector = new double[e.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : e.getAttributes()) {
            vector[i++] = e.getValue(attribute);
        }
        return vector;
    }

    public ExampleSet performPrediction(ExampleSet exampleSet, Attribute predictedLabel) {
        for (Example e : exampleSet) {
            double functionValue = this.model.applyToVector(RVMModel.makeInputVector(e));
            if (this.getLabel().isNominal()) {
                if (functionValue > 0.0) {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getPositiveIndex());
                } else {
                    e.setValue(predictedLabel, this.getLabel().getMapping().getNegativeIndex());
                }
                e.setConfidence(predictedLabel.getMapping().getPositiveString(), 1.0 / (1.0 + Math.exp(-functionValue)));
                e.setConfidence(predictedLabel.getMapping().getNegativeString(), 1.0 / (1.0 + Math.exp(functionValue)));
                continue;
            }
            e.setValue(predictedLabel, functionValue);
        }
        return exampleSet;
    }
}

