/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.discretization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.PolynominalMapping;
import com.rapidminer.example.table.ViewAttribute;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.PreprocessingModel;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscretizationModel
extends PreprocessingModel {
    private static final long serialVersionUID = -8732346419946567062L;
    private Map<String, SortedSet<Tupel<Double, String>>> rangesMap;
    private Set<String> attributeNames = new HashSet<String>();
    private boolean removeUseless = true;
    public static final String[] RANGE_NAME_TYPES = new String[]{"long", "short", "interval"};
    public static final int RANGE_NAME_LONG = 0;
    public static final int RANGE_NAME_SHORT = 1;
    public static final int RANGE_NAME_INTERVAL = 2;

    public DiscretizationModel(ExampleSet exampleSet) {
        this(exampleSet, false);
    }

    public DiscretizationModel(ExampleSet exampleSet, boolean removeUseless) {
        super(exampleSet);
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical()) continue;
            this.attributeNames.add(attribute.getName());
        }
        this.removeUseless = removeUseless;
    }

    @Override
    public ExampleSet applyOnData(ExampleSet exampleSet) throws OperatorException {
        LinkedHashMap replacementMap = new LinkedHashMap();
        ExampleTable table = exampleSet.getExampleTable();
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeNames.contains(attribute.getName())) continue;
            Iterator newAttribute = AttributeFactory.createAttribute(1);
            replacementMap.put(attribute, newAttribute);
        }
        Set replacements = replacementMap.entrySet();
        for (Map.Entry replacement : replacements) {
            SortedSet<Tupel<Double, String>> ranges = this.rangesMap.get(((Attribute)replacement.getKey()).getName());
            Attribute newAttribute = (Attribute)replacement.getValue();
            table.addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            if (ranges == null) continue;
            for (Tupel tupel : ranges) {
                newAttribute.getMapping().mapString((String)tupel.getSecond());
            }
        }
        for (Example example : exampleSet) {
            block4: for (Map.Entry replacement : replacements) {
                Attribute attribute = (Attribute)replacement.getKey();
                Attribute newAttribute = (Attribute)replacement.getValue();
                SortedSet<Tupel<Double, String>> ranges = this.rangesMap.get(attribute.getName());
                if (ranges == null) continue;
                double value = example.getValue(attribute);
                if (!Double.isNaN(value)) {
                    int b = 0;
                    for (Tupel tupel : ranges) {
                        if (value <= (Double)tupel.getFirst()) {
                            example.setValue(newAttribute, b);
                            continue block4;
                        }
                        ++b;
                    }
                    continue;
                }
                example.setValue(newAttribute, Double.NaN);
            }
        }
        for (Map.Entry entry : replacementMap.entrySet()) {
            String name = ((Attribute)entry.getKey()).getName();
            exampleSet.getAttributes().remove((Attribute)entry.getKey());
            ((Attribute)entry.getValue()).setName(name);
        }
        if (this.removeUseless) {
            Iterator<Attribute> iterator = exampleSet.getAttributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (!attribute.isNominal() || attribute.getMapping().size() >= 2) continue;
                iterator.remove();
            }
        }
        return exampleSet;
    }

    public void setRanges(Map<Attribute, double[]> rangesMap, String rangeName, int rangeNameType, int numberOfDigits) throws UserError {
        this.rangesMap = new HashMap<String, SortedSet<Tupel<Double, String>>>();
        for (Map.Entry<Attribute, double[]> entry : rangesMap.entrySet()) {
            Attribute attribute = entry.getKey();
            double[] limits = entry.getValue();
            TreeSet<Tupel<Double, String>> ranges = null;
            boolean valid = true;
            if (rangeNameType == 2) {
                int startNumberOfDigits = numberOfDigits;
                if (startNumberOfDigits <= 0) {
                    startNumberOfDigits = 1;
                }
                int n = startNumberOfDigits;
                while (n < 30) {
                    valid = true;
                    ranges = this.createRanges(limits, rangeName, rangeNameType, n);
                    String lastTupel = null;
                    for (Tupel<Double, String> t : ranges) {
                        String second;
                        if (lastTupel != null && lastTupel.equals(t.getSecond())) {
                            valid = false;
                            break;
                        }
                        String first = t.getSecond().substring(1, t.getSecond().indexOf(" - "));
                        if (first.equals(second = t.getSecond().substring(t.getSecond().indexOf(" - ") + " - ".length(), t.getSecond().length() - 1))) {
                            valid = false;
                            break;
                        }
                        lastTupel = t.getSecond();
                    }
                    if (valid) break;
                    ++n;
                }
                if (!valid) {
                    throw new UserError(null, 938);
                }
            } else {
                ranges = numberOfDigits > 0 ? this.createRanges(limits, rangeName, rangeNameType, numberOfDigits) : this.createRanges(limits, rangeName, rangeNameType, 3);
            }
            this.rangesMap.put(attribute.getName(), ranges);
        }
    }

    private TreeSet<Tupel<Double, String>> createRanges(double[] entry, String rangeBaseName, int rangeNameType, int numberOfDigits) {
        TreeSet<Tupel<Double, String>> ranges = new TreeSet<Tupel<Double, String>>();
        int i = 1;
        double lastLimit = Double.NEGATIVE_INFINITY;
        double[] dArray = entry;
        int n = entry.length;
        int n2 = 0;
        while (n2 < n) {
            double rangeValue = dArray[n2];
            String usedRangeName = null;
            switch (rangeNameType) {
                case 0: {
                    usedRangeName = String.valueOf(rangeBaseName) + i + " [" + Tools.formatIntegerIfPossible(lastLimit) + " - " + Tools.formatIntegerIfPossible(rangeValue) + "]";
                    break;
                }
                case 1: {
                    usedRangeName = String.valueOf(rangeBaseName) + i;
                    break;
                }
                case 2: {
                    usedRangeName = "[" + Tools.formatNumber(lastLimit, numberOfDigits) + " - " + Tools.formatNumber(rangeValue, numberOfDigits) + "]";
                }
            }
            ranges.add(new Tupel<Double, Object>(rangeValue, usedRangeName));
            ++i;
            lastLimit = rangeValue;
            ++n2;
        }
        return ranges;
    }

    public void setRanges(Map<String, SortedSet<Tupel<Double, String>>> rangesMap) {
        this.rangesMap = rangesMap;
    }

    public Map<String, SortedSet<Tupel<Double, String>>> getRanges() {
        return this.rangesMap;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String attributeName : this.rangesMap.keySet()) {
            buffer.append(Tools.getLineSeparator());
            buffer.append(Tools.getLineSeparator());
            buffer.append(attributeName);
            buffer.append(Tools.getLineSeparator());
            SortedSet<Tupel<Double, String>> set = this.rangesMap.get(attributeName);
            buffer.append(Double.NEGATIVE_INFINITY);
            for (Tupel tupel : set) {
                buffer.append(" < " + (String)tupel.getSecond() + " <= " + tupel.getFirst());
            }
        }
        return buffer.toString();
    }

    @Override
    public Attributes getTargetAttributes(ExampleSet parentSet) {
        SimpleAttributes attributes = new SimpleAttributes();
        Iterator<AttributeRole> specialRoles = parentSet.getAttributes().specialAttributes();
        while (specialRoles.hasNext()) {
            attributes.add(specialRoles.next());
        }
        for (Attribute attribute : parentSet.getAttributes()) {
            if (!attribute.isNumerical() || !this.attributeNames.contains(attribute.getName())) {
                attributes.addRegular(attribute);
                continue;
            }
            SortedSet<Tupel<Double, String>> ranges = this.rangesMap.get(attribute.getName());
            if (ranges.size() <= 1) continue;
            PolynominalMapping mapping = new PolynominalMapping();
            for (Tupel tupel : ranges) {
                mapping.mapString((String)tupel.getSecond());
            }
            attributes.addRegular(new ViewAttribute(this, attribute, attribute.getName(), 7, mapping));
        }
        return attributes;
    }

    @Override
    public double getValue(Attribute targetAttribute, double value) {
        SortedSet<Tupel<Double, String>> ranges = this.rangesMap.get(targetAttribute.getName());
        if (ranges != null) {
            int b = 0;
            for (Tupel tupel : ranges) {
                if (value <= (Double)tupel.getFirst()) {
                    return b;
                }
                ++b;
            }
            return Double.NaN;
        }
        return value;
    }
}

