/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Partition;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleRangeFilter
extends AbstractDataProcessing {
    public static final String PARAMETER_FIRST_EXAMPLE = "first_example";
    public static final String PARAMETER_LAST_EXAMPLE = "last_example";
    public static final String PARAMETER_INVERT_FILTER = "invert_filter";

    public ExampleRangeFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        int[] partition = new int[exampleSet.size()];
        int startIndex = this.getParameterAsInt(PARAMETER_FIRST_EXAMPLE);
        int endIndex = this.getParameterAsInt(PARAMETER_LAST_EXAMPLE);
        if (endIndex < startIndex) {
            throw new UserError((Operator)this, 210, PARAMETER_LAST_EXAMPLE, PARAMETER_FIRST_EXAMPLE);
        }
        int i = 0;
        while (i < partition.length) {
            partition[i] = i >= startIndex - 1 && i <= endIndex - 1 ? 0 : 1;
            ++i;
        }
        SplittedExampleSet result = new SplittedExampleSet(exampleSet, new Partition(partition, 2));
        if (this.getParameterAsBoolean(PARAMETER_INVERT_FILTER)) {
            result.selectSingleSubset(1);
        } else {
            result.selectSingleSubset(0);
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> parameterTypes = super.getParameterTypes();
        parameterTypes.add(new ParameterTypeInt(PARAMETER_FIRST_EXAMPLE, "The first example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        parameterTypes.add(new ParameterTypeInt(PARAMETER_LAST_EXAMPLE, "The last example of the resulting example set.", 1, Integer.MAX_VALUE, false));
        parameterTypes.add(new ParameterTypeBoolean(PARAMETER_INVERT_FILTER, "Indicates if the filter should be inverted.", false));
        return parameterTypes;
    }
}

