/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.normalization;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.PreprocessingOperator;
import com.rapidminer.operator.preprocessing.normalization.MinMaxNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.ProportionNormalizationModel;
import com.rapidminer.operator.preprocessing.normalization.ZTransformationModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.tools.container.Tupel;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Normalization
extends PreprocessingOperator {
    public static final String[] NORMALIZATION_METHODS = new String[]{"Z-Transformation", "Range-Transformation", "Proportion-Transformation"};
    public static final String PARAMETER_NORMALIZATION_METHOD = "method";
    public static final String PARAMETER_MIN = "min";
    public static final String PARAMETER_MAX = "max";

    public Normalization(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model createPreprocessingModel(ExampleSet exampleSet) throws OperatorException {
        int method = this.getParameterAsInt(PARAMETER_NORMALIZATION_METHOD);
        if (method == 0) {
            exampleSet.recalculateAllAttributeStatistics();
            HashMap<String, Tupel<Double, Double>> attributeMeanVarianceMap = new HashMap<String, Tupel<Double, Double>>();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNumerical()) continue;
                attributeMeanVarianceMap.put(attribute.getName(), new Tupel<Double, Double>(exampleSet.getStatistics(attribute, "average"), exampleSet.getStatistics(attribute, "variance")));
            }
            ZTransformationModel model = new ZTransformationModel(exampleSet, attributeMeanVarianceMap);
            return model;
        }
        if (method == 1) {
            double min = this.getParameterAsDouble(PARAMETER_MIN);
            double max = this.getParameterAsDouble(PARAMETER_MAX);
            if (max <= min) {
                throw new UserError((Operator)this, 116, PARAMETER_MAX, "Must be greater than 'min'");
            }
            HashMap<String, Tupel<Double, Double>> attributeRanges = new HashMap<String, Tupel<Double, Double>>();
            exampleSet.recalculateAllAttributeStatistics();
            for (Attribute attribute : exampleSet.getAttributes()) {
                if (!attribute.isNumerical()) continue;
                attributeRanges.put(attribute.getName(), new Tupel<Double, Double>(exampleSet.getStatistics(attribute, "minimum"), exampleSet.getStatistics(attribute, "maximum")));
            }
            return new MinMaxNormalizationModel(exampleSet, min, max, attributeRanges);
        }
        Attributes attributes = exampleSet.getAttributes();
        double[] attributeSum = new double[attributes.size()];
        for (Example example : exampleSet) {
            int i = 0;
            for (Attribute attribute : attributes) {
                if (attribute.isNumerical()) {
                    int n = i;
                    attributeSum[n] = attributeSum[n] + example.getValue(attribute);
                }
                ++i;
            }
        }
        HashMap<String, Double> attributeSums = new HashMap<String, Double>();
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            if (attribute.isNumerical()) {
                attributeSums.put(attribute.getName(), attributeSum[i]);
            }
            ++i;
        }
        return new ProportionNormalizationModel(exampleSet, attributeSums);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_NORMALIZATION_METHOD, "Select the normalization method.", NORMALIZATION_METHODS, 0));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_MIN, "The minimum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_NORMALIZATION_METHOD, true, 1));
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_MAX, "The maximum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.registerDependencyCondition(new EqualTypeCondition(this, PARAMETER_NORMALIZATION_METHOD, true, 1));
        types.add(type);
        return types;
    }
}

