/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.Tools;
import com.rapidminer.operator.validation.ValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.math.AverageVector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchSlidingWindowValidation
extends ValidationChain {
    public static final String PARAMETER_CUMULATIVE_TRAINING = "cumulative_training";
    public static final String PARAMETER_AVERAGE_PERFORMANCES_ONLY = "average_performances_only";
    private int iteration;

    public BatchSlidingWindowValidation(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("iteration", "The number of the current iteration."){

            public double getDoubleValue() {
                return BatchSlidingWindowValidation.this.iteration;
            }
        });
    }

    @Override
    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        Attribute batchAttribute = inputSet.getAttributes().getSpecial("batch");
        if (batchAttribute == null) {
            throw new UserError((Operator)this, 113, "batch");
        }
        SplittedExampleSet splittedES = SplittedExampleSet.splitByAttribute((ExampleSet)inputSet.clone(), batchAttribute);
        splittedES.clearSelection();
        ArrayList<AverageVector> averageVectors = new ArrayList<AverageVector>();
        this.iteration = 0;
        while (this.iteration < splittedES.getNumberOfSubsets() - 1) {
            if (this.getParameterAsBoolean(PARAMETER_CUMULATIVE_TRAINING)) {
                splittedES.clearSelection();
                int s = 0;
                while (s <= this.iteration) {
                    splittedES.selectAdditionalSubset(s);
                    ++s;
                }
            } else {
                splittedES.selectSingleSubset(this.iteration);
            }
            this.learn(splittedES);
            splittedES.selectSingleSubset(this.iteration + 1);
            IOContainer evalOutput = this.evaluate(splittedES);
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY));
            this.inApplyLoop();
            ++this.iteration;
        }
        PerformanceVector averagePerformance = Tools.getPerformanceVector(averageVectors);
        if (averagePerformance != null) {
            this.setResult(averagePerformance);
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(PARAMETER_CUMULATIVE_TRAINING, "Indicates if each training batch should be added to the old one or should replace the old one.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_AVERAGE_PERFORMANCES_ONLY, "Indicates if only performance vectors should be averaged or all types of averagable result vectors", true));
        return types;
    }
}

