/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPairwiseMatrixOperator
extends Operator {
    public AbstractPairwiseMatrixOperator(OperatorDescription description) {
        super(description);
    }

    public abstract String getMatrixName();

    public abstract double getMatrixValue(ExampleSet var1, Attribute var2, Attribute var3);

    protected ExampleSet performPreprocessing(ExampleSet exampleSet) throws OperatorException {
        return exampleSet;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        ExampleSet exampleSet = this.performPreprocessing(eSet);
        NumericalMatrix matrix = new NumericalMatrix(this.getMatrixName(), exampleSet, true);
        int k = 0;
        for (Attribute firstAttribute : exampleSet.getAttributes()) {
            int l = 0;
            for (Attribute secondAttribute : exampleSet.getAttributes()) {
                matrix.setValue(k, l, this.getMatrixValue(exampleSet, firstAttribute, secondAttribute));
                this.checkForStop();
                ++l;
            }
            ++k;
        }
        return new IOObject[]{eSet, matrix};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, NumericalMatrix.class};
    }
}

