/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.wordfilter;

import com.rapidminer.operator.AbstractTokenProcessor;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeInt;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.TokenEnumerationAdapter;
import edu.udo.cs.wvtool.util.WVToolException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenLengthFilter
extends AbstractTokenProcessor {
    public static final String PARAMETER_MIN_CHARS = "min_chars";
    public static final String PARAMETER_MAX_CHARS = "max_chars";
    private int minNumberOfChars = 0;
    private int maxNumberOfChars = Integer.MAX_VALUE;

    public TokenLengthFilter(OperatorDescription description) {
        super(description);
    }

    @Override
    protected TokenEnumeration process(TokenEnumeration tokens, WVTDocumentInfo docInfo) throws WVToolException {
        LinkedList<String> outputTokens = new LinkedList<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.length() < this.minNumberOfChars || token.length() > this.maxNumberOfChars) continue;
            outputTokens.add(token);
        }
        return new TokenEnumerationAdapter(outputTokens);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.minNumberOfChars = this.getParameterAsInt(PARAMETER_MIN_CHARS);
        this.maxNumberOfChars = this.getParameterAsInt(PARAMETER_MAX_CHARS);
        return super.apply();
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_MIN_CHARS, "The minimal number of characters that a token must contain to be considered.", 0, Integer.MAX_VALUE, 4));
        types.add(new ParameterTypeInt(PARAMETER_MAX_CHARS, "The maximal number of characters that a token must contain to be considered.", 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        return types;
    }
}

