/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeNumber;

public class ParameterTypeInt
extends ParameterTypeNumber {
    private static final long serialVersionUID = -7360090072467405524L;
    private int defaultValue = -1;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private boolean noDefault = true;
    private boolean optional = true;

    public ParameterTypeInt(String key, String description, int min, int max) {
        this(key, description, min, max, -1);
        this.noDefault = true;
        this.optional = false;
    }

    public ParameterTypeInt(String key, String description, int min, int max, boolean optional) {
        this(key, description, min, max, -1);
        this.noDefault = true;
        this.optional = optional;
    }

    public ParameterTypeInt(String key, String description, int min, int max, int defaultValue) {
        super(key, description);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        this.noDefault = false;
        this.optional = true;
    }

    public void setMinValue(int min) {
        this.min = min;
    }

    public void getMaxValue(int max) {
        this.max = max;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public int getMinValueInt() {
        return this.min;
    }

    public int getMaxValueInt() {
        return this.max;
    }

    public int getDefaultInt() {
        return this.defaultValue;
    }

    public boolean isOptional() {
        return super.isOptional() && this.optional;
    }

    public Object getDefaultValue() {
        if (this.noDefault) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Integer)defaultValue;
    }

    public boolean isNumerical() {
        return true;
    }

    public String getRange() {
        String range = "integer; ";
        range = this.min == -2147483647 ? String.valueOf(range) + "-\u221e" : String.valueOf(range) + this.min;
        range = String.valueOf(range) + "-";
        range = this.max == Integer.MAX_VALUE ? String.valueOf(range) + "+\u221e" : String.valueOf(range) + this.max;
        if (!this.noDefault) {
            range = String.valueOf(range) + "; default: " + this.getStringRepresentation(this.defaultValue);
        }
        return range;
    }

    public String getStringRepresentation(int value) {
        String valueString = String.valueOf(value);
        if (value == Integer.MAX_VALUE) {
            valueString = "+\u221e";
        } else if (value == Integer.MIN_VALUE) {
            valueString = "-\u221e";
        }
        return valueString;
    }
}

