/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.GenericOperatorFactory;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.WekaTools;
import java.util.HashMap;
import java.util.Map;
import weka.associations.Associator;
import weka.attributeSelection.AttributeEvaluator;
import weka.classifiers.Classifier;
import weka.clusterers.Clusterer;

public class WekaOperatorFactory
implements GenericOperatorFactory {
    private static final String[] SKIPPED_META_CLASSIFIERS = new String[]{"weka.classifiers.meta.AttributeSelectedClassifier", "weka.classifiers.meta.CVParameterSelection", "weka.classifiers.meta.ClassificationViaRegression", "weka.classifiers.meta.FilteredClassifier", "weka.classifiers.meta.MultiScheme", "weka.classifiers.meta.Vote", "weka.classifiers.meta.Grading", "weka.classifiers.meta.Stacking", "weka.classifiers.meta.StackingC", "weka.classifiers.meta.RotationForest$ClassifierWrapper"};
    private static final String[] SKIPPED_CLASSIFIERS = new String[]{".meta.", ".pmml.", "weka.classifiers.functions.LibSVM", "MISVM", "UserClassifier", "LMTNode", "PreConstructedLinearModel", "RuleNode", "FTInnerNode", "FTLeavesNode", "FTNode", "weka.classifiers.functions.LibLINEAR"};
    private static final String[] SKIPPED_CLUSTERERS = new String[]{"weka.clusterers.FilteredClusterer", "weka.clusterers.OPTICS", "weka.clusterers.DBScan", "weka.clusterers.MakeDensityBasedClusterer"};
    private static final String[] SKIPPED_ASSOCIATORS = new String[]{"FilteredAssociator"};
    private static final String[] ENSEMBLE_CLASSIFIERS = new String[]{"weka.classifiers.meta.MultiScheme", "weka.classifiers.meta.Vote", "weka.classifiers.meta.Grading", "weka.classifiers.meta.Stacking", "weka.classifiers.meta.StackingC"};
    private static final Map<String, String> DEPRECATED_CLASSIFIER_INFOS = new HashMap<String, String>();

    static {
        DEPRECATED_CLASSIFIER_INFOS.put("weka.classifiers.bayes.NaiveBayesSimple", "Deprecated: please use NaiveBayes instead.");
        DEPRECATED_CLASSIFIER_INFOS.put("weka.classifiers.bayes.NaiveBayesUpdateable", "Deprecated: please use NaiveBayes instead.");
        DEPRECATED_CLASSIFIER_INFOS.put("weka.classifiers.bayes.NaiveBayes", "Deprecated: please use NaiveBayes instead.");
    }

    public void registerOperators(ClassLoader classLoader) {
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(Classifier.class, null, SKIPPED_CLASSIFIERS), DEPRECATED_CLASSIFIER_INFOS, "com.rapidminer.operator.learner.weka.GenericWekaLearner", "The weka learner", "Learner.Supervised.Weka.", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka learners: " + e, 5);
        }
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(Classifier.class, new String[]{".meta."}, SKIPPED_META_CLASSIFIERS), "com.rapidminer.operator.learner.weka.GenericWekaMetaLearner", "The weka meta learner", "Learner.Supervised.Weka.", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka meta learners: " + e, 5);
        }
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(Classifier.class, ENSEMBLE_CLASSIFIERS, null), "com.rapidminer.operator.learner.weka.GenericWekaEnsembleLearner", "The weka ensemble learner", "Learner.Supervised.Weka.", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka ensemble learners: " + e, 5);
        }
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(Associator.class, null, SKIPPED_ASSOCIATORS), "com.rapidminer.operator.learner.weka.GenericWekaAssociationLearner", "The weka associator", "Learner.Unsupervised.Itemsets.Weka", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka association rule learners: " + e, 5);
        }
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(AttributeEvaluator.class), "com.rapidminer.operator.features.weighting.GenericWekaAttributeWeighting", "The weka attribute evaluator", "Preprocessing.Attributes.Weighting.Weka", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka feature weighting schemes: " + e, 5);
        }
        try {
            WekaTools.registerWekaOperators(classLoader, WekaTools.getWekaClasses(Clusterer.class, SKIPPED_CLUSTERERS, false), "com.rapidminer.operator.clustering.clusterer.GenericWekaClustererAdaptor", "The weka clusterer", "Learner.Unsupervised.Clustering.Weka", null);
        }
        catch (Throwable e) {
            LogService.getGlobal().log("Cannot register Weka clusterers: " + e, 5);
        }
    }
}

