/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import marytts.signalproc.adaptation.Context;
import marytts.util.io.MaryRandomAccessFile;

public class WeightedCodebookSpeakerItem {
    public double[] lsfs;
    public double[] mfccs;
    public double f0;
    public double duration;
    public double energy;
    public String phn;
    public Context context;

    public WeightedCodebookSpeakerItem() {
        this(0, 0);
    }

    public WeightedCodebookSpeakerItem(int lpOrder, int mffcDimension) {
        this.allocate(lpOrder, mffcDimension);
        this.phn = "";
    }

    public void allocate(int lpOrder, int mfccDimension) {
        this.allocateLsfs(lpOrder);
        this.allocateMfccs(mfccDimension);
    }

    public void allocateLsfs(int lpOrder) {
        if (this.lsfs == null || lpOrder != this.lsfs.length) {
            this.lsfs = (double[])(lpOrder > 0 ? new double[lpOrder] : null);
        }
    }

    public void allocateMfccs(int mffcDimension) {
        if (this.mfccs == null || mffcDimension != this.mfccs.length) {
            this.mfccs = (double[])(mffcDimension > 0 ? new double[mffcDimension] : null);
        }
    }

    public void setLsfs(double[] lsfsIn) {
        if (lsfsIn != null) {
            if (this.lsfs == null || lsfsIn.length != this.lsfs.length) {
                this.allocateLsfs(lsfsIn.length);
            }
            System.arraycopy(lsfsIn, 0, this.lsfs, 0, lsfsIn.length);
        } else {
            this.lsfs = null;
        }
    }

    public void setMfccs(double[] mfccsIn) {
        if (mfccsIn != null) {
            if (this.mfccs == null || mfccsIn.length != this.mfccs.length) {
                this.allocateMfccs(mfccsIn.length);
            }
            System.arraycopy(mfccsIn, 0, this.mfccs, 0, mfccsIn.length);
        } else {
            this.mfccs = null;
        }
    }

    public void write(MaryRandomAccessFile ler) {
        if (this.lsfs != null || this.mfccs != null) {
            if (this.lsfs != null) {
                try {
                    ler.writeInt(this.lsfs.length);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ler.writeDouble(this.lsfs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    ler.writeInt(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.mfccs != null) {
                try {
                    ler.writeInt(this.mfccs.length);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    ler.writeDouble(this.mfccs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    ler.writeInt(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                ler.writeDouble(this.f0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ler.writeDouble(this.duration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ler.writeDouble(this.energy);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int tmpLen = 0;
            if (this.phn != "") {
                tmpLen = this.phn.length();
            }
            try {
                ler.writeInt(tmpLen);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tmpLen > 0) {
                try {
                    ler.writeChar(this.phn.toCharArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            tmpLen = 0;
            if (this.context != null && this.context.allContext != "") {
                tmpLen = this.context.allContext.length();
            }
            try {
                ler.writeInt(tmpLen);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tmpLen > 0) {
                try {
                    ler.writeChar(this.context.allContext.toCharArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void read(MaryRandomAccessFile ler, int lpOrder, int mfccDimension) {
        this.allocate(lpOrder, mfccDimension);
        if (this.lsfs != null && lpOrder > 0 || this.mfccs != null && mfccDimension > 0) {
            int lpOrderInFile = 0;
            try {
                lpOrderInFile = ler.readInt();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            assert (lpOrderInFile == lpOrder);
            if (lpOrderInFile > 0) {
                try {
                    this.lsfs = ler.readDouble(lpOrderInFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.lsfs = null;
            }
            int mfccDimensionInFile = 0;
            try {
                mfccDimensionInFile = ler.readInt();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            assert (mfccDimensionInFile == mfccDimension);
            if (mfccDimensionInFile > 0) {
                try {
                    this.mfccs = ler.readDouble(mfccDimensionInFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.mfccs = null;
            }
            try {
                this.f0 = ler.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.duration = ler.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.energy = ler.readDouble();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            int tmpLen = 0;
            try {
                tmpLen = ler.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.phn = "";
            if (tmpLen > 0) {
                try {
                    this.phn = String.copyValueOf(ler.readChar(tmpLen));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            tmpLen = 0;
            try {
                tmpLen = ler.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.context = null;
            if (tmpLen > 0) {
                try {
                    this.context = new Context(String.copyValueOf(ler.readChar(tmpLen)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

