/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.VocalTractScalingProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import org.apache.commons.io.FilenameUtils;

public class VocalTractLinearScalerEffect
extends BaseAudioEffect {
    float amount;
    public static float MAX_AMOUNT = 4.0f;
    public static float MIN_AMOUNT = 0.25f;
    public static float DEFAULT_AMOUNT = 1.5f;

    public VocalTractLinearScalerEffect() {
        this(16000);
    }

    public VocalTractLinearScalerEffect(int samplingRate) {
        super(samplingRate);
        this.setExampleParameters("amount" + chParamEquals + Float.toString(DEFAULT_AMOUNT) + chParamSeparator);
        this.strHelpText = this.getHelpText();
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.amount = this.expectFloatParameter("amount");
        if (this.amount == NULL_FLOAT_PARAM) {
            this.amount = DEFAULT_AMOUNT;
        }
    }

    @Override
    public DoubleDataSource process(DoubleDataSource inputAudio) {
        this.amount = MathUtils.CheckLimits(this.amount, MIN_AMOUNT, MAX_AMOUNT);
        double[] vscales = new double[]{this.amount};
        int frameLength = SignalProcUtils.getDFTSize(this.fs);
        int predictionOrder = SignalProcUtils.getLPOrder(this.fs);
        VocalTractScalingProcessor p = new VocalTractScalingProcessor(predictionOrder, this.fs, frameLength, vscales);
        FrameOverlapAddSource foas = new FrameOverlapAddSource(inputAudio, 3, true, frameLength, this.fs, p);
        return new BufferedDoubleDataSource(foas);
    }

    @Override
    public String getHelpText() {
        String strHelp = "Vocal Tract Linear Scaling Effect:" + strLineBreak + "Creates a shortened or lengthened vocal tract effect by shifting the formants." + strLineBreak + "Parameter:" + strLineBreak + "   <amount>" + "   Definition : The amount of formant shifting" + strLineBreak + "   Range      : [" + String.valueOf(MIN_AMOUNT) + "," + String.valueOf(MAX_AMOUNT) + "]" + strLineBreak + "   For values of <amount> less than 1.0, the formants are shifted to lower frequencies" + strLineBreak + "       resulting in a longer vocal tract (i.e. a deeper voice)." + strLineBreak + "   Values greater than 1.0 shift the formants to higher frequencies." + strLineBreak + "       The result is a shorter vocal tract.\n" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "TractScaler";
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java " + VocalTractLinearScalerEffect.class.getName() + " <factor> <filename>");
            System.exit(1);
        }
        float factor = Float.parseFloat(args[0]);
        String filename = args[1];
        AudioDoubleDataSource input = new AudioDoubleDataSource(AudioSystem.getAudioInputStream(new File(filename)));
        AudioFormat format = input.getAudioFormat();
        VocalTractLinearScalerEffect effect = new VocalTractLinearScalerEffect((int)format.getSampleRate());
        DoubleDataSource output = effect.apply(input, "amount:" + factor);
        DDSAudioInputStream audioOut = new DDSAudioInputStream(output, format);
        String outFilename = FilenameUtils.removeExtension(filename) + "_" + factor + ".wav";
        AudioSystem.write((AudioInputStream)audioOut, AudioFileFormat.Type.WAVE, new File(outFilename));
        System.out.println("Created file " + outFilename);
    }
}

