/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 4;
    long schemaChangeTimestamp;
    int[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.typeLookup.add(SqlInvariants.CARDINAL_NUMBER);
            schema.typeLookup.add(SqlInvariants.YES_OR_NO);
            schema.typeLookup.add(SqlInvariants.CHARACTER_DATA);
            schema.typeLookup.add(SqlInvariants.SQL_IDENTIFIER);
            schema.typeLookup.add(SqlInvariants.TIME_STAMP);
            schema.charsetLookup.add(SqlInvariants.SQL_TEXT);
            schema.charsetLookup.add(SqlInvariants.SQL_IDENTIFIER_CHARSET);
            schema.charsetLookup.add(SqlInvariants.SQL_CHARACTER);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    public void createPublicSchema() {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
        Schema schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
        this.defaultSchemaHsqlName = schema.getName();
        this.schemaMap.put(schema.getName().name, schema);
    }

    public void createSchema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        Schema schema = new Schema(hsqlName, grantee);
        this.schemaMap.add(hsqlName.name, schema);
    }

    public void dropSchema(Session session, String string, boolean bl) {
        Object object;
        Object object2;
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            throw Error.error(5501, string);
        }
        if (SqlInvariants.isLobsSchemaName(string)) {
            throw Error.error(5503, string);
        }
        if (!bl && !schema.isEmpty()) {
            throw Error.error(4200);
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.getCascadingSchemaReferences(schema.getName(), orderedHashSet);
        this.removeSchemaObjects(orderedHashSet);
        Iterator iterator = schema.schemaObjectIterator(3);
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            object = ((Table)object2).getFKConstraints();
            for (int i = 0; i < ((Constraint[])object).length; ++i) {
                Constraint constraint = object[i];
                if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                constraint.getMain().removeConstraint(constraint.getMainName().name);
            }
            this.removeTable(session, (Table)object2);
        }
        object2 = schema.schemaObjectIterator(7);
        while (object2.hasNext()) {
            object = (NumberSequence)object2.next();
            this.database.getGranteeManager().removeDbObject(((NumberSequence)object).getName());
        }
        schema.clearStructures();
        this.schemaMap.remove(string);
        if (this.defaultSchemaHsqlName.name.equals(string)) {
            object = this.database.nameManager.newHsqlName(string, false, 2);
            schema = new Schema((HsqlNameManager.HsqlName)object, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
        }
        this.database.getUserManager().removeSchemaReference(string);
        this.database.getSessionManager().removeSchemaReference(schema);
    }

    public void renameSchema(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.name);
        Schema schema2 = (Schema)this.schemaMap.get(hsqlName2.name);
        if (schema == null) {
            throw Error.error(5501, hsqlName.name);
        }
        if (schema2 != null) {
            throw Error.error(5504, hsqlName2.name);
        }
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        SqlInvariants.checkSchemaNameNotSystem(hsqlName2.name);
        int n = this.schemaMap.getIndex(hsqlName.name);
        schema.getName().rename(hsqlName2);
        this.schemaMap.set(n, hsqlName2.name, schema);
    }

    public void clearStructures() {
        Iterator iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            schema.clearStructures();
        }
    }

    public Iterator allSchemaNameIterator() {
        return this.schemaMap.keySet().iterator();
    }

    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            throw Error.error(4850, string);
        }
        if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
            throw Error.error(4850, string);
        }
        return schema.getName();
    }

    public Grantee toSchemaOwner(String string) {
        if (SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.name.equals(string)) {
            return SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner;
        }
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema == null ? null : schema.getOwner();
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.defaultSchemaHsqlName = hsqlName;
    }

    public boolean schemaExists(String string) {
        return "INFORMATION_SCHEMA".equals(string) || this.schemaMap.containsKey(string);
    }

    public HsqlNameManager.HsqlName findSchemaHsqlName(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            return null;
        }
        return schema.getName();
    }

    public HsqlNameManager.HsqlName getSchemaHsqlName(String string) {
        if (string == null) {
            return this.defaultSchemaHsqlName;
        }
        if ("INFORMATION_SCHEMA".equals(string)) {
            return SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        }
        Schema schema = (Schema)this.schemaMap.get(string);
        if (schema == null) {
            throw Error.error(4850, string);
        }
        return schema.getName();
    }

    public String getSchemaName(String string) {
        return this.getSchemaHsqlName((String)string).name;
    }

    public Schema findSchema(String string) {
        return (Schema)this.schemaMap.get(string);
    }

    public Iterator fullSchemaNamesIterator() {
        return this.schemaMap.keySet().iterator();
    }

    boolean isSchemaAuthorisation(Grantee grantee) {
        Iterator iterator = this.allSchemaNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!grantee.equals(this.toSchemaOwner(string))) continue;
            return true;
        }
        return false;
    }

    public void dropSchemas(Session session, Grantee grantee, boolean bl) {
        HsqlArrayList hsqlArrayList = this.getSchemas(grantee);
        Iterator iterator = hsqlArrayList.iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            this.dropSchema(session, schema.getName().name, bl);
        }
    }

    public HsqlArrayList getSchemas(Grantee grantee) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            if (!grantee.equals(schema.getOwner())) continue;
            hsqlArrayList.add(schema);
        }
        return hsqlArrayList;
    }

    public boolean hasSchemas(Grantee grantee) {
        Iterator iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            if (!grantee.equals(schema.getOwner())) continue;
            return true;
        }
        return false;
    }

    public HsqlArrayList getAllTables() {
        Iterator iterator = this.allSchemaNameIterator();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (SqlInvariants.isLobsSchemaName(string) || SqlInvariants.isSystemSchemaName(string)) continue;
            HashMappedList hashMappedList = this.getTables(string);
            hsqlArrayList.addAll(hashMappedList.values());
        }
        return hsqlArrayList;
    }

    public HashMappedList getTables(String string) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema.tableList;
    }

    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = this.getAllTables();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.isTemp()) continue;
            orderedHashSet.add(table.getName());
        }
        orderedHashSet.add(this.database.getCatalogName());
        Object[] objectArray = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray);
        return objectArray;
    }

    private SchemaObjectSet getSchemaObjectSet(Schema schema, int n) {
        SchemaObjectSet schemaObjectSet = null;
        switch (n) {
            case 7: {
                schemaObjectSet = schema.sequenceLookup;
                break;
            }
            case 3: 
            case 4: {
                schemaObjectSet = schema.tableLookup;
                break;
            }
            case 14: {
                schemaObjectSet = schema.charsetLookup;
                break;
            }
            case 15: {
                schemaObjectSet = schema.collationLookup;
                break;
            }
            case 17: {
                schemaObjectSet = schema.procedureLookup;
                break;
            }
            case 16: {
                schemaObjectSet = schema.functionLookup;
                break;
            }
            case 12: 
            case 13: {
                schemaObjectSet = schema.typeLookup;
                break;
            }
            case 20: {
                schemaObjectSet = schema.indexLookup;
                break;
            }
            case 5: {
                schemaObjectSet = schema.constraintLookup;
                break;
            }
            case 8: {
                schemaObjectSet = schema.triggerLookup;
                break;
            }
            case 24: {
                schemaObjectSet = schema.specificRoutineLookup;
            }
        }
        return schemaObjectSet;
    }

    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
        schemaObjectSet.checkAdd(hsqlName);
    }

    public Table getTable(Session session, String string, String string2) {
        Table table = null;
        if ("MODULE".equals(string2) && (table = this.findSessionTable(session, string, null)) == null) {
            throw Error.error(5501, string);
        }
        if (string2 == null) {
            table = this.findSessionTable(session, string, null);
        }
        if (table == null) {
            string2 = session.getSchemaName(string2);
            table = this.findUserTable(session, string, string2);
        }
        if (table == null && "INFORMATION_SCHEMA".equals(string2) && this.database.dbInfo != null) {
            table = this.database.dbInfo.getSystemTable(session, string);
        }
        if (table == null) {
            throw Error.error(5501, string);
        }
        return table;
    }

    public Table getUserTable(Session session, HsqlNameManager.HsqlName hsqlName) {
        return this.getUserTable(session, hsqlName.name, hsqlName.schema.name);
    }

    public Table getUserTable(Session session, String string, String string2) {
        Table table = this.findUserTable(session, string, string2);
        if (table == null) {
            throw Error.error(5501, string);
        }
        return table;
    }

    public Table findUserTable(Session session, String string, String string2) {
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema == null) {
            return null;
        }
        int n = schema.tableList.getIndex(string);
        if (n == -1) {
            return null;
        }
        return (Table)schema.tableList.get(n);
    }

    public Table findSessionTable(Session session, String string, String string2) {
        return session.findSessionTable(string);
    }

    public void dropTableOrView(Session session, Table table, boolean bl) {
        session.commit(false);
        if (table.isView()) {
            this.removeSchemaObject(table.getName(), bl);
        } else {
            this.dropTable(session, table, bl);
        }
    }

    private void dropTable(Session session, Table table, boolean bl) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        int n2 = schema.tableList.getIndex(table.getName().name);
        OrderedHashSet orderedHashSet = table.getDependentExternalConstraints();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        this.getCascadingReferencingObjectNames(table.getName(), orderedHashSet2);
        if (!bl) {
            int n3;
            for (n3 = 0; n3 < orderedHashSet.size(); ++n3) {
                object3 = (Constraint)orderedHashSet.get(n3);
                object2 = ((Constraint)object3).getRef().getName();
                object = ((Constraint)object3).getRefName();
                if (((Constraint)object3).getConstraintType() != 1) continue;
                throw Error.error(5533, ((HsqlNameManager.HsqlName)object).schema.name + '.' + ((HsqlNameManager.HsqlName)object2).name + '.' + ((HsqlNameManager.HsqlName)object).name);
            }
            if (!orderedHashSet2.isEmpty()) {
                for (n3 = 0; n3 < orderedHashSet2.size(); ++n3) {
                    object3 = (HsqlNameManager.HsqlName)orderedHashSet2.get(n3);
                    if (((HsqlNameManager.HsqlName)object3).parent == table.getName()) continue;
                    throw Error.error(5502, ((HsqlNameManager.HsqlName)object3).getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet orderedHashSet3 = new OrderedHashSet();
        object3 = new OrderedHashSet();
        object2 = new OrderedHashSet();
        object = table.getReferences();
        TriggerDef[] triggerDefArray = table.getTriggers();
        for (n = 0; n < triggerDefArray.length; ++n) {
            ((HashSet)object).add(triggerDefArray[n].getName());
        }
        for (n = 0; n < orderedHashSet.size(); ++n) {
            Constraint constraint = (Constraint)orderedHashSet.get(n);
            Table table2 = constraint.getMain();
            if (table2 != table) {
                orderedHashSet3.add(table2);
            }
            if ((table2 = constraint.getRef()) != table) {
                orderedHashSet3.add(table2);
            }
            ((HashSet)object3).add(constraint.getMainName());
            ((HashSet)object3).add(constraint.getRefName());
            ((HashSet)object2).add(constraint.getRefIndex().getName());
        }
        TableWorks tableWorks = new TableWorks(session, table);
        orderedHashSet3 = tableWorks.makeNewTables(orderedHashSet3, (OrderedHashSet)object3, (OrderedHashSet)object2);
        tableWorks.setNewTablesInSchema(orderedHashSet3);
        tableWorks.updateConstraints(orderedHashSet3, (OrderedHashSet)object3);
        this.removeSchemaObjects(orderedHashSet2);
        this.removeSchemaObjects((OrderedHashSet)object);
        this.removeReferencedObject(table.getName());
        this.removeReferencingObject(table);
        schema.tableList.remove(n2);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(orderedHashSet3);
    }

    private void removeTable(Session session, Table table) {
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (table.hasLobColumn()) {
            RowIterator rowIterator = table.rowIterator(session);
            while (rowIterator.hasNext()) {
                Row row = rowIterator.getNextRow();
                Object[] objectArray = row.getData();
                session.sessionData.adjustLobUsageCount(table, objectArray, -1);
            }
        }
        this.database.persistentStoreCollection.releaseStore(table);
    }

    public void setTable(int n, Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        schema.tableList.set(n, table.getName().name, table);
    }

    public int getTableIndex(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        if (schema == null) {
            return -1;
        }
        HsqlNameManager.HsqlName hsqlName = table.getName();
        return schema.tableList.getIndex(hsqlName.name);
    }

    public void recompileDependentObjects(OrderedHashSet orderedHashSet) {
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            Table table = (Table)orderedHashSet.get(i);
            orderedHashSet2.addAll(this.getReferencingObjectNames(table.getName()));
        }
        Session session = this.database.sessionManager.getSysSession();
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
            switch (hsqlName.type) {
                case 4: 
                case 5: 
                case 6: 
                case 16: 
                case 17: 
                case 18: 
                case 24: {
                    SchemaObject schemaObject = this.getSchemaObject(hsqlName);
                    schemaObject.compile(session, null);
                }
            }
        }
    }

    public void recompileDependentObjects(Table table) {
        SchemaObject schemaObject;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.getCascadingReferencingObjectNames(table.getName(), orderedHashSet);
        Session session = this.database.sessionManager.getSysSession();
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            switch (hsqlName.type) {
                case 4: 
                case 5: 
                case 6: 
                case 16: 
                case 17: 
                case 18: 
                case 24: {
                    schemaObject = this.getSchemaObject(hsqlName);
                    schemaObject.compile(session, null);
                }
            }
        }
        HsqlArrayList hsqlArrayList = this.getAllTables();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            schemaObject = (Table)hsqlArrayList.get(i);
            ((Table)schemaObject).verifyConstraintsIntegrity();
        }
    }

    public NumberSequence getSequence(String string, String string2, boolean bl) {
        NumberSequence numberSequence;
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema != null && (numberSequence = (NumberSequence)schema.sequenceList.get(string)) != null) {
            return numberSequence;
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        return null;
    }

    public Type getUserDefinedType(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null) {
            return (Type)schemaObject;
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        return null;
    }

    public Type getDomain(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null && ((Type)schemaObject).isDomainType()) {
            return (Type)schemaObject;
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        return null;
    }

    public Type getDistinctType(String string, String string2, boolean bl) {
        SchemaObject schemaObject;
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema != null && (schemaObject = schema.typeLookup.getObject(string)) != null && ((Type)schemaObject).isDomainType()) {
            return (Type)schemaObject;
        }
        if (bl) {
            throw Error.error(5501, string);
        }
        return null;
    }

    public SchemaObject getSchemaObject(String string, String string2, int n) {
        SchemaObject schemaObject = this.findSchemaObject(string, string2, n);
        if (schemaObject == null) {
            throw Error.error(SchemaObjectSet.getGetErrorCode(n), string);
        }
        return schemaObject;
    }

    public SchemaObject findSchemaObject(String string, String string2, int n) {
        Schema schema = (Schema)this.schemaMap.get(string2);
        if (schema == null) {
            return null;
        }
        SchemaObjectSet schemaObjectSet = null;
        switch (n) {
            case 7: {
                return schema.sequenceLookup.getObject(string);
            }
            case 3: 
            case 4: {
                return schema.tableLookup.getObject(string);
            }
            case 14: {
                if (string.equals("SQL_IDENTIFIER")) {
                    return SqlInvariants.SQL_IDENTIFIER_CHARSET;
                }
                if (string.equals("SQL_TEXT")) {
                    return SqlInvariants.SQL_TEXT;
                }
                if (string.equals("LATIN1")) {
                    return SqlInvariants.LATIN1;
                }
                if (string.equals("ASCII_GRAPHIC")) {
                    return SqlInvariants.ASCII_GRAPHIC;
                }
                return schema.charsetLookup.getObject(string);
            }
            case 15: {
                return schema.collationLookup.getObject(string);
            }
            case 17: {
                return schema.procedureLookup.getObject(string);
            }
            case 16: {
                return schema.functionLookup.getObject(string);
            }
            case 18: {
                SchemaObject schemaObject = schema.procedureLookup.getObject(string);
                if (schemaObject == null) {
                    schemaObject = schema.functionLookup.getObject(string);
                }
                return schemaObject;
            }
            case 24: {
                return schema.specificRoutineLookup.getObject(string);
            }
            case 12: 
            case 13: {
                return schema.typeLookup.getObject(string);
            }
            case 20: {
                schemaObjectSet = schema.indexLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                return table.getIndex(string);
            }
            case 5: {
                schemaObjectSet = schema.constraintLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                if (table == null) {
                    return null;
                }
                return table.getConstraint(string);
            }
            case 8: {
                schemaObjectSet = schema.indexLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                return table.getTrigger(string);
            }
        }
        throw Error.runtimeError(201, "SchemaManager");
    }

    Table findUserTableForIndex(Session session, String string, String string2) {
        Schema schema = (Schema)this.schemaMap.get(string2);
        HsqlNameManager.HsqlName hsqlName = schema.indexLookup.getName(string);
        if (hsqlName == null) {
            return null;
        }
        return this.findUserTable(session, hsqlName.parent.name, string2);
    }

    void dropIndex(Session session, HsqlNameManager.HsqlName hsqlName) {
        Table table = this.getTable(session, hsqlName.parent.name, hsqlName.parent.schema.name);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.dropIndex(hsqlName.name);
    }

    void dropConstraint(Session session, HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Table table = this.getTable(session, hsqlName.parent.name, hsqlName.parent.schema.name);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.dropConstraint(hsqlName.name, bl);
    }

    void removeDependentObjects(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        schema.indexLookup.removeParent(hsqlName);
        schema.constraintLookup.removeParent(hsqlName);
        schema.triggerLookup.removeParent(hsqlName);
    }

    void removeExportedKeys(Table table) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        for (int i = 0; i < schema.tableList.size(); ++i) {
            Table table2 = (Table)schema.tableList.get(i);
            Constraint[] constraintArray = table2.getConstraints();
            for (int j = constraintArray.length - 1; j >= 0; --j) {
                Table table3 = constraintArray[j].getRef();
                if (table != table3) continue;
                table2.removeConstraint(j);
            }
        }
    }

    public Iterator databaseObjectIterator(String string, int n) {
        Schema schema = (Schema)this.schemaMap.get(string);
        return schema.schemaObjectIterator(n);
    }

    public Iterator databaseObjectIterator(int n) {
        Iterator iterator = this.schemaMap.values().iterator();
        WrapperIterator wrapperIterator = new WrapperIterator();
        while (iterator.hasNext()) {
            Schema schema = (Schema)iterator.next();
            wrapperIterator = new WrapperIterator(wrapperIterator, schema.schemaObjectIterator(n));
        }
        return wrapperIterator;
    }

    private void addReferences(SchemaObject schemaObject) {
        OrderedHashSet orderedHashSet = schemaObject.getReferences();
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            HsqlNameManager.HsqlName hsqlName2 = schemaObject.getName();
            if (schemaObject instanceof Routine) {
                hsqlName2 = ((Routine)schemaObject).getSpecificName();
            }
            this.referenceMap.put(hsqlName, hsqlName2);
        }
    }

    private void removeReferencedObject(HsqlNameManager.HsqlName hsqlName) {
        this.referenceMap.remove(hsqlName);
    }

    private void removeReferencingObject(SchemaObject schemaObject) {
        OrderedHashSet orderedHashSet = schemaObject.getReferences();
        if (orderedHashSet == null) {
            return;
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            HsqlNameManager.HsqlName hsqlName2 = schemaObject.getName();
            if (schemaObject instanceof Routine) {
                hsqlName2 = ((Routine)schemaObject).getSpecificName();
            }
            this.referenceMap.remove(hsqlName, hsqlName2);
            if (hsqlName2.parent == null) continue;
            this.referenceMap.remove(hsqlName, hsqlName2.parent);
        }
    }

    OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName hsqlName) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Iterator iterator = this.referenceMap.get(hsqlName);
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            orderedHashSet.add(hsqlName2);
        }
        return orderedHashSet;
    }

    public OrderedHashSet getReferencingObjectNames(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        Iterator iterator = this.referenceMap.get(hsqlName);
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)iterator.next();
            SchemaObject schemaObject = this.getSchemaObject(hsqlName3);
            OrderedHashSet orderedHashSet2 = schemaObject.getReferences();
            if (!orderedHashSet2.contains(hsqlName2)) continue;
            orderedHashSet.add(hsqlName3);
        }
        return orderedHashSet;
    }

    private boolean isReferenced(HsqlNameManager.HsqlName hsqlName) {
        return this.referenceMap.containsKey(hsqlName);
    }

    public void getCascadingReferencingObjectNames(HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        Iterator iterator = this.referenceMap.get(hsqlName);
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            boolean bl = orderedHashSet.add(hsqlName2);
            if (!bl) continue;
            orderedHashSet2.add(hsqlName2);
        }
        for (int i = 0; i < orderedHashSet2.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet2.get(i);
            this.getCascadingReferencingObjectNames(hsqlName3, orderedHashSet);
        }
    }

    private void getCascadingSchemaReferences(HsqlNameManager.HsqlName hsqlName, OrderedHashSet orderedHashSet) {
        Iterator iterator = this.referenceMap.keySet().iterator();
        while (iterator.hasNext()) {
            HsqlNameManager.HsqlName hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            if (hsqlName2.schema != hsqlName) continue;
            this.getCascadingReferencingObjectNames(hsqlName2, orderedHashSet);
        }
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName3.schema != hsqlName) continue;
            orderedHashSet.remove(i);
            --i;
        }
    }

    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName hsqlName, String string, int n, boolean bl) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.name);
        SchemaObjectSet schemaObjectSet = null;
        if (schema == null) {
            if (bl) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(n));
            }
            return null;
        }
        if (n == 18) {
            schemaObjectSet = schema.functionLookup;
            SchemaObject schemaObject = schema.functionLookup.getObject(string);
            if (schemaObject == null) {
                schemaObjectSet = schema.procedureLookup;
                schemaObject = schema.procedureLookup.getObject(string);
            }
        } else {
            schemaObjectSet = this.getSchemaObjectSet(schema, n);
        }
        if (bl) {
            schemaObjectSet.checkExists(string);
        }
        return schemaObjectSet.getName(string);
    }

    public SchemaObject getSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        if (schema == null) {
            return null;
        }
        switch (hsqlName.type) {
            case 7: {
                return (SchemaObject)schema.sequenceList.get(hsqlName.name);
            }
            case 3: 
            case 4: {
                return (SchemaObject)schema.tableList.get(hsqlName.name);
            }
            case 14: {
                return schema.charsetLookup.getObject(hsqlName.name);
            }
            case 15: {
                return schema.collationLookup.getObject(hsqlName.name);
            }
            case 17: {
                return schema.procedureLookup.getObject(hsqlName.name);
            }
            case 16: {
                return schema.functionLookup.getObject(hsqlName.name);
            }
            case 24: {
                return schema.specificRoutineLookup.getObject(hsqlName.name);
            }
            case 18: {
                SchemaObject schemaObject = schema.functionLookup.getObject(hsqlName.name);
                if (schemaObject == null) {
                    schemaObject = schema.procedureLookup.getObject(hsqlName.name);
                }
                return schemaObject;
            }
            case 12: 
            case 13: {
                return schema.typeLookup.getObject(hsqlName.name);
            }
            case 8: {
                hsqlName = schema.triggerLookup.getName(hsqlName.name);
                if (hsqlName == null) {
                    return null;
                }
                HsqlNameManager.HsqlName hsqlName2 = hsqlName.parent;
                Table table = (Table)schema.tableList.get(hsqlName2.name);
                return table.getTrigger(hsqlName.name);
            }
            case 5: {
                hsqlName = schema.constraintLookup.getName(hsqlName.name);
                if (hsqlName == null) {
                    return null;
                }
                HsqlNameManager.HsqlName hsqlName3 = hsqlName.parent;
                Table table = (Table)schema.tableList.get(hsqlName3.name);
                return table.getConstraint(hsqlName.name);
            }
            case 6: {
                return null;
            }
            case 20: {
                hsqlName = schema.indexLookup.getName(hsqlName.name);
                if (hsqlName == null) {
                    return null;
                }
                HsqlNameManager.HsqlName hsqlName4 = hsqlName.parent;
                Table table = (Table)schema.tableList.get(hsqlName4.name);
                return table.getIndex(hsqlName.name);
            }
        }
        return null;
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        OrderedHashSet orderedHashSet = this.getReferencingObjectNames(hsqlName, hsqlName2);
        if (!orderedHashSet.isEmpty()) {
            HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, hsqlName3.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName hsqlName) {
        OrderedHashSet orderedHashSet = this.getReferencingObjectNames(hsqlName);
        HsqlNameManager.HsqlName hsqlName2 = null;
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            hsqlName2 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            if (hsqlName2.parent != hsqlName) break;
            hsqlName2 = null;
        }
        if (hsqlName2 == null) {
            return;
        }
        throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator = this.referenceMap.values().iterator();
        HsqlNameManager.HsqlName hsqlName2 = null;
        block3: while (iterator.hasNext()) {
            hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
            switch (hsqlName2.type) {
                case 4: 
                case 8: 
                case 16: 
                case 17: 
                case 18: 
                case 24: {
                    if (hsqlName2.schema == hsqlName) break block3;
                }
                default: {
                    hsqlName2 = null;
                    continue block3;
                }
            }
        }
        if (hsqlName2 == null) {
            return;
        }
        throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
    }

    public void addSchemaObject(SchemaObject schemaObject) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
        switch (hsqlName.type) {
            case 16: 
            case 17: {
                RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                if (routineSchema == null) {
                    routineSchema = new RoutineSchema(hsqlName.type, hsqlName);
                    routineSchema.addSpecificRoutine(this.database, (Routine)schemaObject);
                    schemaObjectSet.checkAdd(hsqlName);
                    SchemaObjectSet schemaObjectSet2 = this.getSchemaObjectSet(schema, 24);
                    schemaObjectSet2.checkAdd(((Routine)schemaObject).getSpecificName());
                    schemaObjectSet.add(routineSchema);
                    schemaObjectSet2.add(schemaObject);
                } else {
                    SchemaObjectSet schemaObjectSet3 = this.getSchemaObjectSet(schema, 24);
                    HsqlNameManager.HsqlName hsqlName2 = ((Routine)schemaObject).getSpecificName();
                    if (hsqlName2 != null) {
                        schemaObjectSet3.checkAdd(hsqlName2);
                    }
                    routineSchema.addSpecificRoutine(this.database, (Routine)schemaObject);
                    schemaObjectSet3.add(schemaObject);
                }
                this.addReferences(schemaObject);
                return;
            }
            case 3: {
                OrderedHashSet orderedHashSet = schemaObject.getReferences();
                for (int i = 0; i < orderedHashSet.size(); ++i) {
                    HsqlNameManager.HsqlName hsqlName3 = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
                    if (hsqlName3.type != 9) continue;
                    int n = ((Table)schemaObject).findColumn(hsqlName3.name);
                    ColumnSchema columnSchema = ((Table)schemaObject).getColumn(n);
                    this.addSchemaObject(columnSchema);
                }
                break;
            }
            case 9: {
                if (!schemaObject.getReferences().isEmpty()) break;
                return;
            }
        }
        if (schemaObjectSet != null) {
            schemaObjectSet.add(schemaObject);
        }
        this.addReferences(schemaObject);
    }

    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName, boolean bl) {
        Object object;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        switch (hsqlName.type) {
            case 16: 
            case 17: 
            case 18: {
                object = (RoutineSchema)this.getSchemaObject(hsqlName);
                if (object == null) break;
                Routine[] routineArray = ((RoutineSchema)object).getSpecificRoutines();
                for (int i = 0; i < routineArray.length; ++i) {
                    this.getCascadingReferencingObjectNames(routineArray[i].getSpecificName(), orderedHashSet);
                }
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 24: {
                this.getCascadingReferencingObjectNames(hsqlName, orderedHashSet);
                break;
            }
            case 13: {
                HsqlNameManager.HsqlName hsqlName2;
                object = this.getReferencingObjectNames(hsqlName);
                Iterator iterator = ((HashSet)object).iterator();
                while (iterator.hasNext()) {
                    hsqlName2 = (HsqlNameManager.HsqlName)iterator.next();
                    if (hsqlName2.type != 9) continue;
                    iterator.remove();
                }
                if (((BaseHashMap)object).isEmpty()) break;
                hsqlName2 = (HsqlNameManager.HsqlName)((OrderedHashSet)object).get(0);
                throw Error.error(5502, hsqlName2.getSchemaQualifiedStatementName());
            }
        }
        if (orderedHashSet.isEmpty()) {
            this.removeSchemaObject(hsqlName);
            return;
        }
        if (!bl) {
            object = (HsqlNameManager.HsqlName)orderedHashSet.get(0);
            throw Error.error(5502, ((HsqlNameManager.HsqlName)object).getSchemaQualifiedStatementName());
        }
        orderedHashSet.add(hsqlName);
        this.removeSchemaObjects(orderedHashSet);
    }

    public void removeSchemaObjects(OrderedHashSet orderedHashSet) {
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)orderedHashSet.get(i);
            this.removeSchemaObject(hsqlName);
        }
    }

    public void removeSchemaObject(HsqlNameManager.HsqlName hsqlName) {
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        SchemaObject schemaObject = null;
        SchemaObjectSet schemaObjectSet = null;
        switch (hsqlName.type) {
            case 7: {
                schemaObjectSet = schema.sequenceLookup;
                schemaObject = schemaObjectSet.getObject(hsqlName.name);
                break;
            }
            case 3: 
            case 4: {
                schemaObjectSet = schema.tableLookup;
                schemaObject = schemaObjectSet.getObject(hsqlName.name);
                break;
            }
            case 9: {
                Table table = (Table)this.getSchemaObject(hsqlName.parent);
                if (table == null) break;
                schemaObject = table.getColumn(table.getColumnIndex(hsqlName.name));
                break;
            }
            case 14: {
                schemaObjectSet = schema.charsetLookup;
                schemaObject = schemaObjectSet.getObject(hsqlName.name);
                break;
            }
            case 15: {
                schemaObjectSet = schema.collationLookup;
                schemaObject = schemaObjectSet.getObject(hsqlName.name);
                break;
            }
            case 17: {
                schemaObjectSet = schema.procedureLookup;
                RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                schemaObject = routineSchema;
                Routine[] routineArray = routineSchema.getSpecificRoutines();
                for (int i = 0; i < routineArray.length; ++i) {
                    this.removeSchemaObject(routineArray[i].getSpecificName());
                }
                break;
            }
            case 16: {
                schemaObjectSet = schema.functionLookup;
                RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                schemaObject = routineSchema;
                Routine[] routineArray = routineSchema.getSpecificRoutines();
                for (int i = 0; i < routineArray.length; ++i) {
                    this.removeSchemaObject(routineArray[i].getSpecificName());
                }
                break;
            }
            case 24: {
                schemaObjectSet = schema.specificRoutineLookup;
                Routine routine = (Routine)schemaObjectSet.getObject(hsqlName.name);
                schemaObject = routine;
                routine.routineSchema.removeSpecificRoutine(routine);
                if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                this.removeSchemaObject(routine.getName());
                break;
            }
            case 12: 
            case 13: {
                schemaObjectSet = schema.typeLookup;
                schemaObject = schemaObjectSet.getObject(hsqlName.name);
                break;
            }
            case 20: {
                schemaObjectSet = schema.indexLookup;
                break;
            }
            case 5: {
                schemaObjectSet = schema.constraintLookup;
                if (hsqlName.parent.type == 3) {
                    Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                    schemaObject = table.getConstraint(hsqlName.name);
                    table.removeConstraint(hsqlName.name);
                    break;
                }
                if (hsqlName.parent.type != 13) break;
                Type type = (Type)schema.typeLookup.getObject(hsqlName.parent.name);
                schemaObject = type.userTypeModifier.getConstraint(hsqlName.name);
                type.userTypeModifier.removeConstraint(hsqlName.name);
                break;
            }
            case 8: {
                schemaObjectSet = schema.triggerLookup;
                Table table = (Table)schema.tableList.get(hsqlName.parent.name);
                schemaObject = table.getTrigger(hsqlName.name);
                if (schemaObject == null) break;
                table.removeTrigger((TriggerDef)schemaObject);
                break;
            }
            default: {
                throw Error.runtimeError(201, "SchemaManager");
            }
        }
        if (schemaObject != null) {
            this.database.getGranteeManager().removeDbObject(hsqlName);
            this.removeReferencingObject(schemaObject);
        }
        if (schemaObjectSet != null) {
            schemaObjectSet.remove(hsqlName.name);
        }
        this.removeReferencedObject(hsqlName);
    }

    public void renameSchemaObject(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName hsqlName2) {
        if (hsqlName.schema != hsqlName2.schema) {
            throw Error.error(5505, hsqlName2.schema.name);
        }
        this.checkObjectIsReferenced(hsqlName);
        Schema schema = (Schema)this.schemaMap.get(hsqlName.schema.name);
        SchemaObjectSet schemaObjectSet = this.getSchemaObjectSet(schema, hsqlName.type);
        schemaObjectSet.rename(hsqlName, hsqlName2);
    }

    public String[] getSQLArray() {
        Object[] objectArray;
        String[] stringArray;
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.schemaMap.values().iterator();
        iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (Schema)iterator.next();
            if (SqlInvariants.isSystemSchemaName(stringArray.getName().name) || SqlInvariants.isLobsSchemaName(stringArray.getName().name)) continue;
            hsqlArrayList.add(stringArray.getSQL());
            stringArray.addSimpleObjects(orderedHashSet2);
        }
        while ((stringArray = orderedHashSet2.iterator()).hasNext()) {
            objectArray = new OrderedHashSet();
            SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, (Iterator)stringArray, (OrderedHashSet)objectArray);
            orderedHashSet2.removeAll((Collection)objectArray);
            if (objectArray.size() != 0) continue;
            break;
        }
        iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (Schema)iterator.next();
            if (SqlInvariants.isLobsSchemaName(stringArray.getName().name) || SqlInvariants.isSystemSchemaName(stringArray.getName().name)) continue;
            hsqlArrayList.addAll(stringArray.getSQLArray(orderedHashSet, orderedHashSet2));
        }
        while ((stringArray = orderedHashSet2.iterator()).hasNext()) {
            objectArray = new OrderedHashSet();
            SchemaObjectSet.addAllSQL(orderedHashSet, orderedHashSet2, hsqlArrayList, (Iterator)stringArray, (OrderedHashSet)objectArray);
            orderedHashSet2.removeAll((Collection)objectArray);
            if (objectArray.size() != 0) continue;
            break;
        }
        iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (Schema)iterator.next();
            if (SqlInvariants.isLobsSchemaName(stringArray.getName().name) || SqlInvariants.isSystemSchemaName(stringArray.getName().name)) continue;
            objectArray = stringArray.getTriggerSQL();
            if (objectArray.length > 0) {
                hsqlArrayList.add(Schema.getSetSchemaSQL(stringArray.getName()));
                hsqlArrayList.addAll(objectArray);
            }
            hsqlArrayList.addAll(stringArray.getSequenceRestartSQL());
        }
        iterator = this.schemaMap.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (Schema)iterator.next();
            hsqlArrayList.addAll(stringArray.getSequenceRestartSQL());
        }
        if (this.defaultSchemaHsqlName != null) {
            stringArray = new StringBuffer();
            stringArray.append("SET").append(' ').append("DATABASE");
            stringArray.append(' ').append("DEFAULT").append(' ');
            stringArray.append("INITIAL").append(' ').append("SCHEMA");
            stringArray.append(' ').append(this.defaultSchemaHsqlName.statementName);
            hsqlArrayList.add(stringArray.toString());
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getTablePropsSQL(boolean bl) {
        HsqlArrayList hsqlArrayList = this.getAllTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Object[] objectArray;
            Table table = (Table)hsqlArrayList.get(i);
            if (table.isText()) {
                objectArray = table.getSQLForTextSource(bl);
                hsqlArrayList2.addAll(objectArray);
                continue;
            }
            objectArray = table.getSQLForReadOnly();
            if (objectArray == null) continue;
            hsqlArrayList2.add(objectArray);
        }
        String[] stringArray = new String[hsqlArrayList2.size()];
        hsqlArrayList2.toArray(stringArray);
        return stringArray;
    }

    public String[] getIndexRootsSQL() {
        Session session = this.database.sessionManager.getSysSession();
        int[][] nArray = this.getIndexRoots(session);
        HsqlArrayList hsqlArrayList = this.getAllTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        for (int i = 0; i < nArray.length; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (nArray[i] == null || nArray[i].length <= 0 || nArray[i][0] == -1) continue;
            String string = ((Table)hsqlArrayList.get(i)).getIndexRootsSQL(nArray[i]);
            hsqlArrayList2.add(string);
        }
        String[] stringArray = new String[hsqlArrayList2.size()];
        hsqlArrayList2.toArray(stringArray);
        return stringArray;
    }

    public String[] getCommentsArray() {
        Object object;
        HsqlArrayList hsqlArrayList = this.getAllTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            object = (Table)hsqlArrayList.get(i);
            if (object.getTableType() == 1) continue;
            int n = object.getColumnCount();
            for (int j = 0; j < n; ++j) {
                ColumnSchema columnSchema = object.getColumn(j);
                if (columnSchema.getName().comment == null) continue;
                stringBuffer.setLength(0);
                stringBuffer.append("COMMENT").append(' ').append("ON");
                stringBuffer.append(' ').append("COLUMN").append(' ');
                stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
                stringBuffer.append('.').append(columnSchema.getName().statementName);
                stringBuffer.append(' ').append("IS").append(' ');
                stringBuffer.append(StringConverter.toQuotedString(columnSchema.getName().comment, '\'', true));
                hsqlArrayList2.add(stringBuffer.toString());
            }
            if (object.getName().comment == null) continue;
            stringBuffer.setLength(0);
            stringBuffer.append("COMMENT").append(' ').append("ON");
            stringBuffer.append(' ').append("TABLE").append(' ');
            stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
            stringBuffer.append(' ').append("IS").append(' ');
            stringBuffer.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
            hsqlArrayList2.add(stringBuffer.toString());
        }
        Iterator iterator = this.databaseObjectIterator(18);
        while (iterator.hasNext()) {
            object = (SchemaObject)iterator.next();
            if (object.getName().comment == null) continue;
            stringBuffer.setLength(0);
            stringBuffer.append("COMMENT").append(' ').append("ON");
            stringBuffer.append(' ').append("ROUTINE").append(' ');
            stringBuffer.append(object.getName().getSchemaQualifiedStatementName());
            stringBuffer.append(' ').append("IS").append(' ');
            stringBuffer.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
            hsqlArrayList2.add(stringBuffer.toString());
        }
        object = new String[hsqlArrayList2.size()];
        hsqlArrayList2.toArray(object);
        return object;
    }

    public void setTempIndexRoots(int[][] nArray) {
        this.tempIndexRoots = nArray;
    }

    public int[][] getIndexRoots(Session session) {
        if (this.tempIndexRoots != null) {
            int[][] nArray = this.tempIndexRoots;
            this.tempIndexRoots = null;
            return nArray;
        }
        HsqlArrayList hsqlArrayList = this.getAllTables();
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() == 5) {
                int[] nArray = table.getIndexRootsArray();
                hsqlArrayList2.add(nArray);
                continue;
            }
            hsqlArrayList2.add(null);
        }
        int[][] nArrayArray = new int[hsqlArrayList2.size()][];
        hsqlArrayList2.toArray(nArrayArray);
        return nArrayArray;
    }

    public void setIndexRoots(int[][] nArray) {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 5) continue;
            int[] nArray2 = nArray[i];
            if (nArray == null) continue;
            table.setIndexRoots(nArray2);
        }
    }

    public void setDefaultTableType(int n) {
        this.defaultTableType = n;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }
}

