/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.graphs;

import com.rapidminer.ObjectVisualizer;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.graphs.DefaultObjectViewer;
import com.rapidminer.gui.graphs.GraphCreatorAdaptor;
import com.rapidminer.gui.graphs.GraphObjectViewer;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.SortableEdge;
import com.rapidminer.gui.tools.ExtendedJComboBox;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.visualization.dependencies.TransitionGraph;
import com.rapidminer.tools.ObjectVisualizerService;
import com.rapidminer.tools.Tools;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionGraphCreator
extends GraphCreatorAdaptor {
    private Factory<String> edgeFactory = new Factory<String>(){
        int i = 0;

        public String create() {
            return "E" + this.i++;
        }
    };
    private JSlider edgeSlider = new JSlider(0, 0, 1000, 100){
        private static final long serialVersionUID = -6931545310805789589L;

        public Dimension getMinimumSize() {
            return new Dimension(40, (int)super.getMinimumSize().getHeight());
        }

        public Dimension getPreferredSize() {
            return new Dimension(40, (int)super.getPreferredSize().getHeight());
        }

        public Dimension getMaximumSize() {
            return new Dimension(40, (int)super.getMaximumSize().getHeight());
        }
    };
    private JComboBox sourceFilter;
    private JSpinner numberOfHops = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
    private Graph<String, String> graph;
    private Attribute sourceAttribute;
    private Attribute targetAttribute;
    private Attribute strengthAttribute;
    private Attribute typeAttribute;
    private String nodeDescription;
    private ExampleSet exampleSet;
    private Map<String, String> edgeLabelMap = new HashMap<String, String>();
    private Map<String, Double> edgeStrengthMap = new HashMap<String, Double>();
    private Map<String, String> vertexLabelMap = new HashMap<String, String>();
    private DefaultObjectViewer objectViewer = new DefaultObjectViewer();

    public TransitionGraphCreator(TransitionGraph transitionGraph, ExampleSet exampleSet) {
        this.sourceAttribute = exampleSet.getAttributes().get(transitionGraph.getSourceAttribute());
        this.targetAttribute = exampleSet.getAttributes().get(transitionGraph.getTargetAttribute());
        if (transitionGraph.getStrengthAttribute() != null) {
            this.strengthAttribute = exampleSet.getAttributes().get(transitionGraph.getStrengthAttribute());
        }
        if (transitionGraph.getTypeAttribute() != null) {
            this.typeAttribute = exampleSet.getAttributes().get(transitionGraph.getTypeAttribute());
        }
        this.exampleSet = exampleSet;
        this.nodeDescription = transitionGraph.getNodeDescription();
        TreeSet<SourceId> sourceNames = new TreeSet<SourceId>();
        for (Example example : exampleSet) {
            String id = example.getValueAsString(this.sourceAttribute);
            String description = this.getNodeDescription(id);
            if (description == null) {
                sourceNames.add(new SourceId(id, id));
                continue;
            }
            sourceNames.add(new SourceId(id, description));
        }
        this.sourceFilter = new ExtendedJComboBox(200);
        this.sourceFilter.addItem(new SourceId("None", "None"));
        for (SourceId sourceId : sourceNames) {
            this.sourceFilter.addItem(sourceId);
        }
    }

    @Override
    public Graph<String, String> createGraph() {
        this.graph = new DirectedSparseGraph();
        this.updateGraph();
        return this.graph;
    }

    @Override
    public String getEdgeName(String id) {
        return this.edgeLabelMap.get(id);
    }

    @Override
    public String getVertexName(String id) {
        String storedName = this.vertexLabelMap.get(id);
        if (storedName == null) {
            return id;
        }
        return storedName;
    }

    @Override
    public String getVertexToolTip(String id) {
        return id;
    }

    @Override
    public int getLabelOffset() {
        return -1;
    }

    @Override
    public int getNumberOfOptionComponents() {
        return 6;
    }

    @Override
    public JComponent getOptionComponent(final GraphViewer viewer, int index) {
        if (index == 0) {
            return new JLabel("Source Filter:");
        }
        if (index == 1) {
            this.sourceFilter.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransitionGraphCreator.this.updateGraph();
                    viewer.updateLayout();
                }
            });
            return this.sourceFilter;
        }
        if (index == 2) {
            return new JLabel("Number of Hops:");
        }
        if (index == 3) {
            this.numberOfHops.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    TransitionGraphCreator.this.updateGraph();
                    viewer.updateLayout();
                }
            });
            return this.numberOfHops;
        }
        if (index == 4) {
            return new JLabel("Number of Edges:");
        }
        if (index == 5) {
            this.edgeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!TransitionGraphCreator.this.edgeSlider.getValueIsAdjusting()) {
                        TransitionGraphCreator.this.updateGraph();
                        viewer.updateLayout();
                    }
                }
            });
            return this.edgeSlider;
        }
        return null;
    }

    private void updateGraph() {
        Iterator<String> e = this.edgeLabelMap.keySet().iterator();
        while (e.hasNext()) {
            this.graph.removeEdge((Object)e.next());
        }
        this.edgeLabelMap.clear();
        this.edgeStrengthMap.clear();
        Iterator<String> v = this.vertexLabelMap.keySet().iterator();
        while (v.hasNext()) {
            this.graph.removeVertex((Object)v.next());
        }
        this.vertexLabelMap.clear();
        String sourceFilterName = null;
        if (this.sourceFilter.getSelectedIndex() > 0) {
            sourceFilterName = ((SourceId)this.sourceFilter.getSelectedItem()).getId();
        }
        LinkedList<SortableEdge> sortableEdges = new LinkedList<SortableEdge>();
        if (sourceFilterName == null) {
            for (Example example : this.exampleSet) {
                String source = example.getValueAsString(this.sourceAttribute);
                String target = example.getValueAsString(this.targetAttribute);
                double strength = 1.0;
                if (this.strengthAttribute != null) {
                    strength = example.getValue(this.strengthAttribute);
                }
                String type = null;
                if (this.typeAttribute != null) {
                    type = example.getValueAsString(this.typeAttribute);
                }
                Object edgeName = null;
                edgeName = type != null ? type : String.valueOf(strength);
                sortableEdges.add(new SortableEdge(source, target, (String)edgeName, strength, -1));
            }
        } else {
            LinkedList<String> newSources;
            LinkedList<String> sources = new LinkedList<String>();
            sources.add(sourceFilterName);
            int hop = 1;
            int maxHops = (Integer)this.numberOfHops.getValue();
            do {
                newSources = new LinkedList<String>();
                for (String currentSourceFilterName : sources) {
                    for (Example example : this.exampleSet) {
                        String source = example.getValueAsString(this.sourceAttribute);
                        if (currentSourceFilterName != null && !currentSourceFilterName.equals(source)) continue;
                        String target = example.getValueAsString(this.targetAttribute);
                        double strength = 1.0;
                        if (this.strengthAttribute != null) {
                            strength = example.getValue(this.strengthAttribute);
                        }
                        String type = null;
                        if (this.typeAttribute != null) {
                            type = example.getValueAsString(this.typeAttribute);
                        }
                        String edgeName = null;
                        edgeName = type != null ? type : String.valueOf(strength);
                        sortableEdges.add(new SortableEdge(source, target, edgeName, strength, -1));
                        newSources.add(target);
                    }
                }
                sources.clear();
            } while ((sources = ++hop > maxHops ? null : newSources) != null);
        }
        Collections.sort(sortableEdges);
        HashSet<String> allVertices = new HashSet<String>();
        int numberOfEdges = this.edgeSlider.getValue();
        int counter = 0;
        for (SortableEdge sortableEdge : sortableEdges) {
            if (counter > numberOfEdges) break;
            allVertices.add(sortableEdge.getFirstVertex());
            allVertices.add(sortableEdge.getSecondVertex());
            ++counter;
        }
        for (String vertex : allVertices) {
            this.graph.addVertex((Object)vertex);
            String description = this.getNodeDescription(vertex);
            if (description == null) {
                this.vertexLabelMap.put(vertex, vertex);
                continue;
            }
            this.vertexLabelMap.put(vertex, description);
        }
        counter = 0;
        double minStrength = Double.POSITIVE_INFINITY;
        double maxStrength = Double.NEGATIVE_INFINITY;
        HashMap<String, Double> strengthMap = new HashMap<String, Double>();
        for (SortableEdge sortableEdge : sortableEdges) {
            if (counter > numberOfEdges) break;
            String idString = (String)this.edgeFactory.create();
            this.graph.addEdge((Object)idString, (Object)sortableEdge.getFirstVertex(), (Object)sortableEdge.getSecondVertex(), EdgeType.DIRECTED);
            this.edgeLabelMap.put(idString, Tools.formatIntegerIfPossible(sortableEdge.getEdgeValue()));
            double strength = sortableEdge.getEdgeValue();
            minStrength = Math.min(minStrength, strength);
            maxStrength = Math.max(maxStrength, strength);
            strengthMap.put(idString, strength);
            ++counter;
        }
        for (String idString : strengthMap.keySet()) {
            this.edgeStrengthMap.put(idString, ((Double)strengthMap.get(idString) - minStrength) / (maxStrength - minStrength));
        }
    }

    private String getNodeDescription(String vertex) {
        ObjectVisualizer visualizer;
        if (this.nodeDescription != null && (visualizer = ObjectVisualizerService.getVisualizerForObject(vertex)) != null && visualizer.isCapableToVisualize(vertex)) {
            StringBuffer resultString = new StringBuffer();
            int currentIndex = 0;
            int startIndex = this.nodeDescription.indexOf("%{", currentIndex);
            while (startIndex >= currentIndex) {
                int endIndex = this.nodeDescription.indexOf("}", startIndex);
                if (endIndex >= startIndex) {
                    String fieldName = this.nodeDescription.substring(startIndex + 2, endIndex);
                    String fieldValue = visualizer.getDetailData(vertex, fieldName);
                    resultString.append(this.nodeDescription.substring(currentIndex, startIndex));
                    if (fieldValue != null) {
                        resultString.append(fieldValue);
                    } else {
                        resultString.append("?");
                    }
                    currentIndex = endIndex + 1;
                } else {
                    resultString.append(this.nodeDescription.substring(startIndex));
                    currentIndex = this.nodeDescription.length();
                }
                startIndex = this.nodeDescription.indexOf("%{", currentIndex);
            }
            if (currentIndex < this.nodeDescription.length()) {
                resultString.append(this.nodeDescription.substring(currentIndex));
            }
            return resultString.toString();
        }
        return null;
    }

    @Override
    public Transformer<String, Paint> getVertexPaintTransformer(VisualizationViewer<String, String> viewer) {
        return new Transformer<String, Paint>(){

            public Paint transform(String name) {
                if (TransitionGraphCreator.this.sourceFilter.getSelectedIndex() > 0 && ((SourceId)TransitionGraphCreator.this.sourceFilter.getSelectedItem()).getId().equals(name)) {
                    return SwingTools.LIGHT_YELLOW;
                }
                return SwingTools.LIGHT_BLUE;
            }
        };
    }

    @Override
    public boolean showEdgeLabelsDefault() {
        return false;
    }

    @Override
    public boolean showVertexLabelsDefault() {
        return true;
    }

    @Override
    public double getEdgeStrength(String id) {
        Double value = this.edgeStrengthMap.get(id);
        if (value == null) {
            return 1.0;
        }
        if (Double.isNaN(value)) {
            return 1.0;
        }
        return value;
    }

    @Override
    public int getEdgeShape() {
        return 1;
    }

    @Override
    public Object getObject(String id) {
        return id;
    }

    @Override
    public GraphObjectViewer getObjectViewer() {
        return this.objectViewer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourceId
    implements Comparable<SourceId> {
        private String id;
        private String label;

        public SourceId(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(SourceId o) {
            return this.label.compareTo(o.label);
        }
    }
}

