/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.properties;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.properties.SettingsPropertyTable;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTabbedPane;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.ParameterService;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class SettingsTabs
extends ExtendedJTabbedPane {
    private static final long serialVersionUID = -229446448782516589L;
    private List<SettingsPropertyTable> tables = new LinkedList<SettingsPropertyTable>();

    public SettingsTabs() {
        Set<ParameterType> allProperties = RapidMiner.getRapidMinerProperties();
        TreeMap<String, LinkedList<ParameterType>> groups = new TreeMap<String, LinkedList<ParameterType>>();
        for (ParameterType type : allProperties) {
            String key = type.getKey();
            String[] parts = key.split("\\.");
            String group = parts[1];
            LinkedList<ParameterType> list = (LinkedList<ParameterType>)groups.get(group);
            if (list == null) {
                list = new LinkedList<ParameterType>();
                groups.put(group, list);
            }
            list.add(type);
        }
        for (Map.Entry e : groups.entrySet()) {
            String group = (String)e.getKey();
            List groupList = (List)e.getValue();
            SettingsPropertyTable table = new SettingsPropertyTable(groupList);
            this.tables.add(table);
            String name = String.valueOf(new String(new char[]{group.charAt(0)}).toUpperCase()) + group.substring(1, group.length());
            this.addTab(name, new ExtendedJScrollPane(table));
        }
    }

    public void applyProperties() {
        Iterator<SettingsPropertyTable> i = this.tables.iterator();
        while (i.hasNext()) {
            i.next().applyProperties();
        }
    }

    public void save() throws IOException {
        this.applyProperties();
        Properties props = new Properties();
        Iterator<SettingsPropertyTable> i = this.tables.iterator();
        while (i.hasNext()) {
            i.next().applyProperties(props);
        }
        ParameterService.writeProperties(props, ParameterService.getMainUserConfigFile());
    }
}

