/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.meta.AbstractMetaLearner;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.GreaterSplitCondition;
import com.rapidminer.operator.learner.tree.LessEqualsSplitCondition;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import com.rapidminer.operator.learner.tree.TreeModel;
import com.rapidminer.operator.preprocessing.AttributeSubsetPreprocessing;
import com.rapidminer.operator.preprocessing.discretization.UserBasedDiscretization;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiwayDecisionTree
extends AbstractMetaLearner {
    public MultiwayDecisionTree(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        GroupedModel groupedModel = new GroupedModel();
        TreeModel model = (TreeModel)this.applyInnerLearner(exampleSet);
        HashMap<String, List<Double>> attributePointMap = new HashMap<String, List<Double>>();
        this.addNodeSplitPoints(model.getRoot(), attributePointMap);
        try {
            AttributeSubsetPreprocessing attributeSubsetPreprocessing = OperatorService.createOperator(AttributeSubsetPreprocessing.class);
            UserBasedDiscretization userbasedDiscretization = OperatorService.createOperator(UserBasedDiscretization.class);
            ((OperatorChain)attributeSubsetPreprocessing).addOperator(userbasedDiscretization);
            attributeSubsetPreprocessing.setParameter("condition_class", "3");
            attributeSubsetPreprocessing.setParameter("deliver_inner_results", "true");
            userbasedDiscretization.setParameter("return_preprocessing_model", "true");
            for (String currentAttribute : attributePointMap.keySet()) {
                String[] pointSpecifier;
                double[] splitPoints = new double[((List)attributePointMap.get(currentAttribute)).size()];
                int i = 0;
                for (Double splitPoint : (List)attributePointMap.get(currentAttribute)) {
                    splitPoints[i] = splitPoint;
                    ++i;
                }
                Arrays.sort(splitPoints);
                attributeSubsetPreprocessing.setParameter("attribute_name_regex", currentAttribute);
                LinkedList<String[]> borders = new LinkedList<String[]>();
                double lowerBorder = Double.NEGATIVE_INFINITY;
                i = 0;
                while (i < splitPoints.length) {
                    pointSpecifier = new String[]{String.valueOf(currentAttribute) + " in " + Tools.formatNumber(lowerBorder, 2) + " to " + Tools.formatNumber(splitPoints[i], 2), String.valueOf(splitPoints[i])};
                    lowerBorder = splitPoints[i];
                    borders.add(pointSpecifier);
                    ++i;
                }
                pointSpecifier = new String[]{String.valueOf(currentAttribute) + " in " + Tools.formatNumber(lowerBorder, 2) + " to " + Tools.formatNumber(Double.POSITIVE_INFINITY, 2), "Infinity"};
                borders.add(pointSpecifier);
                userbasedDiscretization.setParameter("classes", Parameters.transformList2String(borders));
                IOContainer results = attributeSubsetPreprocessing.apply(new IOContainer(exampleSet));
                exampleSet = results.get(ExampleSet.class);
                groupedModel.addModel(results.get(Model.class));
            }
            groupedModel.addModel(this.applyInnerLearner(exampleSet));
            return groupedModel;
        }
        catch (OperatorCreationException e) {
            throw new UserError((Operator)this, 904, "operators", e.getMessage());
        }
    }

    private void addNodeSplitPoints(Tree root, Map<String, List<Double>> attributePointMap) {
        if (!root.isLeaf()) {
            SplitCondition condition = root.childIterator().next().getCondition();
            if (condition instanceof GreaterSplitCondition) {
                this.addSplit(condition.getAttributeName(), ((GreaterSplitCondition)condition).getValue(), attributePointMap);
            } else if (condition instanceof LessEqualsSplitCondition) {
                this.addSplit(condition.getAttributeName(), ((LessEqualsSplitCondition)condition).getValue(), attributePointMap);
            }
        }
        Iterator<Edge> iterator = root.childIterator();
        while (iterator.hasNext()) {
            this.addNodeSplitPoints(iterator.next().getChild(), attributePointMap);
        }
    }

    private void addSplit(String attributeName, double value, Map<String, List<Double>> attributePointMap) {
        List<Double> valueList = attributePointMap.get(attributeName);
        if (valueList == null) {
            valueList = new LinkedList<Double>();
            attributePointMap.put(attributeName, valueList);
        }
        valueList.add(value);
    }
}

