/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter.attributes;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.filter.attributes.AbstractAttributeFilterCondition;
import com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilterCondition;
import com.rapidminer.parameter.ParameterType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericValueAttributeFilter
extends AbstractAttributeFilterCondition {
    private ArrayList<Condition> conditions;
    private boolean keep = true;
    private boolean conjunctiveMode;
    private Attribute lastCheckedAttribute = null;

    @Override
    public AttributeFilterCondition.ScanResult beforeScanCheck(Attribute attribute) throws UserError {
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public void init(Operator operator) throws UserError {
        String conditionString = operator.getParameterAsString("parameter_string");
        if (conditionString == null || conditionString.length() == 0) {
            throw new UserError(operator, 904, "The condition for numerical values needs a parameter string.");
        }
        if (conditionString.contains("||") && conditionString.contains("&&")) {
            throw new UserError(operator, 904, "|| and && not allowed in one condition");
        }
        this.conjunctiveMode = conditionString.contains("&&");
        this.conditions = new ArrayList();
        String[] stringArray = conditionString.split("[|&]{2}");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String conditionSubString = stringArray[n2];
            String[] parts = conditionSubString.trim().split("\\s+");
            if (parts.length != 2) {
                throw new UserError(operator, 904, "number of condition arguments not correct");
            }
            this.conditions.add(new Condition(parts[0], parts[1]));
            ++n2;
        }
    }

    @Override
    public AttributeFilterCondition.ScanResult check(Attribute attribute, Example example) {
        if (this.lastCheckedAttribute != attribute) {
            this.keep = true;
        }
        if (attribute.isNumerical()) {
            boolean exampleResult;
            double checkValue = example.getValue(attribute);
            if (this.conjunctiveMode) {
                exampleResult = true;
                for (Condition condition : this.conditions) {
                    exampleResult &= condition.check(checkValue);
                }
            } else {
                exampleResult = false;
                for (Condition condition : this.conditions) {
                    exampleResult |= condition.check(checkValue);
                }
            }
            this.keep &= exampleResult;
        }
        if (!this.keep && attribute.isNumerical()) {
            return AttributeFilterCondition.ScanResult.REMOVE;
        }
        return AttributeFilterCondition.ScanResult.UNCHECKED;
    }

    @Override
    public boolean isNeedingScan() {
        return true;
    }

    @Override
    public List<ParameterType> getParameterTypes(Operator operator) {
        return super.getParameterTypes(operator);
    }

    private static class Condition {
        private int condition;
        private double value;

        public Condition(String condition, String value) {
            this.value = Double.parseDouble(value);
            if (condition.equals("<>") || condition.equals("!=")) {
                this.condition = 1;
            } else if (condition.equals("<=")) {
                this.condition = 2;
            } else if (condition.equals("<")) {
                this.condition = 3;
            } else if (condition.equals(">=")) {
                this.condition = 4;
            } else if (condition.equals(">")) {
                this.condition = 5;
            } else if (condition.equals("=")) {
                this.condition = 0;
            }
        }

        public boolean check(double value) {
            if (Double.isNaN(value)) {
                return true;
            }
            switch (this.condition) {
                case 0: {
                    return value == this.value;
                }
                case 1: {
                    return value != this.value;
                }
                case 2: {
                    return value <= this.value;
                }
                case 3: {
                    return value < this.value;
                }
                case 4: {
                    return value >= this.value;
                }
                case 5: {
                    return value > this.value;
                }
            }
            return false;
        }
    }
}

