/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation.clustering;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterNumberEvaluator
extends Operator {
    private int numberOfClusters;

    public ClusterNumberEvaluator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("clusternumber", "The number of clusters.", false){

            public double getDoubleValue() {
                return ClusterNumberEvaluator.this.numberOfClusters;
            }
        });
    }

    public InputDescription getInputDescription(Class cls) {
        if (ClusterModel.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ClusterModel model = this.getInput(ClusterModel.class);
        this.numberOfClusters = model.getNumberOfClusters();
        int numItems = 0;
        int i = 0;
        while (i < model.getNumberOfClusters()) {
            numItems = model.getCluster(i).getNumberOfExamples();
            ++i;
        }
        PerformanceVector performance = null;
        try {
            performance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        if (performance == null) {
            performance = new PerformanceVector();
        }
        EstimatedPerformance pc = new EstimatedPerformance("Number of clusters", 1.0 - (double)model.getNumberOfClusters() / (double)numItems, 1, false);
        performance.addCriterion(pc);
        return new IOObject[]{performance};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ClusterModel.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }
}

