/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import java.io.IOException;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PitchStatistics {
    public static int STATISTICS_IN_HERTZ = 1;
    public static int STATISTICS_IN_LOGHERTZ = 2;
    public static int DEFAULT_STATISTICS = STATISTICS_IN_HERTZ;
    public int type;
    public boolean isSource;
    public boolean isGlobal;
    public double mean;
    public double standardDeviation;
    public double range;
    public double intercept;
    public double slope;

    public PitchStatistics(PitchStatistics existing) {
        this.type = existing.type;
        this.isSource = existing.isSource;
        this.isGlobal = existing.isGlobal;
        this.mean = existing.mean;
        this.standardDeviation = existing.standardDeviation;
        this.range = existing.range;
        this.intercept = existing.intercept;
        this.slope = existing.slope;
    }

    public PitchStatistics() {
        this(DEFAULT_STATISTICS, true, true);
    }

    public PitchStatistics(int typeIn, boolean isSourceIn, boolean isGlobalIn) {
        this.type = typeIn;
        this.init();
        this.isSource = isSourceIn;
        this.isGlobal = isGlobalIn;
    }

    public PitchStatistics(int typeIn, double[] f0s) {
        this(typeIn, true, true, f0s);
    }

    public PitchStatistics(int typeIn, boolean isSourceIn, boolean isGlobalIn, double[] f0s) {
        this.type = typeIn;
        this.init();
        this.isSource = isSourceIn;
        this.isGlobal = isGlobalIn;
        double[] voiceds = SignalProcUtils.getVoiceds(f0s);
        if (this.type == STATISTICS_IN_LOGHERTZ) {
            voiceds = SignalProcUtils.getLogF0s(voiceds);
        }
        if (voiceds != null) {
            this.mean = MathUtils.mean(voiceds);
            this.standardDeviation = MathUtils.standardDeviation(voiceds, this.mean);
            this.range = SignalProcUtils.getF0Range(voiceds);
            double[] contourInt = SignalProcUtils.interpolate_pitch_uv(f0s);
            double[] line = SignalProcUtils.getContourLSFit(contourInt, false);
            this.intercept = line[0];
            this.slope = line[1];
        } else {
            this.mean = 0.0;
            this.standardDeviation = 1.0;
        }
    }

    public void init() {
        this.mean = 0.0;
        this.standardDeviation = 0.0;
        this.range = 0.0;
        this.intercept = 0.0;
        this.slope = 0.0;
    }

    public void read(MaryRandomAccessFile ler) {
        try {
            this.type = ler.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.isSource = ler.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.isGlobal = ler.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.mean = ler.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.standardDeviation = ler.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.range = ler.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.intercept = ler.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.slope = ler.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(MaryRandomAccessFile ler) {
        try {
            ler.writeInt(this.type);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeBoolean(this.isSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeBoolean(this.isGlobal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeDouble(this.mean);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeDouble(this.standardDeviation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeDouble(this.range);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeDouble(this.intercept);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ler.writeDouble(this.slope);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

