/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import opennlp.tools.namefind.BigramNameFeatureGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.CachedFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorUtil;
import opennlp.tools.util.featuregen.OutcomePriorFeatureGenerator;
import opennlp.tools.util.featuregen.PreviousMapFeatureGenerator;
import opennlp.tools.util.featuregen.TokenClassFeatureGenerator;
import opennlp.tools.util.featuregen.TokenFeatureGenerator;
import opennlp.tools.util.featuregen.WindowFeatureGenerator;

public class DefaultNameContextGenerator
implements NameContextGenerator {
    private AdaptiveFeatureGenerator[] featureGenerators;
    @Deprecated
    private static AdaptiveFeatureGenerator windowFeatures = new CachedFeatureGenerator(new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenFeatureGenerator(), 2, 2), new WindowFeatureGenerator((AdaptiveFeatureGenerator)new TokenClassFeatureGenerator(true), 2, 2), new OutcomePriorFeatureGenerator(), new PreviousMapFeatureGenerator(), new BigramNameFeatureGenerator());

    @Deprecated
    public DefaultNameContextGenerator() {
        this(null);
    }

    public DefaultNameContextGenerator(AdaptiveFeatureGenerator ... featureGenerators) {
        this.featureGenerators = featureGenerators != null ? featureGenerators : new AdaptiveFeatureGenerator[]{windowFeatures, new PreviousMapFeatureGenerator()};
    }

    public void addFeatureGenerator(AdaptiveFeatureGenerator generator) {
        AdaptiveFeatureGenerator[] generators = this.featureGenerators;
        this.featureGenerators = new AdaptiveFeatureGenerator[this.featureGenerators.length + 1];
        System.arraycopy(generators, 0, this.featureGenerators, 0, generators.length);
        this.featureGenerators[this.featureGenerators.length - 1] = generator;
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        if (tokens != null && outcomes != null && tokens.length != outcomes.length) {
            throw new IllegalArgumentException("The tokens and outcome arrays MUST have the same size!");
        }
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].updateAdaptiveData(tokens, outcomes);
        }
    }

    public void clearAdaptiveData() {
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].clearAdaptiveData();
        }
    }

    public String[] getContext(int index, String[] tokens, String[] preds, Object[] additionalContext) {
        ArrayList<String> features = new ArrayList<String>();
        for (int i = 0; i < this.featureGenerators.length; ++i) {
            this.featureGenerators[i].createFeatures(features, tokens, index, preds);
        }
        String po = "other";
        String ppo = "other";
        if (index > 1) {
            ppo = preds[index - 2];
        }
        if (index > 0) {
            po = preds[index - 1];
        }
        features.add("po=" + po);
        features.add("pow=" + po + "," + tokens[index]);
        features.add("powf=" + po + "," + FeatureGeneratorUtil.tokenFeature(tokens[index]));
        features.add("ppo=" + ppo);
        return features.toArray(new String[features.size()]);
    }
}

