/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatortree;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class OperatorTreeModel
implements TreeModel {
    private Operator root;
    private List<TreeModelListener> treeModelListeners = new LinkedList<TreeModelListener>();
    private OperatorTree operatorTree;
    private boolean showDisabledOperators = true;

    public OperatorTreeModel(Operator root, OperatorTree tree) {
        this.root = root;
        this.operatorTree = tree;
    }

    public boolean showDisabledOperators() {
        return this.showDisabledOperators;
    }

    public void setShowDisabledOperators(boolean show) {
        this.showDisabledOperators = show;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof OperatorChain) {
            if (this.showDisabledOperators) {
                return ((OperatorChain)parent).getOperatorFromAll(index);
            }
            return ((OperatorChain)parent).getOperator(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof OperatorChain) {
            if (this.showDisabledOperators) {
                return ((OperatorChain)parent).getNumberOfAllOperators();
            }
            return ((OperatorChain)parent).getNumberOfOperators();
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof OperatorChain) {
            return ((OperatorChain)parent).getIndexOfOperator((Operator)child, this.showDisabledOperators);
        }
        return -1;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object node) {
        Operator op = (Operator)path.getLastPathComponent();
        String desiredName = ((String)node).trim();
        if (desiredName.length() > 0) {
            if (desiredName.indexOf(46) >= 0) {
                JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), "Renaming not possible: operator names are now allowed to contain the character '.'", "Renaming failed", 2);
            } else {
                String oldName = op.getName();
                String newName = op.rename(desiredName);
                RapidMinerGUI.getMainFrame().getProcess().notifyRenaming(oldName, newName);
                this.operatorTree.refresh(path);
                RapidMinerGUI.getMainFrame().processChanged();
            }
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    public void fireOperatorInserted(Object source, TreePath path, int index, Operator operator) {
        if (index >= 0) {
            Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
            while (i.hasNext()) {
                i.next().treeNodesInserted(new TreeModelEvent(source, path, new int[]{index}, new Object[]{operator}));
            }
        }
    }

    public void fireOperatorRemoved(Object source, TreePath path, int index, Operator operator) {
        if (index >= 0) {
            Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
            while (i.hasNext()) {
                i.next().treeNodesRemoved(new TreeModelEvent(source, path, new int[]{index}, new Object[]{operator}));
            }
        }
    }

    public void fireOperatorRenamed(Object source, TreePath path) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeNodesChanged(new TreeModelEvent(source, path));
        }
    }

    public void fireOperatorChanged(Object source, TreePath path) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeNodesChanged(new TreeModelEvent(source, path));
        }
    }

    public void fireStructureChanged(Object source, TreePath path) {
        Iterator<TreeModelListener> i = this.treeModelListeners.iterator();
        while (i.hasNext()) {
            i.next().treeStructureChanged(new TreeModelEvent(source, path));
        }
    }
}

