/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.models;

import com.rapidminer.gui.plotter.charts.DistributionPlotter;
import com.rapidminer.gui.renderer.AbstractRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.report.Reportable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionModelPlotRenderer
extends AbstractRenderer {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";

    @Override
    public String getName() {
        return "Plot View";
    }

    @Override
    public Reportable createReportable(Object renderable, IOContainer ioContainer, int width, int height) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        String attributeName = null;
        try {
            attributeName = this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME);
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        DistributionPlotter plotter = new DistributionPlotter(distributionModel);
        String[] attributeNames = distributionModel.getAttributeNames();
        int i = 0;
        while (i < attributeNames.length) {
            if (attributeNames[i].equals(attributeName)) {
                plotter.setPlotColumn(i, true);
                break;
            }
            ++i;
        }
        plotter.getPlotter().setSize(width, height);
        return plotter;
    }

    @Override
    public Component getVisualizationComponent(Object renderable, IOContainer ioContainer) {
        DistributionModel distributionModel = (DistributionModel)renderable;
        JPanel graphPanel = new JPanel(new BorderLayout());
        final DistributionPlotter plotter = new DistributionPlotter(distributionModel);
        graphPanel.add((Component)plotter.getPlotter(), "Center");
        final JComboBox<String> combo = new JComboBox<String>(distributionModel.getAttributeNames());
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = 0;
        JPanel boxPanel = new JPanel(layout);
        JLabel label = new JLabel("Attribute:");
        layout.setConstraints(label, c);
        boxPanel.add(label);
        layout.setConstraints(combo, c);
        boxPanel.add(combo);
        c.weighty = 1.0;
        JPanel fillPanel = new JPanel();
        layout.setConstraints(fillPanel, c);
        boxPanel.add(fillPanel);
        graphPanel.add((Component)boxPanel, "West");
        combo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                plotter.setPlotColumn(combo.getSelectedIndex(), true);
            }
        });
        combo.setSelectedIndex(0);
        return graphPanel;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Indicates for which attribute the distribution should be plotted.", false));
        return types;
    }
}

