/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.JDBCConnectionPoolDataSource;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAConnectionWrapper;
import org.hsqldb.jdbc.pool.JDBCXAResource;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

public class JDBCXADataSource
extends JDBCConnectionPoolDataSource
implements XADataSource {
    private HashMap resources = new HashMap();

    public void addResource(Xid xid, JDBCXAResource jDBCXAResource) {
        this.resources.put(xid, jDBCXAResource);
    }

    public JDBCXAResource removeResource(Xid xid) {
        return (JDBCXAResource)this.resources.remove(xid);
    }

    Xid[] getPreparedXids() {
        Iterator iterator = this.resources.keySet().iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            Xid xid = (Xid)iterator.next();
            if (((JDBCXAResource)this.resources.get((Object)xid)).state != JDBCXAResource.XA_STATE_PREPARED) continue;
            hashSet.add(xid);
        }
        return (Xid[])hashSet.toArray(new Xid[0]);
    }

    JDBCXAResource getResource(Xid xid) {
        return (JDBCXAResource)this.resources.get(xid);
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        try {
            Class.forName("org.hsqldb.jdbc.JDBCDriver").newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Error opening connection: " + classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("Error opening connection: " + illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("Error opening connection: " + instantiationException.getMessage());
        }
        JDBCConnection jDBCConnection = (JDBCConnection)DriverManager.getConnection(this.url, this.connProperties);
        JDBCXAResource jDBCXAResource = new JDBCXAResource(jDBCConnection, this);
        JDBCXAConnectionWrapper jDBCXAConnectionWrapper = new JDBCXAConnectionWrapper(jDBCConnection, jDBCXAResource, this.connectionDefaults);
        JDBCXAConnection jDBCXAConnection = new JDBCXAConnection(jDBCXAConnectionWrapper, jDBCXAResource);
        jDBCXAConnectionWrapper.setPooledConnection(jDBCXAConnection);
        return jDBCXAConnection;
    }

    @Override
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        this.validateSpecifiedUserAndPassword(string, string2);
        return this.getXAConnection();
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        throw new SQLException("Use the getXAConnections to get XA Connections.\nUse the class JDBCConnectionPoolDataSource for non-XA data sources.");
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        throw new SQLException("Use the getXAConnections to get XA Connections.\nUse the class JDBCConnectionPoolDataSource for non-XA data sources.");
    }
}

