/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationSequencesReader {
    public static <O extends Observation> List<List<O>> readSequences(ObservationReader<O> or, Reader reader) throws IOException, FileFormatException {
        ArrayList<List<O>> sequences = new ArrayList<List<O>>();
        StreamTokenizer st = new StreamTokenizer(reader);
        ObservationSequencesReader.initSyntaxTable(st);
        st.nextToken();
        while (st.ttype != -1) {
            st.pushBack();
            ArrayList sequence = new ArrayList(ObservationSequencesReader.readSequence(or, st));
            if (sequence == null) break;
            sequences.add(sequence);
            st.nextToken();
        }
        return sequences;
    }

    static void initSyntaxTable(StreamTokenizer st) {
        st.resetSyntax();
        st.parseNumbers();
        st.whitespaceChars(0, 32);
        st.eolIsSignificant(true);
        st.commentChar(35);
    }

    public static <O extends Observation> List<O> readSequence(ObservationReader<O> oir, Reader reader) throws IOException, FileFormatException {
        StreamTokenizer st = new StreamTokenizer(reader);
        ObservationSequencesReader.initSyntaxTable(st);
        return ObservationSequencesReader.readSequence(oir, st);
    }

    static <O extends Observation> List<O> readSequence(ObservationReader<O> oir, StreamTokenizer st) throws IOException, FileFormatException {
        st.nextToken();
        while (st.ttype == 10) {
            st.nextToken();
        }
        if (st.ttype == -1) {
            return null;
        }
        ArrayList<O> sequence = new ArrayList<O>();
        do {
            st.pushBack();
            sequence.add(oir.read(st));
            if (st.nextToken() != 92) continue;
            if (st.nextToken() != 10) {
                throw new FileFormatException("'' token is not followed by a new line");
            }
            st.nextToken();
        } while (st.ttype != 10 && st.ttype != -1);
        if (st.ttype == -1) {
            throw new FileFormatException("Unexpected token: EOF");
        }
        return sequence;
    }
}

