/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import com.rapidminer.tools.math.similarity.DistanceMeasures;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBScan
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final String PARAMETER_EPSILON = "epsilon";
    private static final String PARAMETER_MIN_POINTS = "min_points";

    public DBScan(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        DistanceMeasure measure = DistanceMeasures.createMeasure(this, exampleSet, this.getInput());
        measure.init(exampleSet);
        double epsilon = this.getParameterAsDouble(PARAMETER_EPSILON);
        int minPoints = this.getParameterAsInt(PARAMETER_MIN_POINTS);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "DBScan");
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        boolean[] visited = new boolean[exampleSet.size()];
        boolean[] noised = new boolean[exampleSet.size()];
        int[] clusterAssignments = new int[exampleSet.size()];
        int i = 0;
        int clusterIndex = 1;
        for (Example example : exampleSet) {
            this.checkForStop();
            if (!visited[i]) {
                LinkedList<Integer> centerNeighbourhood = this.getNeighbourhood(example, exampleSet, measure, epsilon);
                if (centerNeighbourhood.size() < minPoints) {
                    noised[i] = true;
                } else {
                    clusterAssignments[i] = clusterIndex;
                    while (centerNeighbourhood.size() > 0) {
                        int currentIndex = (Integer)centerNeighbourhood.poll();
                        Example currentExample = exampleSet.getExample(currentIndex);
                        clusterAssignments[currentIndex] = clusterIndex;
                        visited[currentIndex] = true;
                        LinkedList<Integer> neighbourhood = this.getNeighbourhood(currentExample, exampleSet, measure, epsilon);
                        if (neighbourhood.size() <= minPoints) continue;
                        while (neighbourhood.size() > 0) {
                            int neighbourIndex = (Integer)neighbourhood.poll();
                            if (visited[neighbourIndex]) continue;
                            if (!noised[neighbourIndex]) {
                                centerNeighbourhood.add(neighbourIndex);
                            }
                            clusterAssignments[neighbourIndex] = clusterIndex;
                            visited[neighbourIndex] = true;
                        }
                    }
                    ++clusterIndex;
                }
            }
            ++i;
        }
        ClusterModel model = new ClusterModel(Math.max(clusterIndex, 1));
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean("keep_example_set")) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            i = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + clusterAssignments[i]);
                ++i;
            }
        }
        return model;
    }

    private LinkedList<Integer> getNeighbourhood(Example centerExample, ExampleSet exampleSet, DistanceMeasure measure, double epsilon) {
        LinkedList<Integer> neighbourhood = new LinkedList<Integer>();
        int i = 0;
        for (Example example : exampleSet) {
            double distance = measure.calculateDistance(centerExample, example);
            if (distance < epsilon && example != centerExample) {
                neighbourhood.add(i);
            }
            ++i;
        }
        return neighbourhood;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "Specifies the size of neighbourhood.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeInt(PARAMETER_MIN_POINTS, "The minimal number of points forming a cluster.", 2, Integer.MAX_VALUE, 5));
        types.addAll(DistanceMeasures.getParameterTypes(this));
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

