/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.clusterer.AbstractClusterer;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelKMeans
extends AbstractClusterer {
    public static final String PARAMETER_ADD_CLUSTER_ATTRIBUTE = "add_cluster_attribute";
    public static final String PARAMETER_K = "k";
    public static final String PARAMETER_USE_WEIGHTS = "use_weights";
    public static final String PARAMETER_MAX_OPTIMIZATION_STEPS = "max_optimization_steps";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public KernelKMeans(OperatorDescription description) {
        super(description);
    }

    @Override
    public ClusterModel generateClusterModel(ExampleSet exampleSet) throws OperatorException {
        int k = this.getParameterAsInt(PARAMETER_K);
        int maxOptimizationSteps = this.getParameterAsInt(PARAMETER_MAX_OPTIMIZATION_STEPS);
        boolean useExampleWeights = this.getParameterAsBoolean(PARAMETER_USE_WEIGHTS);
        Kernel kernel = Kernel.createKernel(this);
        Tools.checkAndCreateIds(exampleSet);
        Tools.onlyNonMissingValues(exampleSet, "KernelKMeans");
        if (exampleSet.size() < k) {
            throw new UserError((Operator)this, 142, k);
        }
        Attributes attributes = exampleSet.getAttributes();
        ArrayList<String> attributeNames = new ArrayList<String>(attributes.size());
        for (Attribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        Attribute weightAttribute = attributes.getWeight();
        int localRandomSeed = this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED);
        RandomGenerator generator = localRandomSeed == -1 ? RandomGenerator.getGlobalRandomGenerator() : RandomGenerator.getRandomGenerator(localRandomSeed);
        ClusterModel model = new ClusterModel(k);
        int[] clusterAssignments = new int[exampleSet.size()];
        int i = 0;
        while (i < exampleSet.size()) {
            clusterAssignments[i] = generator.nextIntInRange(0, k);
            ++i;
        }
        boolean stable = false;
        int step2 = 0;
        while (step2 < maxOptimizationSteps && !stable) {
            this.checkForStop();
            double[] clusterWeights = new double[k];
            double[] clusterKernelCorrection = new double[k];
            int i2 = 0;
            for (Example firstExample : exampleSet) {
                double firstExampleWeight = useExampleWeights ? firstExample.getValue(weightAttribute) : 1.0;
                double[] firstExampleValues = this.getAsDoubleArray(firstExample, attributes);
                int n = clusterAssignments[i2];
                clusterWeights[n] = clusterWeights[n] + firstExampleWeight;
                int j = 0;
                for (Example secondExample : exampleSet) {
                    if (clusterAssignments[i2] == clusterAssignments[j]) {
                        double secondExampleWeight = useExampleWeights ? secondExample.getValue(weightAttribute) : 1.0;
                        int n2 = clusterAssignments[i2];
                        clusterKernelCorrection[n2] = clusterKernelCorrection[n2] + firstExampleWeight * secondExampleWeight * kernel.calculateDistance(firstExampleValues, this.getAsDoubleArray(secondExample, attributes));
                    }
                    ++j;
                }
                ++i2;
            }
            int z = 0;
            while (z < k) {
                int n = z;
                clusterKernelCorrection[n] = clusterKernelCorrection[n] / (clusterWeights[z] * clusterWeights[z]);
                ++z;
            }
            int[] newClusterAssignments = new int[exampleSet.size()];
            i2 = 0;
            for (Example example : exampleSet) {
                double[] exampleValues = this.getAsDoubleArray(example, attributes);
                double exampleKernelValue = kernel.calculateDistance(exampleValues, exampleValues);
                double nearestDistance = Double.POSITIVE_INFINITY;
                int nearestIndex = 0;
                int clusterIndex = 0;
                while (clusterIndex < k) {
                    double distance = 0.0;
                    int j = 0;
                    for (Example clusterExample : exampleSet) {
                        if (clusterAssignments[j] == clusterIndex) {
                            distance += (useExampleWeights ? clusterExample.getValue(weightAttribute) : 1.0) * kernel.calculateDistance(this.getAsDoubleArray(clusterExample, attributes), exampleValues);
                        }
                        ++j;
                    }
                    distance *= -2.0 / clusterWeights[clusterIndex];
                    distance += exampleKernelValue;
                    if ((distance += clusterKernelCorrection[clusterIndex]) < nearestDistance) {
                        nearestDistance = distance;
                        nearestIndex = clusterIndex;
                    }
                    ++clusterIndex;
                }
                newClusterAssignments[i2] = nearestIndex;
                ++i2;
            }
            stable = true;
            int j = 0;
            while (j < exampleSet.size() && stable) {
                stable &= newClusterAssignments[j] == clusterAssignments[j];
                ++j;
            }
            clusterAssignments = newClusterAssignments;
            ++step2;
        }
        model.setClusterAssignments(clusterAssignments, exampleSet);
        if (this.getParameterAsBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE) && this.getParameterAsBoolean("keep_example_set")) {
            Attribute cluster = AttributeFactory.createAttribute("cluster", 1);
            exampleSet.getExampleTable().addAttribute(cluster);
            exampleSet.getAttributes().setCluster(cluster);
            int i3 = 0;
            for (Example example : exampleSet) {
                example.setValue(cluster, "cluster_" + clusterAssignments[i3]);
                ++i3;
            }
        }
        return model;
    }

    private double[] getAsDoubleArray(Example example, Attributes attributes) {
        double[] values = new double[attributes.size()];
        int i = 0;
        for (Attribute attribute : attributes) {
            values[i] = example.getValue(attribute);
            ++i;
        }
        return values;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_ADD_CLUSTER_ATTRIBUTE, "Indicates if a cluster id is generated as new special attribute.", true);
        type.registerDependencyCondition(new BooleanParameterCondition(this, "keep_example_set", false, true));
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_USE_WEIGHTS, "Indicates if the weight attribute should be used.", false));
        types.add(new ParameterTypeInt(PARAMETER_K, "The number of clusters which should be detected.", 2, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt(PARAMETER_MAX_OPTIMIZATION_STEPS, "The maximal number of iterations performed for one run of k-Means.", 1, Integer.MAX_VALUE, 100));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        types.addAll(Kernel.getParameters(this));
        return types;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }
}

