/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.example.table.SparseFormatDataRowReader;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseFormatExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_FORMAT = "format";
    public static final String PARAMETER_ATTRIBUTE_DESCRIPTION_FILE = "attribute_description_file";
    public static final String PARAMETER_DATA_FILE = "data_file";
    public static final String PARAMETER_LABEL_FILE = "label_file";
    public static final String PARAMETER_DIMENSION = "dimension";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";
    public static final String PARAMETER_DECIMAL_POINT_CHARACTER = "decimal_point_character";
    public static final String PARAMETER_PREFIX_MAP = "prefix_map";

    public SparseFormatExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        int format = this.getParameterAsInt(PARAMETER_FORMAT);
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        for (String[] prefixMapping : this.getParameterList(PARAMETER_PREFIX_MAP)) {
            prefixMap.put(prefixMapping[0], prefixMapping[1]);
        }
        File dataFile = this.getParameterAsFile(PARAMETER_DATA_FILE);
        File attributeDescriptionFile = this.getParameterAsFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE);
        AttributeSet attributeSet = null;
        if (attributeDescriptionFile != null) {
            try {
                attributeSet = new AttributeSet(attributeDescriptionFile, false, this);
            }
            catch (Throwable e) {
                throw new UserError((Operator)this, e, 302, attributeDescriptionFile, e.getMessage());
            }
            if (dataFile != null && attributeSet.getDefaultSource() != null && !dataFile.equals(attributeSet.getDefaultSource())) {
                this.logWarning("Attribute file names specified by parameter 'data_file' and default_source specified in '" + attributeDescriptionFile + "' do not match! Assuming the latter to be correct.");
            }
            if (format != 4 && attributeSet.getSpecialAttribute("label") == null) {
                throw new UserError((Operator)this, 917, new Object[0]);
            }
            this.log("Found " + attributeSet.getNumberOfRegularAttributes() + " regular attributes.");
            dataFile = attributeSet.getDefaultSource();
        } else {
            int dimension = this.getParameterAsInt(PARAMETER_DIMENSION);
            if (dimension < 0) {
                throw new UserError(this, 921);
            }
            attributeSet = new AttributeSet(dimension);
            int i = 0;
            while (i < dimension) {
                Attribute attribute = AttributeFactory.createAttribute(4);
                attributeSet.addAttribute(attribute);
                ++i;
            }
            for (String specialName : prefixMap.values()) {
                attributeSet.setSpecialAttribute(specialName, AttributeFactory.createAttribute(4));
            }
            if (format != 4) {
                attributeSet.setSpecialAttribute("label", AttributeFactory.createAttribute(1));
            }
        }
        if (dataFile == null) {
            throw new UserError((Operator)this, 902, new Object[0]);
        }
        BufferedReader inData = null;
        BufferedReader inLabels = null;
        try {
            inData = Tools.getReader(dataFile, this.getEncoding());
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, dataFile, e.getMessage());
        }
        File labelFile = null;
        if (format == 3) {
            labelFile = this.getParameterAsFile(PARAMETER_LABEL_FILE);
            if (labelFile == null) {
                throw new UserError((Operator)this, 201, PARAMETER_FORMAT, SparseFormatDataRowReader.FORMAT_NAMES[3], PARAMETER_LABEL_FILE);
            }
            try {
                inLabels = Tools.getReader(labelFile, this.getEncoding());
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, labelFile, e.getMessage());
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        SparseFormatDataRowReader reader = new SparseFormatDataRowReader(new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), this.getParameterAsString(PARAMETER_DECIMAL_POINT_CHARACTER).charAt(0)), format, prefixMap, attributeSet, inData, inLabels, this.getParameterAsInt(PARAMETER_SAMPLE_SIZE));
        table.readExamples(reader);
        ExampleSet exampleSet = table.createExampleSet(attributeSet);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_FORMAT, "Format of the sparse data file.", SparseFormatDataRowReader.FORMAT_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile(PARAMETER_ATTRIBUTE_DESCRIPTION_FILE, "Name of the attribute description file.", "aml", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile(PARAMETER_DATA_FILE, "Name of the data file. Only necessary if not specified in the attribute description file.", null, true));
        types.add(new ParameterTypeFile(PARAMETER_LABEL_FILE, "Name of the data file containing the labels. Only necessary if format is 'format_separate_file'.", null, true));
        types.add(new ParameterTypeInt(PARAMETER_DIMENSION, "Dimension of the example space. Only necessary if parameter 'attribute_description_file' is not set.", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The maximum number of examples to read from the data files (-1 = all)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        types.add(new ParameterTypeString(PARAMETER_DECIMAL_POINT_CHARACTER, "Character that is used as decimal point.", "."));
        types.add(new ParameterTypeList(PARAMETER_PREFIX_MAP, "Maps prefixes to names of special attributes.", new ParameterTypeString("special_attribute", "Maps prefixes to names of special attributes.")));
        return types;
    }
}

