/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.IOException;
import java.util.Arrays;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.test.BaseTester;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SinusoidsTester
extends BaseTester {
    public static float DEFAULT_PHASE = 0.0f;
    public static int DEFAULT_FRAME_INDEX = 0;

    public SinusoidsTester() {
    }

    public SinusoidsTester(float freqInHz) {
        this(freqInHz, DEFAULT_AMP);
    }

    public SinusoidsTester(float freqInHz, float amp) {
        this(freqInHz, amp, DEFAULT_PHASE);
    }

    public SinusoidsTester(float freqInHz, float amp, float phaseInDegrees) {
        this(freqInHz, amp, phaseInDegrees, DEFAULT_FRAME_INDEX);
    }

    public SinusoidsTester(float freqInHz, float amp, float phaseInDegrees, int frameIndex) {
        this(freqInHz, amp, phaseInDegrees, frameIndex, DEFAULT_DUR);
    }

    public SinusoidsTester(float freqInHz, float amp, float phaseInDegrees, int frameIndex, float durationInSeconds) {
        this(freqInHz, amp, phaseInDegrees, frameIndex, durationInSeconds, DEFAULT_FS);
    }

    public SinusoidsTester(Sinusoid sin) {
        this(sin, DEFAULT_DUR);
    }

    public SinusoidsTester(Sinusoid sin, float durationInSeconds) {
        this(sin, durationInSeconds, DEFAULT_FS);
    }

    public SinusoidsTester(float freqInHz, float amp, float phaseInDegrees, int frameIndex, float durationInSeconds, int samplingRateInHz) {
        Sinusoid[] tmpSins = new Sinusoid[]{new Sinusoid(amp, freqInHz, phaseInDegrees, frameIndex)};
        this.init(tmpSins, durationInSeconds, samplingRateInHz);
    }

    public SinusoidsTester(Sinusoid sin, float durationInSeconds, int samplingRateInHz) {
        Sinusoid[] tmpSins = new Sinusoid[]{new Sinusoid(sin)};
        this.init(tmpSins, durationInSeconds, samplingRateInHz);
    }

    public SinusoidsTester(Sinusoid[] sinsIn) {
        this(sinsIn, DEFAULT_DUR);
    }

    public SinusoidsTester(Sinusoid[] sinsIn, float durationInSeconds) {
        this(sinsIn, durationInSeconds, DEFAULT_FS);
    }

    public SinusoidsTester(Sinusoid[] sinsIn, float durationInSeconds, int samplingRateInHz) {
        this.init(sinsIn, durationInSeconds, samplingRateInHz);
    }

    public SinusoidsTester(Sinusoid[] sinsIn, float[] startTimesInSeconds, float[] endTimesInSeconds) {
        this(sinsIn, startTimesInSeconds, endTimesInSeconds, DEFAULT_FS);
    }

    public SinusoidsTester(Sinusoid[] sinsIn, float[] startTimesInSeconds, float[] endTimesInSeconds, int samplingRateInHz) {
        this.init(sinsIn, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
    }

    public void init(Sinusoid[] sinsIn, float durationInSeconds, int samplingRateInHz) {
        if (sinsIn.length > 0) {
            float[] startTimesInSeconds = new float[sinsIn.length];
            float[] endTimesInSeconds = new float[sinsIn.length];
            for (int i = 0; i < sinsIn.length; ++i) {
                startTimesInSeconds[i] = 0.0f;
                endTimesInSeconds[i] = durationInSeconds;
            }
            this.init(sinsIn, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
        }
    }

    public void init(Sinusoid[] sinsIn, float startTimeInSeconds, float endTimeInSeconds, int samplingRateInHz) {
        float[] startTimesInSeconds = new float[sinsIn.length];
        float[] endTimesInSeconds = new float[sinsIn.length];
        Arrays.fill(startTimesInSeconds, startTimeInSeconds);
        Arrays.fill(endTimesInSeconds, endTimeInSeconds);
        this.init(sinsIn, startTimesInSeconds, endTimesInSeconds, samplingRateInHz);
    }

    public void init(Sinusoid[] sinsIn, float[] startTimesInSeconds, float[] endTimesInSeconds, int samplingRateInHz) {
        this.fs = samplingRateInHz;
        this.signal = null;
        this.pitchMarks = null;
        if (sinsIn != null) {
            int i;
            assert (startTimesInSeconds.length == endTimesInSeconds.length);
            assert (sinsIn.length == endTimesInSeconds.length);
            float minFreq = 2 * this.fs;
            int minFreqInd = -1;
            for (i = 0; i < sinsIn.length; ++i) {
                if (!(sinsIn[i].freq > 0.0f) || !(sinsIn[i].freq < minFreq)) continue;
                minFreq = sinsIn[i].freq;
                minFreqInd = i;
            }
            int[] startSampleIndices = new int[sinsIn.length];
            int[] endSampleIndices = new int[sinsIn.length];
            for (i = 0; i < startTimesInSeconds.length; ++i) {
                if (startTimesInSeconds[i] < 0.0f) {
                    startTimesInSeconds[i] = 0.0f;
                }
                if (endTimesInSeconds[i] < 0.0f) {
                    endTimesInSeconds[i] = 0.0f;
                }
                if (startTimesInSeconds[i] > endTimesInSeconds[i]) {
                    startTimesInSeconds[i] = endTimesInSeconds[i];
                }
                startSampleIndices[i] = (int)Math.floor((double)(startTimesInSeconds[i] * (float)this.fs) + 0.5);
                endSampleIndices[i] = (int)Math.floor((double)(endTimesInSeconds[i] * (float)this.fs) + 0.5) - 1;
            }
            int minStartSampleIndex = 0;
            int maxEndSampleIndex = MathUtils.getMax(endSampleIndices);
            int maxT0 = minFreqInd >= 0 ? (int)Math.floor((double)((float)this.fs / minFreq) + 0.5) : (int)Math.floor((double)(0.01f * (float)this.fs) + 0.5);
            int numPitchMarks = (int)Math.floor((double)(maxEndSampleIndex - minStartSampleIndex + 1) / (double)maxT0 + 0.5) + 1;
            this.pitchMarks = new int[numPitchMarks];
            for (i = 0; i < numPitchMarks; ++i) {
                this.pitchMarks[i] = Math.min(i * maxT0 + minStartSampleIndex, maxEndSampleIndex);
            }
            float lastTime = SignalProcUtils.sample2time(this.pitchMarks[this.pitchMarks.length - 1], this.fs);
            int numfrm = (int)Math.floor(((double)lastTime - 0.5 * (double)this.ws) / (double)this.ss + 0.5);
            this.f0s = new double[numfrm];
            Arrays.fill(this.f0s, (double)minFreq);
            if (maxEndSampleIndex > 0) {
                this.signal = new double[maxEndSampleIndex + 1];
                Arrays.fill(this.signal, 0.0);
                for (i = 0; i < sinsIn.length; ++i) {
                    for (int j = startSampleIndices[i]; j < endSampleIndices[i]; ++j) {
                        int n = j;
                        this.signal[n] = this.signal[n] + (double)sinsIn[i].amp * Math.sin(Math.PI * 2 * ((double)((float)(j - startSampleIndices[i]) * (sinsIn[i].freq / (float)this.fs)) + (double)sinsIn[i].phase / 360.0));
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        SinusoidsTester s = null;
        s = new SinusoidsTester(200.0f);
        int numSins = 1;
        Sinusoid[] sins = new Sinusoid[numSins];
        float[] tStarts = new float[numSins];
        float[] tEnds = new float[numSins];
        sins[0] = new Sinusoid(100.0f, 400.0f, 0.0f);
        tStarts[0] = 0.0f;
        tEnds[0] = 1.5f;
        s = new SinusoidsTester(sins, tStarts, tEnds);
        if (args.length > 1) {
            s.write(args[0], args[1]);
        } else {
            s.write(args[0]);
        }
    }
}

