/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.commons.helpers;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gcube.rest.commons.helpers.XMLConverter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathEvaluator {
    private Node node;
    private XPath xpath;

    public XPathEvaluator(Node node) {
        this.node = node;
        XPathFactory factory = XPathFactory.newInstance();
        this.xpath = factory.newXPath();
    }

    public List<String> evaluate(String expression) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            NodeList nodeList = (NodeList)this.xpath.evaluate(expression, this.node, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() == 2 || nodeList.item(i).getNodeType() == 3) {
                    list.add(nodeList.item(i).getTextContent());
                    continue;
                }
                list.add(XMLConverter.nodeToString(nodeList.item(i)));
            }
        }
        catch (XPathExpressionException e) {
            try {
                Double number = (Double)this.xpath.evaluate(expression, this.node, XPathConstants.NUMBER);
                list.add(String.valueOf(number.intValue()));
            }
            catch (XPathExpressionException e1) {
                return null;
            }
        }
        return list;
    }

    public Node getNode() {
        return this.node;
    }

    public XPath getXpath() {
        return this.xpath;
    }
}

