/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.gcubemodellibrary.elements;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;

public class InnerElements<T extends BaseInnerElement>
implements Iterable<T> {
    GCubeDocument inner;
    List<T> elements;

    InnerElements(GCubeDocument doc, List<T> es) {
        this.inner = doc;
        this.elements = es;
    }

    public T add(T e) throws IllegalArgumentException, IllegalStateException {
        BaseInnerElement replaced = null;
        if (((BaseElement)e).isNew()) {
            if (!this.inner.isNew() && !this.inner.isTracked()) {
                throw new IllegalArgumentException("cannot add new elements to a document which is not tracked for changes");
            }
        } else {
            if (this.inner.isNew()) {
                throw new IllegalArgumentException("cannot add element proxies to new document");
            }
            if (this.inner.isTracked()) {
                throw new IllegalArgumentException("cannot add elements proxy to a document which is tracked for changes");
            }
            for (BaseInnerElement t : this.elements) {
                if (!t.id().equals(((BaseElement)e).id())) continue;
                replaced = t;
                break;
            }
        }
        if (replaced != null) {
            this.elements.remove(replaced);
        }
        this.elements.add(e);
        ((BaseInnerElement)e).setDocument(this.inner);
        return (T)replaced;
    }

    public T get(String id) throws IllegalStateException {
        for (BaseInnerElement e : this.elements) {
            if (!e.id().equals(id)) continue;
            return (T)e;
        }
        throw new IllegalStateException("unknown element with identifier " + id);
    }

    public boolean contains(String id) {
        try {
            this.get(id);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public T remove(String id) throws IllegalStateException {
        T removed = this.get(id);
        this.remove(removed);
        return removed;
    }

    public void remove(T e) throws IllegalStateException {
        if (!this.elements.remove(e)) {
            throw new IllegalStateException("unknown element " + e);
        }
    }

    public List<T> toList() {
        return new LinkedList<T>(this.elements);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }
}

