/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.functions.Func1;
import rx.internal.producers.ProducerArbiter;
import rx.plugins.RxJavaPlugins;
import rx.subscriptions.SerialSubscription;

public final class OperatorOnErrorResumeNextViaFunction<T>
implements Observable.Operator<T, T> {
    private final Func1<Throwable, ? extends Observable<? extends T>> resumeFunction;

    public OperatorOnErrorResumeNextViaFunction(Func1<Throwable, ? extends Observable<? extends T>> f) {
        this.resumeFunction = f;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final ProducerArbiter pa = new ProducerArbiter();
        final SerialSubscription ssub = new SerialSubscription();
        Subscriber parent = new Subscriber<T>(){
            private boolean done = false;

            @Override
            public void onCompleted() {
                if (this.done) {
                    return;
                }
                this.done = true;
                child.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    Exceptions.throwIfFatal(e);
                    return;
                }
                this.done = true;
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
                    this.unsubscribe();
                    Subscriber next = new Subscriber<T>(){

                        @Override
                        public void onNext(T t) {
                            child.onNext(t);
                        }

                        @Override
                        public void onError(Throwable e) {
                            child.onError(e);
                        }

                        @Override
                        public void onCompleted() {
                            child.onCompleted();
                        }

                        @Override
                        public void setProducer(Producer producer) {
                            pa.setProducer(producer);
                        }
                    };
                    ssub.set(next);
                    Observable resume = (Observable)OperatorOnErrorResumeNextViaFunction.this.resumeFunction.call(e);
                    resume.unsafeSubscribe(next);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, child);
                }
            }

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                child.onNext(t);
            }

            @Override
            public void setProducer(Producer producer) {
                pa.setProducer(producer);
            }
        };
        child.add(ssub);
        ssub.set(parent);
        child.setProducer(pa);
        return parent;
    }
}

