/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.vti.connectors;

import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;

public class VTIClassificator {
    private static int bathymetryThr = -500;

    public static Tuple<Integer>[] classify(Tuple<String>[] couples) {
        Tuple[] outClasses = new Tuple[couples.length];
        int i = 0;
        for (Tuple<String> couple : couples) {
            Tuple<Integer> outTuple;
            Double speed = Double.parseDouble(couple.getElements().get(0));
            Double bathymetry = Double.parseDouble(couple.getElements().get(1));
            Integer c1 = 1;
            Integer c2 = 1;
            if (speed > 2.0 && speed <= 5.0) {
                c1 = 2;
            } else if (speed > 5.0) {
                c1 = 3;
            }
            if (speed > 2.0 && speed <= 4.0 && bathymetry < (double)bathymetryThr) {
                c2 = 3;
            } else if (speed > 4.0 && speed <= 6.0) {
                c2 = 3;
            } else if (speed > 2.0 && speed <= 4.0 && bathymetry >= (double)bathymetryThr) {
                c2 = 2;
            } else if (speed > 6.0) {
                c2 = 4;
            }
            outClasses[i] = outTuple = new Tuple<Integer>(c1, c2);
            ++i;
        }
        return outClasses;
    }
}

