/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatchingEngineProcessStatus", propOrder={"_processId", "_processStartTimestamp", "_processEndTimestamp", "elapsed", "_numberOfComparisonRounds", "_totalNumberOfAtomicComparisonsPerformed", "atomicThroughput", "meanInputProcessAtomicThroughput", "meanInputProcessThroughput", "_maximumNumberOfMatchletsApplied", "_numberOfMatches", "_numberOfAuthoritativeFullMatches", "_numberOfAuthoritativeNoMatches", "_numberOfComparisonErrors", "_numberOfSkippedAtomicComparisons"})
public class MatchingEngineProcessStatus
implements Serializable {
    private static final long serialVersionUID = -4364229302255667713L;
    private static final Integer UNKNOWN_NUMBER_OF_COMPARISON_ROUNDS = -1;
    private static final Integer UNKNOWN_NUMBER_OF_ATOMIC_COMPARISONS_PER_ROUND = -1;
    @XmlAttribute(name="processId")
    private String _processId;
    @XmlTransient
    private int _currentNumberOfAtomicComparisonsPerformedInRound;
    @XmlTransient
    private int _currentNumberOfComparisonRoundsPerformed;
    @XmlTransient
    private int _currentNumberOfMatchletsApplied;
    @XmlTransient
    private int _maximumNumberOfAtomicComparisonsPerformedInRound;
    @XmlElement(name="MaximumNumberOfMatchletsApplied")
    private int _maximumNumberOfMatchletsApplied;
    @XmlElement(name="NumberOfAuthoritativeFullMatches")
    private int _numberOfAuthoritativeFullMatches;
    @XmlElement(name="NumberOfAuthoritativeNoMatches")
    private int _numberOfAuthoritativeNoMatches;
    @XmlElement(name="NumberOfComparisonRounds")
    private int _numberOfComparisonRounds = UNKNOWN_NUMBER_OF_COMPARISON_ROUNDS;
    @XmlElement(name="NumberOfMatches")
    private int _numberOfMatches;
    @XmlElement(name="ProcessEndTimestamp")
    private long _processEndTimestamp = -1L;
    @XmlElement(name="ProcessStartTimestamp")
    private long _processStartTimestamp = -1L;
    @XmlElement(name="TotalNumberOfAtomicComparisonsPerformed")
    private int _totalNumberOfAtomicComparisonsPerformed;
    @XmlElement(name="NumberOfComparisonErrors")
    private int _numberOfComparisonErrors;
    @XmlElement(name="NumberOfSkippedAtomicComparisons")
    private int _numberOfSkippedAtomicComparisons;

    public MatchingEngineProcessStatus() {
        this._maximumNumberOfAtomicComparisonsPerformedInRound = UNKNOWN_NUMBER_OF_ATOMIC_COMPARISONS_PER_ROUND;
    }

    public int getCurrentNumberOfAtomicComparisonsPerformedInRound() {
        return this._currentNumberOfAtomicComparisonsPerformedInRound;
    }

    public synchronized void setCurrentNumberOfAtomicComparisonsPerformedInRound(int currentNumberOfAtomicComparisonsPerformedInRound) {
        this._currentNumberOfAtomicComparisonsPerformedInRound = currentNumberOfAtomicComparisonsPerformedInRound;
    }

    public synchronized int increaseCurrentNumberOfAtomicComparisonsPerformedInRound() {
        return ++this._currentNumberOfAtomicComparisonsPerformedInRound;
    }

    public int getCurrentNumberOfComparisonRoundsPerformed() {
        return this._currentNumberOfComparisonRoundsPerformed;
    }

    public synchronized void setCurrentNumberOfComparisonRoundsPerformed(int currentNumberOfComparisonRoundsPerformed) {
        this._currentNumberOfComparisonRoundsPerformed = currentNumberOfComparisonRoundsPerformed;
    }

    public synchronized int increaseCurrentNumberOfComparisonRoundsPerformed() {
        return ++this._currentNumberOfComparisonRoundsPerformed;
    }

    public int getMaximumNumberOfAtomicComparisonsPerformedInRound() {
        return this._maximumNumberOfAtomicComparisonsPerformedInRound;
    }

    public synchronized void setMaximumNumberOfAtomicComparisonsPerformedInRound(int maximumNumberOfAtomicComparisonsPerformedInRound) {
        this._maximumNumberOfAtomicComparisonsPerformedInRound = maximumNumberOfAtomicComparisonsPerformedInRound;
    }

    public synchronized int increaseMaximumNumberOfAtomicComparisonsPerformedInRound() {
        return ++this._maximumNumberOfAtomicComparisonsPerformedInRound;
    }

    public int getMaximumNumberOfMatchletsApplied() {
        return this._maximumNumberOfMatchletsApplied;
    }

    public synchronized void setMaximumNumberOfMatchletsApplied(int maximumNumberOfMatchletsApplied) {
        this._maximumNumberOfMatchletsApplied = maximumNumberOfMatchletsApplied;
    }

    public int getNumberOfAuthoritativeFullMatches() {
        return this._numberOfAuthoritativeFullMatches;
    }

    public synchronized void setNumberOfAuthoritativeFullMatches(int numberOfAuthoritativeFullMatches) {
        this._numberOfAuthoritativeFullMatches = numberOfAuthoritativeFullMatches;
    }

    public synchronized int increaseNumberOfAuthoritativeFullMatches() {
        return ++this._numberOfAuthoritativeFullMatches;
    }

    public int getNumberOfAuthoritativeNoMatches() {
        return this._numberOfAuthoritativeNoMatches;
    }

    public synchronized void setNumberOfAuthoritativeNoMatches(int numberOfAuthoritativeNoMatches) {
        this._numberOfAuthoritativeNoMatches = numberOfAuthoritativeNoMatches;
    }

    public synchronized int increaseNumberOfAuthoritativeNoMatches() {
        return ++this._numberOfAuthoritativeNoMatches;
    }

    public int getNumberOfComparisonRounds() {
        return this._numberOfComparisonRounds;
    }

    public synchronized void setNumberOfComparisonRounds(int numberOfComparisonRounds) {
        this._numberOfComparisonRounds = numberOfComparisonRounds;
    }

    public synchronized int increaseNumberOfComparisonRounds() {
        return ++this._numberOfComparisonRounds;
    }

    public int getNumberOfMatches() {
        return this._numberOfMatches;
    }

    public synchronized void setNumberOfMatches(int numberOfMatches) {
        this._numberOfMatches = numberOfMatches;
    }

    public synchronized int increaseNumberOfMatches() {
        return ++this._numberOfMatches;
    }

    public long getProcessEndTimestamp() {
        return this._processEndTimestamp;
    }

    public void setProcessEndTimestamp(long processEndTimestamp) {
        this._processEndTimestamp = processEndTimestamp;
    }

    public String getProcessId() {
        return this._processId;
    }

    public void setProcessId(String processId) {
        this._processId = processId;
    }

    public long getProcessStartTimestamp() {
        return this._processStartTimestamp;
    }

    public void setProcessStartTimestamp(long processStartTimestamp) {
        this._processStartTimestamp = processStartTimestamp;
    }

    public int getTotalNumberOfAtomicComparisonsPerformed() {
        return this._totalNumberOfAtomicComparisonsPerformed;
    }

    public void setTotalNumberOfAtomicComparisonsPerformed(int totalNumberOfAtomicComparisonsPerformed) {
        this._totalNumberOfAtomicComparisonsPerformed = totalNumberOfAtomicComparisonsPerformed;
    }

    public synchronized int increaseTotalNumberOfAtomicComparisonsPerformed() {
        return ++this._totalNumberOfAtomicComparisonsPerformed;
    }

    public synchronized int increaseNumberOfAtomicComparisonsSkipped() {
        return ++this._numberOfSkippedAtomicComparisons;
    }

    public int getNumberOfAtomicComparisonsSkipped() {
        return this._numberOfSkippedAtomicComparisons;
    }

    public int getNumberOfComparisonErrors() {
        return this._numberOfComparisonErrors;
    }

    public synchronized int increaseNumberOfComparisonErrors() {
        return ++this._numberOfComparisonErrors;
    }

    public synchronized void setNumberOfComparisonErrors(int numberOfComparisonErrors) {
        this._numberOfComparisonErrors = numberOfComparisonErrors;
    }

    @XmlElement(name="Elapsed")
    public long getElapsed() {
        return this._processStartTimestamp == -1L ? 0L : (this._processEndTimestamp == -1L ? System.currentTimeMillis() - this._processStartTimestamp : this._processEndTimestamp - this._processStartTimestamp);
    }

    public void setElapsed(long elapsed) {
    }

    @XmlElement(name="AtomicThroughput")
    public double getAtomicThroughput() {
        long elapsed = this.getElapsed();
        if (elapsed == 0L) {
            return 0.0;
        }
        return (double)this._totalNumberOfAtomicComparisonsPerformed * 1000.0 / (double)elapsed;
    }

    public void setAtomicThroughput(double atomicThroughput) {
    }

    @XmlElement(name="MeanInputProcessAtomicThroughput")
    public double getMeanInputProcessAtomicThroughput() {
        long elapsed = this.getElapsed();
        if (elapsed == 0L || this._numberOfComparisonRounds == 0) {
            return 0.0;
        }
        return this._numberOfComparisonRounds < 0 ? Double.NaN : (double)this._totalNumberOfAtomicComparisonsPerformed * 1.0 / (double)this._numberOfComparisonRounds * 1000.0 / (double)elapsed;
    }

    public void setMeanInputProcessAtomicThroughput(double meanInputProcessAtomicThroughput) {
    }

    @XmlElement(name="MeanInputProcessThroughput")
    public double getMeanInputProcessThroughput() {
        long elapsed = this.getElapsed();
        if (elapsed == 0L) {
            return 0.0;
        }
        return this._numberOfComparisonRounds < 0 ? Double.NaN : (double)this._numberOfComparisonRounds * 1000.0 / (double)elapsed;
    }

    public void setMeanInputProcessThroughput(double meanInputProcessThroughput) {
    }
}

