/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.engine.MatchingResultData;
import org.fao.fi.comet.core.model.engine.adapters.MatchingResultAdapter;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.support.MatchingSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.support.MatchingScore;
import org.fao.fi.comet.core.model.support.MatchingType;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="MatchingResult")
@XmlJavaTypeAdapter(value=MatchingResultAdapter.class)
public final class MatchingResult<SOURCE_DATA, TARGET_DATA>
implements Serializable {
    private static final long serialVersionUID = -5086733156593502974L;
    @XmlAttribute(name="matchletId")
    private String _originatingMatchletId;
    @XmlAttribute(name="matchletName")
    private String _originatingMatchletName;
    @XmlAttribute(name="matchletWeight")
    private Double _originatingMatchletWeight;
    @XmlTransient
    private MatchingSerializationExclusionPolicy[] _originatingMatchletExclusionPolicies;
    @XmlTransient
    private MatchingScore _score = new MatchingScore();
    @XmlTransient
    private Collection<MatchingResultData<SOURCE_DATA, TARGET_DATA>> _matchingResultsData = new ArrayList<MatchingResultData<SOURCE_DATA, TARGET_DATA>>();

    public MatchingResult() {
    }

    public MatchingResult(Matchlet<?, SOURCE_DATA, ?, TARGET_DATA> originatingMatchlet) {
        this.configureMatchletMetadata(originatingMatchlet);
    }

    public MatchingResult(Matchlet<?, SOURCE_DATA, ?, TARGET_DATA> originatingMatchlet, MatchingScore score, Collection<MatchingResultData<SOURCE_DATA, TARGET_DATA>> matchingResults) {
        this.configureMatchletMetadata(originatingMatchlet);
        this.setScore(score);
        this.setMatchingsResultData(matchingResults);
    }

    @XmlTransient
    public MatchingScore getScore() {
        return this._score;
    }

    public void setScore(MatchingScore score) {
        AssertionUtils.$nNull(score, "The score cannot be null", new Object[0]);
        this._score = score;
    }

    public Double getOriginatingMatchletWeight() {
        return this._originatingMatchletWeight;
    }

    public void setOriginatingMatchletWeight(Double originatingMatchletWeight) {
        this._originatingMatchletWeight = originatingMatchletWeight;
    }

    public MatchingSerializationExclusionPolicy[] getOriginatingMatchletExclusionPolicies() {
        return this._originatingMatchletExclusionPolicies;
    }

    public void setOriginatingMatchletExclusionPolicies(MatchingSerializationExclusionPolicy[] originatingMatchletExclusionPolicies) {
        this._originatingMatchletExclusionPolicies = originatingMatchletExclusionPolicies;
    }

    @XmlAttribute(name="score")
    public double getMatchletScoreValue() {
        return this._score.getValue();
    }

    public void setMatchletScoreValue(double scoreValue) {
        if (this._score == null) {
            this._score = new MatchingScore();
        }
        this._score.setValue(scoreValue);
    }

    @XmlAttribute(name="type")
    public MatchingType getMatchletScoreType() {
        return this._score.getMatchingType();
    }

    public void setMatchletScoreType(MatchingType scoreType) {
        if (this._score == null) {
            this._score = new MatchingScore();
        }
        this._score.setMatchingType(scoreType);
    }

    private void configureMatchletMetadata(Matchlet<?, SOURCE_DATA, ?, TARGET_DATA> originatingMatchlet) {
        AssertionUtils.$nNull(originatingMatchlet, "The originating matchlet cannot be NULL", new Object[0]);
        this._originatingMatchletId = originatingMatchlet.getId();
        this._originatingMatchletName = originatingMatchlet.getType();
        this._originatingMatchletWeight = originatingMatchlet.getWeight();
        MatchingSerializationExclusionPolicy[] exclusionCases = originatingMatchlet.getExclusionCases();
        if (exclusionCases == null || exclusionCases.length == 0) {
            if (originatingMatchlet.getClass().isAnnotationPresent(MatchletDefaultSerializationExclusionPolicy.class)) {
                this._originatingMatchletExclusionPolicies = originatingMatchlet.getClass().getAnnotation(MatchletDefaultSerializationExclusionPolicy.class).value();
            }
        } else {
            this._originatingMatchletExclusionPolicies = exclusionCases;
        }
    }

    @XmlElementWrapper(name="MatchingResultsData")
    @XmlElement(name="MatchingResultData")
    public Collection<MatchingResultData<SOURCE_DATA, TARGET_DATA>> getMatchingsResultData() {
        return this._matchingResultsData;
    }

    public void setMatchingsResultData(Collection<MatchingResultData<SOURCE_DATA, TARGET_DATA>> dataMatchings) {
        AssertionUtils.$nNull(dataMatchings, "The data matchings cannot be null", new Object[0]);
        this._matchingResultsData = dataMatchings;
    }

    public final boolean containsMatchingFor(SOURCE_DATA sourceData, DataIdentifier sourceIdentifier) {
        return this.getMatchingsResultDataFor(sourceData, sourceIdentifier) != null;
    }

    public final MatchingResultData<SOURCE_DATA, TARGET_DATA> getMatchingsResultDataFor(SOURCE_DATA sourceData, DataIdentifier sourceIdentifier) {
        for (MatchingResultData<SOURCE_DATA, TARGET_DATA> currentDataMatching : this.getMatchingsResultData()) {
            SOURCE_DATA currentData = currentDataMatching.getSourceData();
            if (currentData == null || !currentData.equals(sourceData)) continue;
            return currentDataMatching;
        }
        return null;
    }

    public boolean isNoMatch() {
        return this._score.isNoMatch();
    }

    public boolean isFullMatch() {
        return this._score.isFullMatch();
    }

    public boolean isAuthoritative() {
        return this._score.isAuthoritative();
    }

    public boolean isNonAuthoritative() {
        return this._score.isNonAuthoritative();
    }

    public boolean isNonPerformed() {
        return this._score.isNonPerformed();
    }

    public String toString() {
        return "[ M: " + this._originatingMatchletName + ", " + "MW: " + this._originatingMatchletWeight + ", " + "MS: " + this._score + ", " + "MRSD: " + this._matchingResultsData + " ]";
    }

    public boolean excludeFromSerialization() {
        AssertionUtils.$nNull(this._score, "The matching score cannot be null", new Object[0]);
        if (this._originatingMatchletExclusionPolicies != null) {
            MatchingSerializationExclusionPolicy[] matchingSerializationExclusionPolicyArray = this._originatingMatchletExclusionPolicies;
            int n = this._originatingMatchletExclusionPolicies.length;
            int n2 = 0;
            while (n2 < n) {
                MatchingSerializationExclusionPolicy exclusionCase = matchingSerializationExclusionPolicyArray[n2];
                if (exclusionCase.shouldExclude(this._score)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @XmlTransient
    public String getOriginatingMatchletName() {
        return this._originatingMatchletName;
    }

    public void setOriginatingMatchletName(String originatingMatchletName) {
        this._originatingMatchletName = originatingMatchletName;
    }

    @XmlTransient
    public String getOriginatingMatchletId() {
        return this._originatingMatchletId;
    }

    public void setOriginatingMatchletId(String originatingMatchletId) {
        this._originatingMatchletId = originatingMatchletId;
    }
}

