/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.patterns.data.partitioners;

import java.util.Collection;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.patterns.data.partitioners.SpeciesDataPartitioner;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class InitialsBasedSpeciesDataPartitioner
extends SpeciesDataPartitioner {
    public static final int GREEDY = 0;
    private int _lookupLength = 0;

    public InitialsBasedSpeciesDataPartitioner() {
    }

    public InitialsBasedSpeciesDataPartitioner(int lookupLength) {
        this.setLookupLength(lookupLength);
    }

    public final int getLookupLength() {
        return this._lookupLength;
    }

    public final void setLookupLength(int lookupLength) {
        AssertionUtils.$true(lookupLength >= 0, "The lookup length parameter must be greater than or equal to {} (actually: {})", 0, lookupLength);
        this._lookupLength = lookupLength;
    }

    @Override
    public boolean include(ReferenceSpeciesData source, ReferenceSpeciesData target, Collection<? extends Matchlet<ReferenceSpeciesData, ?, ReferenceSpeciesData, ?>> matchlets) {
        boolean sameSpecies;
        TypedComplexName sourceGenus = source.getGenusCName();
        TypedComplexName targetGenus = target.getGenusCName();
        TypedComplexName sourceSpecies = source.getSpeciesCName();
        TypedComplexName targetSpecies = target.getSpeciesCName();
        boolean bothGenuses = sourceGenus != null && targetGenus != null && sourceGenus.getSimplifiedName().length() > 1 && targetGenus.getSimplifiedName().length() > 1;
        boolean bothSpecies = sourceSpecies != null && targetSpecies != null && sourceSpecies.getSimplifiedName().length() > 1 && targetSpecies.getSimplifiedName().length() > 1;
        boolean sameGenuses = !bothGenuses || this.sameInitials(sourceGenus.getSimplifiedName(), targetGenus.getSimplifiedName(), this._lookupLength);
        boolean bl = sameSpecies = !bothSpecies || this.sameInitials(sourceSpecies.getSimplifiedName(), targetSpecies.getSimplifiedName(), this._lookupLength);
        return (bothGenuses || bothSpecies) && sameGenuses && sameSpecies;
    }

    protected boolean sameInitials(String first, String second, int lookupLength) {
        int actualLength = Math.min(Math.min(lookupLength, first.length() - 1), second.length() - 1);
        if (this._lookupLength == 0) {
            return first.contains(second) || second.contains(first);
        }
        return first.substring(0, actualLength).equalsIgnoreCase(second.substring(0, actualLength));
    }
}

