/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.beans.io.net;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.fao.vrmf.core.helpers.beans.AbstractHelperBean;
import org.fao.vrmf.core.helpers.beans.io.net.support.HTTPRequestMetadata;
import org.fao.vrmf.core.impl.design.patterns.pair.NameValuePair;

@Named
public final class HTTPUtils
extends AbstractHelperBean {
    private static final long serialVersionUID = 5145127782905297515L;
    private int _timeout = 0;
    private boolean _mustAuthenticate = false;
    private String _proxyHost;
    private int _proxyPort;
    private String _proxyUsername;
    private String _proxyPassword;
    private String _proxyClientHost;
    private String _proxyDomain;
    private static final int BUFFER_SIZE = 8192;
    public static final boolean FOLLOW_REDIRECTS = true;
    public static final boolean DONT_FOLLOW_REDIRECTS = false;

    public HTTPUtils() {
    }

    public HTTPUtils(int timeout) {
        this._timeout = timeout;
    }

    public boolean getMustAuthenticate() {
        return this._mustAuthenticate;
    }

    public void setMustAuthenticate(boolean mustAuthenticate) {
        this._mustAuthenticate = mustAuthenticate;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this._proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this._proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public String getProxyClientHost() {
        return this._proxyClientHost;
    }

    public void setProxyClientHost(String proxyClientHost) {
        this._proxyClientHost = proxyClientHost;
    }

    public String getProxyDomain() {
        return this._proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this._proxyDomain = proxyDomain;
    }

    public String fetchHTMLPageAsString(HttpRequestBase method, String URL2, String charset, Collection<NameValuePair> headers, int timeout) throws IOException {
        HTTPRequestMetadata response = this.fetchURLAsBytes(method, URL2, headers, false, timeout);
        return new String(response.getContent(), charset);
    }

    public String fetchHTMLPageAsString(HttpRequestBase method, String URL2, String charset, Collection<NameValuePair> headers) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, charset, headers, this._timeout);
    }

    public String fetchHTMLPageAsString(String URL2, String charset) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, charset, null, this._timeout);
    }

    public String fetchHTMLPageAsString(String URL2, String charset, int timeout) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, charset, null, timeout);
    }

    public String fetchHTMLPageAsString(HttpRequestBase method, String URL2, String charset) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, charset, null, this._timeout);
    }

    public String fetchHTMLPageAsString(HttpRequestBase method, String URL2, String charset, int timeout) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, charset, null, timeout);
    }

    public String fetchHTMLPageAsUTF8String(String URL2) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, "UTF-8", null, this._timeout);
    }

    public String fetchHTMLPageAsUTF8String(String URL2, int timeout) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, "UTF-8", null, timeout);
    }

    public String fetchHTMLPageAsUTF8String(HttpRequestBase method, String URL2) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, "UTF-8", null, this._timeout);
    }

    public String fetchHTMLPageAsUTF8String(HttpRequestBase method, String URL2, int timeout) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, "UTF-8", null, timeout);
    }

    public String fetchHTMLPageAsUTF8String(String URL2, Collection<NameValuePair> headers) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, "UTF-8", headers, this._timeout);
    }

    public String fetchHTMLPageAsUTF8String(String URL2, Collection<NameValuePair> headers, int timeout) throws IOException {
        return this.fetchHTMLPageAsString((HttpRequestBase)new HttpGet(), URL2, "UTF-8", headers, timeout);
    }

    public String fetchHTMLPageAsUTF8String(HttpRequestBase method, String URL2, Collection<NameValuePair> headers) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, "UTF-8", headers, this._timeout);
    }

    public String fetchHTMLPageAsUTF8String(HttpRequestBase method, String URL2, Collection<NameValuePair> headers, int timeout) throws IOException {
        return this.fetchHTMLPageAsString(method, URL2, "UTF-8", headers, timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(HttpRequestBase method, String URL2, Collection<NameValuePair> headers, boolean followRedirects, int timeout) throws IOException {
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.conn-manager.timeout", (Object)new Long(timeout / 2));
            client.getParams().setParameter("http.protocol.handle-redirects", (Object)followRedirects);
            client.getParams().setParameter("http.connection.timeout", (Object)(timeout / 2));
            client.getParams().setParameter("http.socket.timeout", (Object)timeout);
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new NoRetryHandler());
            method.setURI(new URI(HTTPUtils.encode(URL2)));
            if (headers != null && !headers.isEmpty()) {
                for (NameValuePair header : headers) {
                    method.addHeader(header.getName(), header.getValue().toString());
                }
            }
            if (this._proxyHost != null) {
                client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(this._proxyHost, this._proxyPort, "http"));
                if (this._mustAuthenticate) {
                    client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new NTCredentials(this._proxyUsername, this._proxyPassword, this._proxyClientHost, this._proxyDomain));
                }
            }
            long start = System.currentTimeMillis();
            this._log.debug("Fetching {} via {}", (Object)URL2, (Object)method);
            HttpResponse response = client.execute((HttpUriRequest)method);
            HttpEntity entity = response.getEntity();
            int statusCode = response.getStatusLine().getStatusCode();
            String statusMessage = response.getStatusLine().getReasonPhrase();
            long end = System.currentTimeMillis();
            this._log.debug("Done. Fetched {} (status code is {} [ {} ])", new Object[]{URL2, statusCode, statusMessage});
            int readLength = -1;
            byte[] buffer = new byte[8192];
            InputStream resultStream = entity.getContent();
            ByteArrayOutputStream outputStream = null;
            outputStream = new ByteArrayOutputStream();
            try {
                while ((readLength = resultStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, readLength);
                }
            }
            finally {
                if (resultStream != null) {
                    resultStream.close();
                }
            }
            byte[] result = outputStream.toByteArray();
            end = System.currentTimeMillis();
            Header[] responseHeaders = response.getAllHeaders();
            method.releaseConnection();
            ClientConnectionManager manager = client.getConnectionManager();
            manager.closeExpiredConnections();
            manager.closeIdleConnections((long)(this._timeout * 2), TimeUnit.MILLISECONDS);
            return new HTTPRequestMetadata(URL2, new Date(start), end - start, statusCode, responseHeaders, result);
        }
        catch (URISyntaxException URISe) {
            throw new RuntimeException(URISe);
        }
    }

    public HTTPRequestMetadata fetchURLAsBytes(String URL2) throws IOException {
        return this.fetchURLAsBytes((HttpRequestBase)new HttpGet(), URL2, null, false, this._timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(String URL2, int timeout) throws IOException {
        return this.fetchURLAsBytes((HttpRequestBase)new HttpGet(), URL2, null, false, timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(String URL2, Collection<NameValuePair> headers) throws IOException {
        return this.fetchURLAsBytes((HttpRequestBase)new HttpGet(), URL2, headers, false, this._timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(String URL2, Collection<NameValuePair> headers, int timeout) throws IOException {
        return this.fetchURLAsBytes((HttpRequestBase)new HttpGet(), URL2, headers, false, timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(HttpRequestBase method, String URL2) throws IOException {
        return this.fetchURLAsBytes(method, URL2, null, false, this._timeout);
    }

    public HTTPRequestMetadata fetchURLAsBytes(HttpRequestBase method, String URL2, int timeout) throws IOException {
        return this.fetchURLAsBytes(method, URL2, null, false, timeout);
    }

    public String storePage(String page, File path, String filename, String charset) throws IOException {
        this._log.debug("Storing page as '" + filename + "' under path '" + path.getName() + "'");
        File out = new File(String.valueOf(path.getAbsolutePath()) + File.separator + filename);
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            fos = new FileOutputStream(out);
            writer = new OutputStreamWriter((OutputStream)fos, Charset.forName(charset));
            writer.write(page);
            writer.flush();
            this._log.debug("Page has been stored");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return page;
    }

    public String storePageAsUTF8(String page, File path, String filename) throws IOException {
        return this.storePage(page, path, filename, "UTF-8");
    }

    public static boolean checkService(String host, int port) {
        try {
            new Socket(host, port).close();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String encode(String toEncode) {
        try {
            URL url = new URL(toEncode);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            return uri.toASCIIString();
        }
        catch (MalformedURLException MURLe) {
            return toEncode;
        }
        catch (URISyntaxException URISe) {
            return toEncode;
        }
    }

    public static String decode(String toDecode) {
        try {
            URI uri = new URI(toDecode);
            URL url = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
            String decoded = url.toString();
            if (uri.getQuery() != null) {
                decoded = String.valueOf(decoded) + "?" + uri.getQuery();
            }
            return decoded;
        }
        catch (URISyntaxException URISe) {
            return toDecode;
        }
        catch (MalformedURLException MURLe) {
            return toDecode;
        }
    }

    private static class NoRetryHandler
    implements HttpRequestRetryHandler {
        private NoRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return executionCount < 1;
        }
    }
}

