/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.model.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.fao.fi.comet.core.exceptions.MatchingEngineConfigurationException;
import org.fao.fi.comet.core.exceptions.MatchletConfigurationException;
import org.fao.fi.comet.core.model.matchlets.MatchletConfiguration;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

@XmlType(name="MatchingEngineProcessConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MatchingEngineProcessConfiguration
implements Serializable {
    public static final int MAX_CANDIDATES_PER_ENTRY_UNBOUND = 0;
    public static final boolean HALT_AT_FIRST_VALID_MATCHING = true;
    public static final boolean DONT_HALT_AT_FIRST_VALID_MATCHING = false;
    public static final boolean HANDLE_ERRORS = true;
    public static final boolean DONT_HANDLE_ERRORS = false;
    private static final long serialVersionUID = 3680496607335454252L;
    @XmlElement(name="MinimumAllowedWeightedScore", nillable=true)
    protected Double _minimumAllowedWeightedScore;
    @XmlElement(name="MaxCandidatesPerEntry", nillable=true)
    protected Integer _maxCandidatesPerEntry;
    @XmlElement(name="HaltAtFirstValidMatching", nillable=true)
    protected Boolean _haltAtFirstValidMatching;
    @XmlElement(name="HandleErrors", nillable=true)
    protected Boolean _handleErrors;
    @XmlElementWrapper(name="MatchletsConfigurations", nillable=false)
    @XmlElement(name="MatchletConfiguration", nillable=false)
    protected Collection<MatchletConfiguration> _matchletsConfigurations = new ArrayList<MatchletConfiguration>();

    public Double getMinimumAllowedWeightedScore() {
        return this._minimumAllowedWeightedScore;
    }

    public Integer getMaxCandidatesPerEntry() {
        return this._maxCandidatesPerEntry;
    }

    public Boolean getHaltAtFirstValidMatching() {
        return this._haltAtFirstValidMatching;
    }

    public void setMinimumAllowedWeightedScore(Double minimumAllowedWeightedScore) {
        this._minimumAllowedWeightedScore = minimumAllowedWeightedScore;
    }

    public void setMaxCandidatesPerEntry(Integer maxCandidatesPerEntry) {
        this._maxCandidatesPerEntry = maxCandidatesPerEntry;
    }

    public void setHaltAtFirstValidMatching(Boolean haltAtFirstValidMatching) {
        this._haltAtFirstValidMatching = haltAtFirstValidMatching;
    }

    public Boolean getHandleErrors() {
        return this._handleErrors;
    }

    public void setHandleErrors(Boolean handleErrors) {
        this._handleErrors = handleErrors;
    }

    public Collection<MatchletConfiguration> getMatchletsConfigurations() {
        return this._matchletsConfigurations;
    }

    public void setMatchletsConfiguration(Collection<MatchletConfiguration> matchletsConfiguration) {
        this._matchletsConfigurations = matchletsConfiguration;
    }

    public void validate() throws MatchingEngineConfigurationException, MatchletConfigurationException {
        try {
            if (this._minimumAllowedWeightedScore != null) {
                AssertionUtils.$gt(this._minimumAllowedWeightedScore, 0.0, "Minimum allowed weighted score ({}) cannot be lower than (or equal to) the minimum valid score ({})", this._minimumAllowedWeightedScore, 0.0);
                AssertionUtils.$lte(this._minimumAllowedWeightedScore, 1.0, "Minimum allowed weighted score ({}) cannot be greater than the maximum valid score ({})", this._minimumAllowedWeightedScore, 1.0);
            } else {
                this._minimumAllowedWeightedScore = 0.3;
            }
            if (this._maxCandidatesPerEntry != null) {
                AssertionUtils.$nNeg(this._maxCandidatesPerEntry, "Maximum candidates per entry must be greater than or equal to zero (currently: {})", this._maxCandidatesPerEntry);
                if (this._haltAtFirstValidMatching != null) {
                    AssertionUtils.$false(this._maxCandidatesPerEntry > 1 && this._haltAtFirstValidMatching != false, "You cannot set the max number of candidates per entry (currently: {}) and the 'halt at first valid matching' flag", this._maxCandidatesPerEntry);
                }
            } else {
                this._maxCandidatesPerEntry = 0;
            }
            if (this._haltAtFirstValidMatching == null) {
                this._haltAtFirstValidMatching = false;
            }
            if (this._handleErrors == null) {
                this._handleErrors = false;
            }
        }
        catch (IllegalArgumentException IAe) {
            throw new MatchingEngineConfigurationException(IAe.getMessage());
        }
    }
}

