/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.io.providers.streaming;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fao.fi.comet.core.model.common.LinkedTypedComplexName;
import org.fao.fi.comet.core.patterns.data.providers.impl.DataProviderSkeleton;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.io.providers.streaming.StreamingSpeciesReferenceDataProvider;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;

public abstract class AbstractSpeciesReferenceDataProvider
extends DataProviderSkeleton<ReferenceSpeciesData>
implements StreamingSpeciesReferenceDataProvider {
    protected String _taxaResourceURI;
    protected String _vernacularNamesResourceURI;
    protected Map<String, LinkedTypedComplexName[]> _vernacularNamesMap;

    public AbstractSpeciesReferenceDataProvider() {
    }

    public AbstractSpeciesReferenceDataProvider(String providerId, String taxaResourceURI, String vernacularNamesResourceURI) throws IOException {
        super(providerId);
        this.setURIs(taxaResourceURI, vernacularNamesResourceURI);
    }

    @Override
    public final boolean isRewindable() {
        return true;
    }

    protected abstract LinkedTypedComplexName[] getVernacularNames(String var1) throws IOException;

    @Override
    public void setURIs(String taxaResourceURI, String vernacularNamesResourceURI) throws IOException {
        AssertionUtils.$nNull(taxaResourceURI, "The taxa resource URL cannot be NULL", new Object[0]);
        this.testEndpoint(taxaResourceURI);
        this._taxaResourceURI = taxaResourceURI;
        if (this._vernacularNamesResourceURI != null) {
            this.testEndpoint(vernacularNamesResourceURI);
        }
        this._vernacularNamesResourceURI = vernacularNamesResourceURI;
        this._vernacularNamesMap = this.buildVernacularNamesMap(this.getVernacularNames(vernacularNamesResourceURI));
    }

    @Override
    public boolean isProtocolValid(String protocol) {
        return this.getManagedProtocols() != null && new ListSet<String>((Collection<String>)Arrays.asList(this.getManagedProtocols())).contains(protocol);
    }

    protected final Map<String, LinkedTypedComplexName[]> buildVernacularNamesMap(LinkedTypedComplexName[] vernacularNames) {
        if (vernacularNames == null || vernacularNames.length == 0) {
            return null;
        }
        HashMap<String, LinkedTypedComplexName[]> vernacularNamesMap = new HashMap<String, LinkedTypedComplexName[]>();
        LinkedTypedComplexName[] linkedTypedComplexNameArray = vernacularNames;
        int n = vernacularNames.length;
        int n2 = 0;
        while (n2 < n) {
            LinkedTypedComplexName vernacularName = linkedTypedComplexNameArray[n2];
            if (vernacularName != null && !vernacularName.isEmpty()) {
                vernacularNames = (LinkedTypedComplexName[])vernacularNamesMap.get(vernacularName.getParentId());
                if (vernacularNames == null) {
                    vernacularNames = new LinkedTypedComplexName[]{};
                }
                vernacularNamesMap.put(vernacularName.getParentId(), CollectionsUtils.append(vernacularNames, new LinkedTypedComplexName[]{vernacularName}));
            }
            ++n2;
        }
        for (String key : vernacularNamesMap.keySet()) {
            vernacularNames = (LinkedTypedComplexName[])vernacularNamesMap.get(key);
            vernacularNamesMap.put(key, this.uniqueEntries(vernacularNames));
        }
        return vernacularNamesMap.isEmpty() ? null : vernacularNamesMap;
    }

    private LinkedTypedComplexName[] uniqueEntries(LinkedTypedComplexName[] source) {
        if (source == null || source.length == 0) {
            return source;
        }
        ListSet<LinkedTypedComplexName> asList = new ListSet<LinkedTypedComplexName>((Collection<LinkedTypedComplexName>)Arrays.asList(source));
        return asList.toArray(new LinkedTypedComplexName[asList.size()]);
    }
}

