/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.parsers.cli;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.fao.fi.comet.domain.species.InputSpeciesFactory;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.tools.io.readers.ParsedInputDataFileReader;
import org.fao.fi.comet.domain.species.tools.io.readers.UnstructuredInputDataFileReader;
import org.fao.fi.comet.domain.species.tools.parsers.SpeciesNameParser;
import org.fao.fi.comet.domain.species.tools.parsers.StructuredSpeciesNameParser;
import org.fao.fi.comet.domain.species.tools.preprocess.RulesetManager;
import org.fao.fi.comet.domain.species.tools.preprocess.model.RuleTargets;
import org.fao.fi.comet.domain.species.tools.preprocess.post.PostparsingRules;
import org.fao.fi.comet.domain.species.tools.preprocess.pre.PreparsingRules;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.XMLBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputDataParser {
    private static Logger LOG = LoggerFactory.getLogger(InputDataParser.class);
    private static String VERSION = "1.2.0";
    private static final String HELP = "h";
    private static final String IN_FILE = "inFile";
    private static final String OUT_FILE = "outFile";
    private static final String PREPARSING_RULESET = "preParsingRuleset";
    private static final String PREPARSING_RULESET_FILE = "preParsingRulesetFile";
    private static final String POSTPARSING_RULESET = "postParsingRuleset";
    private static final String POSTPARSING_RULESET_FILE = "postParsingRulesetFile";
    private static final String PARSER = "parser";
    private static final String NO_HEADER = "noHeader";
    private static final String PROVIDER_ID = "providerId";
    private static final UnstructuredInputDataFileReader READER = new UnstructuredInputDataFileReader();

    private Iterable<SpeciesNameParser> getAvailableParsers() {
        return ServiceLoader.load(SpeciesNameParser.class);
    }

    private Options buildOptions() throws IOException {
        Collection<String> preRules = this.listPreprocessingRulesets();
        Collection<String> postRules = this.listPostprocessingRulesets();
        if (preRules == null) {
            preRules = new ArrayList<String>();
        }
        if (postRules == null) {
            postRules = new ArrayList<String>();
        }
        TreeSet<String> parserNames = new TreeSet<String>();
        for (SpeciesNameParser parser : this.getAvailableParsers()) {
            parserNames.add(String.valueOf(parser.getId()) + " (" + parser.getName() + ")");
        }
        Options options = new Options();
        options.addOption(new Option(HELP, false, "Print this message"));
        options.addOption(new Option(IN_FILE, true, "Specify a path to the file containing unstructured input data (one per line)"));
        options.addOption(new Option(OUT_FILE, true, "Specify a path to the file that will contain the structured parsed results"));
        options.addOption(new Option(NO_HEADER, false, "Omit the CSV header in the produced parsed results file"));
        options.addOption(new Option(PREPARSING_RULESET, true, "Specify an embedded pre-parsing ruleset among { " + CollectionsUtils.join(preRules, ", ") + " }"));
        options.addOption(new Option(PREPARSING_RULESET_FILE, true, "Specify a file containing a pre-parsing ruleset"));
        options.addOption(new Option(POSTPARSING_RULESET, true, "Specify an embedded post-parsing ruleset among { " + CollectionsUtils.join(postRules, ", ") + " }"));
        options.addOption(new Option(POSTPARSING_RULESET_FILE, true, "Specify a file containing a post-parsing ruleset"));
        options.addOption(new Option(PARSER, true, "Specify one of the available input parsers among { " + CollectionsUtils.join(parserNames, ", ") + " }"));
        options.addOption(new Option(PROVIDER_ID, true, "Specify the identifier for the data provider originating these input data. Defaults to 'UserProvidedData' when not set"));
        return options;
    }

    private void initializeAndLaunch(CommandLine commandLine) throws Throwable {
        PostparsingRules rules;
        String[] stringArray;
        int n;
        PreparsingRules rules2;
        LOG.info("### YASMEEN - {} v{} : scientific name and authority parsing tool", (Object)InputDataParser.class.getSimpleName(), (Object)VERSION);
        String parser = commandLine.getOptionValue(PARSER);
        AssertionUtils.$nNull(parser, "Please specify a parser with the -{} option", PARSER);
        SpeciesNameParser nameParser = null;
        for (SpeciesNameParser currentNameParser : this.getAvailableParsers()) {
            if (!currentNameParser.getId().equals(parser)) continue;
            nameParser = currentNameParser;
            break;
        }
        AssertionUtils.$nNull(nameParser, "Please specify a valid parser with the -{} option", PARSER);
        String inFile = commandLine.getOptionValue(IN_FILE);
        AssertionUtils.$nNull(inFile, "Please specify an input file with the -{} option", IN_FILE);
        File in = new File(inFile);
        AssertionUtils.$true(in.exists(), "Unable to find input file {}", inFile);
        AssertionUtils.$true(in.isFile() && in.canRead(), "Specified input file is not a proper file or cannot be read", new Object[0]);
        String outFile = commandLine.getOptionValue(OUT_FILE);
        if (outFile == null) {
            outFile = String.valueOf(in.getAbsolutePath()) + ".parsed";
            LOG.warn("No output file specified: using {}", (Object)outFile);
        }
        ArrayList<PreparsingRules> preParsing = new ArrayList<PreparsingRules>();
        ArrayList<PostparsingRules> postParsing = new ArrayList<PostparsingRules>();
        String[] preParsingRulesets = commandLine.getOptionValues(PREPARSING_RULESET);
        String[] postParsingRulesets = commandLine.getOptionValues(POSTPARSING_RULESET);
        String[] preParsingRulesetFiles = commandLine.getOptionValues(PREPARSING_RULESET_FILE);
        String[] postParsingRulesetFiles = commandLine.getOptionValues(POSTPARSING_RULESET_FILE);
        ListSet<String> availablePreParsingRulesets = new ListSet<String>(this.listPreprocessingRulesets());
        ListSet<String> availablePostParsingRulesets = new ListSet<String>(this.listPostprocessingRulesets());
        int numPreRules = 0;
        if (preParsingRulesets != null) {
            rules2 = null;
            String[] stringArray2 = preParsingRulesets;
            n = preParsingRulesets.length;
            int n2 = 0;
            while (n2 < n) {
                String ruleset = stringArray2[n2];
                AssertionUtils.$true(availablePreParsingRulesets.contains(ruleset), "Invalid pre-parsing ruleset '{}'", ruleset);
                LOG.info(" * Attempting to load pre-parsing ruleset '{}'...", (Object)ruleset);
                try {
                    rules2 = RulesetManager.readEmbeddedPreparsingRules(ruleset);
                    if (rules2 != null) {
                        preParsing.add(rules2);
                    }
                }
                catch (Throwable t) {
                    LOG.warn(" ! Pre-parsing ruleset '{}' is not well-formed [ {} ]", (Object)ruleset, (Object)t.getMessage());
                }
                if (rules2 == null || rules2.getRuleset() == null || rules2.getRuleset().isEmpty()) {
                    LOG.warn(" ! Pre-parsing ruleset '{}' does not contain any rule", (Object)ruleset);
                } else {
                    LOG.info(" * Pre-parsing ruleset '{}' contains {} rule(s)", (Object)ruleset, (Object)rules2.getRuleset().size());
                    numPreRules += rules2.getRuleset().size();
                }
                ++n2;
            }
            LOG.info("{} Pre-parsing rulesets correctly loaded, providing a total of {} pre-parsing rule(s)", (Object)preParsing.size(), (Object)numPreRules);
        }
        numPreRules = 0;
        if (preParsingRulesetFiles != null) {
            rules2 = null;
            stringArray = preParsingRulesetFiles;
            int n3 = preParsingRulesetFiles.length;
            n = 0;
            while (n < n3) {
                String rulesetFile = stringArray[n];
                File rsFile = new File(rulesetFile);
                AssertionUtils.$true(rsFile.exists(), "Pre-parsing ruleset file '{}' does not exist", rulesetFile);
                AssertionUtils.$true(rsFile.isFile(), "Pre-parsing ruleset file '{}' is not a proper file", rulesetFile);
                AssertionUtils.$true(rsFile.canRead(), "Pre-parsing ruleset file '{}' cannot be read", rulesetFile);
                LOG.info(" * Attempting to load pre-parsing ruleset from file '{}'...", (Object)rulesetFile);
                try {
                    rules2 = RulesetManager.readExternalPreparsingRules(rsFile);
                    if (rules2 != null) {
                        preParsing.add(rules2);
                    }
                }
                catch (Throwable t) {
                    LOG.warn(" ! Pre-parsing ruleset file '{}' is not well-formed [ {} ]", (Object)rulesetFile, (Object)t.getMessage());
                }
                if (rules2 == null || rules2.getRuleset() == null || rules2.getRuleset().isEmpty()) {
                    LOG.warn(" ! Pre-parsing ruleset file '{}' does not contain any rule", (Object)rulesetFile);
                } else {
                    LOG.info(" * Pre-parsing ruleset file '{}' contains {} rule(s)", (Object)rulesetFile, (Object)rules2.getRuleset().size());
                    numPreRules += rules2.getRuleset().size();
                }
                ++n;
            }
            LOG.info("{} Pre-parsing ruleset files correctly loaded, providing a total of {} pre-parsing rule(s)", (Object)preParsing.size(), (Object)numPreRules);
        }
        int numPostRules = 0;
        if (postParsingRulesets != null) {
            rules = null;
            stringArray = postParsingRulesets;
            int n4 = postParsingRulesets.length;
            n = 0;
            while (n < n4) {
                String ruleset = stringArray[n];
                AssertionUtils.$true(availablePostParsingRulesets.contains(ruleset), "Invalid post-parsing ruleset '{}'", ruleset);
                LOG.info(" * Attempting to load post-parsing ruleset '{}'...", (Object)ruleset);
                try {
                    rules = RulesetManager.readEmbeddedPostparsingRules(ruleset);
                    if (rules != null) {
                        postParsing.add(rules);
                    }
                }
                catch (Throwable t) {
                    LOG.warn(" ! Post-parsing ruleset '{}' is not well-formed [ {} ]", (Object)ruleset, (Object)t.getMessage());
                }
                if (rules == null || rules.getRuleset() == null || rules.getRuleset().isEmpty()) {
                    LOG.warn(" ! Post-parsing ruleset '{}' does not contain any rule", (Object)ruleset);
                } else {
                    LOG.info(" * Post-parsing ruleset '{}' contains {} rule(s)", (Object)ruleset, (Object)rules.getRuleset().size());
                    numPostRules += rules.getRuleset().size();
                }
                ++n;
            }
            LOG.info("{} Post-parsing rulesets correctly loaded, providing a total of {} post-parsing rule(s)", (Object)postParsing.size(), (Object)numPostRules);
        }
        numPostRules = 0;
        if (postParsingRulesetFiles != null) {
            rules = null;
            String[] stringArray3 = postParsingRulesetFiles;
            int n5 = postParsingRulesetFiles.length;
            int n6 = 0;
            while (n6 < n5) {
                String rulesetFile = stringArray3[n6];
                File rsFile = new File(rulesetFile);
                AssertionUtils.$true(rsFile.exists(), "Post-parsing ruleset file '{}' does not exist", rulesetFile);
                AssertionUtils.$true(rsFile.isFile(), "Post-parsing ruleset file '{}' is not a proper file", rulesetFile);
                AssertionUtils.$true(rsFile.canRead(), "Post-parsing ruleset file '{}' cannot be read", rulesetFile);
                LOG.info(" * Attempting to load post-parsing ruleset from file '{}'...", (Object)rulesetFile);
                try {
                    rules = RulesetManager.readExternalPostparsingRules(rsFile);
                    if (rules != null) {
                        postParsing.add(rules);
                    }
                }
                catch (Throwable t) {
                    LOG.warn(" ! Post-parsing ruleset file '{}' is not well-formed [ {} ]", (Object)rulesetFile, (Object)t.getMessage());
                }
                if (rules == null || rules.getRuleset() == null || rules.getRuleset().isEmpty()) {
                    LOG.warn(" ! Post-parsing ruleset file '{}' does not contain any rule", (Object)rulesetFile);
                } else {
                    LOG.info(" * Post-parsing ruleset file '{}' contains {} rule(s)", (Object)rulesetFile, (Object)rules.getRuleset().size());
                    numPostRules += rules.getRuleset().size();
                }
                ++n6;
            }
            LOG.info("{} Post-parsing ruleset files correctly loaded, providing a total of {} post-parsing rule(s)", (Object)preParsing.size(), (Object)numPostRules);
        }
        String dataSourceId = commandLine.hasOption(PROVIDER_ID) ? commandLine.getOptionValue(PROVIDER_ID) : "UserProvidedData";
        File out = new File(outFile);
        this.writeParsedData(out, dataSourceId, commandLine.hasOption(NO_HEADER), this.parseData(this.readData(in), nameParser, preParsing), postParsing);
    }

    private String[] readData(File input) throws Throwable {
        return READER.read(input);
    }

    private InputSpeciesData[] parseData(String[] data, SpeciesNameParser nameParser, Collection<PreparsingRules> preParsingRules) {
        boolean preParse;
        ArrayList<InputSpeciesData> parsedData = new ArrayList<InputSpeciesData>();
        int numEntry = 1;
        String parserID = nameParser.getId();
        boolean isStructuredParser = nameParser instanceof StructuredSpeciesNameParser;
        ArrayList<String[]> preParsedEntries = new ArrayList<String[]>();
        long ppStart = System.currentTimeMillis();
        boolean bl = preParse = preParsingRules != null && !preParsingRules.isEmpty();
        if (preParse && isStructuredParser) {
            LOG.warn(" ! Using pre-parsing rules in combination with a structured parser like '{}' can lead to input data corruption!", (Object)parserID);
        }
        ArrayList<String> preParsedData = new ArrayList<String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String entry;
            String preParsed = entry = stringArray[n2];
            if (preParse) {
                for (PreparsingRules ruleset : preParsingRules) {
                    preParsed = ruleset.apply(preParsed);
                }
                LOG.debug("Input '{}' has been preprocessed as '{}'", (Object)entry, (Object)preParsed);
            }
            preParsedEntries.add(new String[]{entry, preParsed});
            preParsedData.add(preParsed);
            ++n2;
        }
        long ppEnd = System.currentTimeMillis();
        if (preParse) {
            LOG.info("Pre-parsing took {} mSec. on {} entries", (Object)(ppEnd - ppStart), (Object)data.length);
        }
        LOG.info("< {} > : parsing {} input entries...", (Object)parserID, (Object)data.length);
        long overallStart = System.currentTimeMillis();
        ReferenceSpeciesData[] parsedOriginalData = nameParser.parse(preParsedData.toArray(new String[preParsedData.size()]));
        int p = 0;
        while (p < preParsedEntries.size()) {
            String fullEntry;
            String[] preParsedEntry = (String[])preParsedEntries.get(p);
            ReferenceSpeciesData parsed = parsedOriginalData[p];
            if (parsed != null) {
                parsedData.add(InputSpeciesFactory.newInstance("UserProvidedData", String.valueOf(numEntry++), preParsedEntry[0], preParsedEntry[1], parsed.getScientificName(), parsed.getAuthor(), parsed.getScientificName(), parsed.getAuthor(), nameParser.getId()));
                fullEntry = "{ SCI_NAME: " + parsed.getScientificName() + ", AUTH: " + parsed.getAuthor() + "}";
                if (!XMLBuilderUtils.isStringValid(parsed.getScientificName())) {
                    LOG.warn("< {} > : Parsed entry for {} contains characters that are considererd invalid according to XML 1.0 definition. This entry will be skipped", (Object)parserID, (Object)preParsedEntry[0]);
                }
            } else {
                fullEntry = "< NULL >";
                LOG.warn("< {} > : Parsed entry for '{}' resolves to a NULL result", (Object)parserID, (Object)preParsedEntry[0]);
            }
            LOG.debug("Input data {} has been parsed to: {}", (Object)preParsedEntry[0], (Object)fullEntry);
            ++p;
        }
        long overallEnd = System.currentTimeMillis();
        LOG.info("< {} > : overall parsing of {} entries took {} mSec.", new Object[]{parserID, data.length, overallEnd - overallStart});
        return parsedData.toArray(new InputSpeciesData[parsedData.size()]);
    }

    private void writeParsedData(File out, String dataSourceID, boolean noHeader, InputSpeciesData[] parsedData, Collection<PostparsingRules> postParsingRules) throws Throwable {
        PrintWriter w = new PrintWriter(out, "UTF-8");
        if (!noHeader) {
            w.println(ParsedInputDataFileReader.PARSED_INPUT_DATA_FILE_HEADER);
        }
        int numLines = 0;
        long elapsed = 0L;
        boolean postParse = postParsingRules != null && !postParsingRules.isEmpty();
        InputSpeciesData[] inputSpeciesDataArray = parsedData;
        int n = parsedData.length;
        int n2 = 0;
        while (n2 < n) {
            long end;
            long start;
            InputSpeciesData current = inputSpeciesDataArray[n2];
            w.print("\"");
            w.print(current.getParser());
            w.print("\"");
            w.print(";");
            w.print("\"");
            w.print(dataSourceID.replaceAll("\\\"", "\"\""));
            w.print("\"");
            w.print(";");
            w.print("\"");
            w.print(current.getId().replaceAll("\\\"", "\"\""));
            w.print("\"");
            w.print(";");
            w.print("\"");
            w.print(current.getOriginal().replaceAll("\\\"", "\"\""));
            w.print("\"");
            w.print(";");
            w.print("\"");
            w.print(current.getPreparsedOriginal().replaceAll("\\\"", "\"\""));
            w.print("\"");
            w.print(";");
            String part = StringUtils.rawTrim(current.getParsedScientificName());
            if (part != null) {
                w.print("\"");
                w.print(part.replaceAll("\\\"", "\"\""));
                w.print("\"");
            }
            w.print(";");
            part = StringUtils.rawTrim(current.getParsedAuthority());
            if (part != null) {
                w.print("\"");
                w.print(part.replaceAll("\\\"", "\"\""));
                w.print("\"");
            }
            w.print(";");
            part = StringUtils.rawTrim(current.getParsedScientificName());
            if (part != null && postParse) {
                start = System.currentTimeMillis();
                for (PostparsingRules ruleSet : postParsingRules) {
                    part = ruleSet.apply(RuleTargets.PARSED_SCIENTIFIC_NAME, part);
                }
                end = System.currentTimeMillis();
                elapsed += end - start;
            }
            if (part != null) {
                w.print("\"");
                w.print(part.replaceAll("\\\"", "\"\""));
                w.print("\"");
            }
            w.print(";");
            part = StringUtils.rawTrim(current.getParsedAuthority());
            if (part != null && postParse) {
                start = System.currentTimeMillis();
                for (PostparsingRules ruleSet : postParsingRules) {
                    part = ruleSet.apply(RuleTargets.PARSED_AUTHORITY, part);
                }
                end = System.currentTimeMillis();
                elapsed += end - start;
            }
            if (part != null) {
                w.print("\"");
                w.print(part.replaceAll("\\\"", "\"\""));
                w.print("\"");
            }
            w.println();
            ++numLines;
            ++n2;
        }
        try {
            w.flush();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            w.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (postParse) {
            LOG.info("Post-parsing took {} mSec. on {} entries", (Object)elapsed, (Object)numLines);
        }
        LOG.info("{} parsed entries have been written to {}", (Object)numLines, (Object)out.getAbsolutePath());
    }

    private void route(CommandLine commandLine) throws Throwable {
        Options options = this.buildOptions();
        if (commandLine.hasOption(HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(128);
            formatter.printHelp(" ", options);
            System.exit(0);
        }
        this.initializeAndLaunch(commandLine);
    }

    private CommandLine buildCommandLine(String[] args) throws IOException, ParseException {
        return new PosixParser().parse(this.buildOptions(), args);
    }

    private void execute(String[] args) throws Throwable {
        this.route(this.buildCommandLine(args));
    }

    private Collection<String> listRulesets(String rulesetPackage) throws IOException {
        if (RulesetManager.DEFAULT_PREPARSING_RULESET_PACKAGE.equals(rulesetPackage)) {
            return Arrays.asList("commonPreparsingRules", "otherPreparsingRules", "bionymPreparsingRules");
        }
        if (RulesetManager.DEFAULT_POSTPARSING_RULESET_PACKAGE.equals(rulesetPackage)) {
            return Arrays.asList("bionymPostparsingRules");
        }
        return new ArrayList<String>();
    }

    private Collection<String> listPreprocessingRulesets() throws IOException {
        return this.listRulesets(RulesetManager.DEFAULT_PREPARSING_RULESET_PACKAGE);
    }

    private Collection<String> listPostprocessingRulesets() throws IOException {
        return this.listRulesets(RulesetManager.DEFAULT_POSTPARSING_RULESET_PACKAGE);
    }

    public static final void main(String[] args) throws Throwable {
        try {
            new InputDataParser().execute(args);
            System.exit(0);
        }
        catch (ParseException Pe) {
            LOG.error("{}: [ parser error ] : {}", (Object)InputDataParser.class.getSimpleName(), (Object)Pe.getMessage());
        }
        catch (IllegalArgumentException IAe) {
            LOG.error("{}: [ configuration error ] : {}", (Object)InputDataParser.class.getSimpleName(), (Object)IAe.getMessage());
        }
        catch (Throwable t) {
            LOG.error("{}: [ unexpected error ] : {}", (Object)InputDataParser.class.getSimpleName(), (Object)t.getMessage());
        }
        System.exit(-1);
    }
}

