/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.engine.process.handlers.impl;

import java.io.Serializable;
import org.fao.fi.comet.core.engine.process.handlers.impl.SilentMatchingProcessHandler;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMatchingProcessHandler<SOURCE extends Serializable>
extends SilentMatchingProcessHandler<SOURCE> {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void doNotifyProcessStartEvent(String processId) {
        this._log.info("Starting process with ID #{}");
    }

    @Override
    protected void doNotifyProcessEndEvent() {
        this._log.info("Ending process");
    }

    @Override
    protected void doNotifyNumberOfComparisonRoundsChanged(int rounds) {
        this._log.info("Number of comparison rounds changed to: {}", (Object)rounds);
    }

    @Override
    protected void doNotifyComparisonRoundStart(ProvidedData<SOURCE> source) {
        this._log.info("Starting comparison round for {}", source);
    }

    @Override
    protected void doNotifyComparisonRoundPerformed(ProvidedData<SOURCE> source) {
        this._log.info("Comparison round performed for {}", source);
    }

    @Override
    protected void doNotifyMaximumNumberOfAtomicComparisonsPerformedInRoundChanged(int comparisons) {
        this._log.debug("Maximum number of atomic comparisons performed in round changed to: {}", (Object)comparisons);
    }

    @Override
    protected void doNotifyAtomicComparisonStart() {
        this._log.debug("Atomic comparison start");
    }

    @Override
    protected void doNotifyTotalNumberOfAtomicComparisonsChanged(int atomicComparisons) {
        this._log.debug("Total number of atomic comparisons changed to: {}", (Object)atomicComparisons);
    }

    @Override
    protected void doNotifyAtomicComparisonPerformed() {
        this._log.debug("Atomic comparison performed");
    }

    @Override
    protected void doNotifyAtomicComparisonEnd() {
        this._log.debug("Atomic comparison end");
    }

    @Override
    protected void doNotifyMatchletsProcessStart() {
        this._log.debug("Matchlets process start");
    }

    @Override
    protected void doNotifyMaximumNumberOfMatchletsAppliedChanged(int matchlets) {
        this._log.debug("Maximum number of matchlets applied changed to: {}", (Object)matchlets);
    }
}

