/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.matchlets.extended;

import java.util.Arrays;
import java.util.Collection;
import org.fao.fi.comet.core.model.common.TypedComplexName;
import org.fao.fi.comet.core.model.engine.DataIdentifier;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletDefaultSerializationExclusionPolicy;
import org.fao.fi.comet.core.model.matchlets.annotations.MatchletIsOptionalByDefault;
import org.fao.fi.comet.core.model.matchlets.support.MatchingSerializationExclusionPolicy;
import org.fao.fi.comet.domain.species.matchlets.extended.AbstractCNameVectorialMatchlet;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;

@MatchletIsOptionalByDefault
@MatchletDefaultSerializationExclusionPolicy(value={MatchingSerializationExclusionPolicy.NON_PERFORMED})
public class AuthorityCNameMatchlet
extends AbstractCNameVectorialMatchlet {
    public static final String NAME = "AuthorityNameMatchlet";
    private static final long serialVersionUID = 2575788466351826783L;

    public AuthorityCNameMatchlet() {
        this._name = NAME;
    }

    public AuthorityCNameMatchlet(double levenshteinWeight, double soundexWeight, double trigramWeight) {
        super(levenshteinWeight, soundexWeight, trigramWeight);
        this._name = NAME;
    }

    @Override
    public String getDescription() {
        return "Matches authorities (author names) as extracted from a pair of input / reference matched entities";
    }

    @Override
    protected Collection<TypedComplexName> doExtractData(ReferenceSpeciesData entity, DataIdentifier dataIdentifier) {
        return entity.getAuthoritiesCName() == null ? null : Arrays.asList(entity.getAuthoritiesCName());
    }
}

