/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.domain.species.tools.process.matching.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.fao.fi.comet.core.engine.process.handlers.impl.SilentMatchingProcessHandler;
import org.fao.fi.comet.core.exceptions.MatchingEngineConfigurationException;
import org.fao.fi.comet.core.matchlets.skeleton.MatchletSkeleton;
import org.fao.fi.comet.core.model.engine.Matching;
import org.fao.fi.comet.core.model.engine.MatchingDetails;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessConfiguration;
import org.fao.fi.comet.core.model.engine.MatchingEngineProcessResult;
import org.fao.fi.comet.core.model.engine.MatchingResult;
import org.fao.fi.comet.core.model.matchlets.Matchlet;
import org.fao.fi.comet.core.model.matchlets.MatchletConfiguration;
import org.fao.fi.comet.core.patterns.data.partitioners.impl.IdentityDataPartitioner;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.SizeAwareDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.impl.DataProviderSkeleton;
import org.fao.fi.comet.core.patterns.data.providers.impl.basic.ArrayBackedDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.impl.basic.CollectionBackedDelegateDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.impl.basic.MultipleSizeAwareDataProvider;
import org.fao.fi.comet.core.uniform.engine.UMatchingEngineCore;
import org.fao.fi.comet.domain.species.matchlets.extended.AuthorityCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.AuthorityYearMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.FuzzyTaxamatchMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.GSAyMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.GenusCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.NormalizedGenusCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.NormalizedSpeciesCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.ScientificCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.SpeciesCNameMatchlet;
import org.fao.fi.comet.domain.species.matchlets.extended.VernacularCNameMatchlet;
import org.fao.fi.comet.domain.species.model.InputSpeciesData;
import org.fao.fi.comet.domain.species.model.ReferenceSpeciesData;
import org.fao.fi.comet.domain.species.patterns.data.partitioners.InitialsBasedSpeciesDataPartitioner;
import org.fao.fi.comet.domain.species.patterns.data.partitioners.LengthBasedSpeciesDataPartitioner;
import org.fao.fi.comet.domain.species.patterns.handlers.id.InputSpeciesIDHandler;
import org.fao.fi.comet.domain.species.patterns.handlers.id.TargetSpeciesIDHandler;
import org.fao.fi.comet.domain.species.tools.io.providers.streaming.StreamingSpeciesReferenceDataProvider;
import org.fao.fi.comet.domain.species.tools.io.readers.ParsedInputDataFileReader;
import org.fao.fi.comet.domain.species.tools.io.support.impl.DefaultTAFReferenceDataConverter;
import org.fao.fi.comet.domain.species.tools.lexical.processors.LexicalProcessorsUtils;
import org.fao.fi.comet.domain.species.tools.lexical.processors.impl.AuthoritiesNormalizerProcessor;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.AuthoritiesSimplifier;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.SpeciesNormalizer;
import org.fao.fi.comet.domain.species.tools.lexical.processors.queue.SpeciesSimplifier;
import org.fao.fi.comet.domain.species.tools.output.transform.XMLOutputTransformer;
import org.fao.vrmf.core.behaviours.design.patterns.pair.Pair;
import org.fao.vrmf.core.extensions.collections.impl.ListSet;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.CollectionsUtils;
import org.fao.vrmf.core.helpers.singletons.lang.objects.ObjectsUtils;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.helpers.singletons.text.xml.JAXBUtils;
import org.fao.vrmf.core.impl.design.patterns.pair.BasicPair;
import org.fao.vrmf.core.impl.logging.ImmutableLoggingClient;
import org.fao.vrmf.core.tools.lexical.processors.LexicalProcessor;
import org.fao.vrmf.core.tools.lexical.soundex.PhraseSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.SoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.impl.BasicSoundexGenerator;
import org.fao.vrmf.core.tools.lexical.soundex.impl.ExtendedPhraseSoundexGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingEngine
extends ImmutableLoggingClient {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingEngine.class);
    private static final String VERSION = "1.2.0.1";
    private static final String MIN_SCORE_THRESHOLD = "mst";
    private static final String MAX_MATCH_CANDIDATES = "mc";
    private static final String HALT_AT_FIRST_MATCH = "hfm";
    private static final String DATA_PARTITIONING_THRESHOLD = "dpt";
    private static final String PARTITION_DATA_BY_LENGTH = "dpl";
    private static final String PARTITION_DATA_BY_INITIALS = "dpi";
    private static final String LEXICAL_ALGORITHMS_WEIGHT = "law";
    private static final String ENABLE_SCIENTIFIC_NAME_MATCHING = "mSn";
    private static final String SCIENTIFIC_NAME_MATCHING_WEIGHT = "mSnw";
    private static final String SCIENTIFIC_NAME_MATCHING_THRESHOLD = "mSnt";
    private static final String ENABLE_GENUS_NAME_MATCHING = "mgn";
    private static final String GENUS_NAME_MATCHING_WEIGHT = "mgnw";
    private static final String GENUS_NAME_MATCHING_THRESHOLD = "mgnt";
    private static final String ENABLE_SPECIES_NAME_MATCHING = "msn";
    private static final String SPECIES_NAME_MATCHING_WEIGHT = "msnw";
    private static final String SPECIES_NAME_MATCHING_THRESHOLD = "msnt";
    private static final String ENABLE_NORMALIZED_GENUS_NAME_MATCHING = "mNgn";
    private static final String NORMALIZED_GENUS_NAME_MATCHING_WEIGHT = "mNgnw";
    private static final String NORMALIZED_GENUS_NAME_MATCHING_THRESHOLD = "mNgnt";
    private static final String ENABLE_NORMALIZED_SPECIES_NAME_MATCHING = "mNsn";
    private static final String NORMALIZED_SPECIES_NAME_MATCHING_WEIGHT = "mNsnw";
    private static final String NORMALIZED_SPECIES_NAME_MATCHING_THRESHOLD = "mNsnt";
    private static final String ENABLE_AUTHORITY_NAME_MATCHING = "man";
    private static final String AUTHORITY_NAME_MATCHING_WEIGHT = "manw";
    private static final String AUTHORITY_NAME_MATCHING_THRESHOLD = "mant";
    private static final String ENABLE_AUTHORITY_YEAR_MATCHING = "may";
    private static final String AUTHORITY_YEAR_MATCHING_WEIGHT = "mayw";
    private static final String AUTHORITY_YEAR_MATCHING_THRESHOLD = "mayt";
    private static final String ENABLE_VERNACULAR_NAME_MATCHING = "mvn";
    private static final String VERNACULAR_NAME_MATCHING_WEIGHT = "mvnw";
    private static final String VERNACULAR_NAME_MATCHING_THRESHOLD = "mvnt";
    private static final String LANGUAGE_NAME_SUGGESTION = "svl";
    private static final String ENABLE_FUZZY_TAXAMATCH_MATCHING = "mftm";
    private static final String FUZZY_TAXAMATCH_MATCHING_WEIGHT = "mftmw";
    private static final String FUZZY_TAXAMATCH_MATCHING_THRESHOLD = "mftmt";
    private static final String ENABLE_GSAY_MATCHING = "mgsay";
    private static final String GSAY_MATCHING_WEIGHT = "mgsayw";
    private static final String GSAY_MATCHING_THRESHOLD = "mgsayt";
    private static final String REFERENCE_DATA = "refData";
    private static final String INPUT_FILE = "inFile";
    private static final String DONT_SKIP_HEADER = "dontSkipHeader";
    private static final String OUTPUT_FILE = "outFile";
    private static final String XML_OUTPUT = "xml";
    private static final String XSLT_TEMPLATE = "xslTemplate";
    private static final String XSLT_TEMPLATE_FILE = "xslTemplateFile";
    private static final String REPORT_OUTPUT = "report";
    private static final String PARALLEL_THREADS = "pt";
    private static final String MATERIALIZE_TARGETS = "mt";
    private static final String WAIT_USER = "wait";
    private static final String VERBOSE = "verbose";
    private static final String HELP = "h";
    private static final String LOG_CONFIGURATION = "[ CONFIG ]";
    private static final String LOG_EXECUTION = "[ EXEC   ]";
    protected LexicalProcessor SPECIES_SIMPLIFIER;
    protected LexicalProcessor SPECIES_NORMALIZER;
    protected LexicalProcessor AUTHORITIES_SIMPLIFIER;
    protected final LexicalProcessor AUTHORITIES_NORMALIZER = new AuthoritiesNormalizerProcessor();
    protected final PhraseSoundexGenerator PHRASE_SOUNDEXER = new ExtendedPhraseSoundexGenerator();
    protected final SoundexGenerator SOUNDEXER = new BasicSoundexGenerator();
    private final ParsedInputDataFileReader PARSED_INPUT_DATA_READER = new ParsedInputDataFileReader();

    private Options buildOptions() {
        Options options = new Options();
        options.addOption(new Option(REFERENCE_DATA, true, "Specify coordinates for a reference data source. These are in the form: <PROVIDER ID>@<TAXA TAF URL>(,<VERNACULAR NAMES TAF URL>)"));
        options.addOption(new Option(MIN_SCORE_THRESHOLD, true, "Sets the matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(MAX_MATCH_CANDIDATES, true, "Sets the maximum number of matching candidates for each entry [1, n]"));
        options.addOption(new Option(HALT_AT_FIRST_MATCH, false, "Instructs the system to halt the current data process at the first valid matching (i.e. a matching with an overall score higher than the minimum set)"));
        options.addOption(new Option(DATA_PARTITIONING_THRESHOLD, true, "Set the data partitioning threshold (as a non-negative integer). When not specified, no data partitioning will be applied. If no specific data partitioning strategy is specified, defaults to length-based partitioning."));
        options.addOption(new Option(PARTITION_DATA_BY_INITIALS, false, "Enable data partitioning by string initials."));
        options.addOption(new Option(PARTITION_DATA_BY_LENGTH, false, "Enable data partitioning by string lengths."));
        options.addOption(new Option(LEXICAL_ALGORITHMS_WEIGHT, true, "Sets the different lexical algorithms weight for matchlets that do perform lexical comparisons. The syntax of this parameter is: <lev>:<sndx>:<trig>, with <lev> being the weight of the calculated Levenshtein similarity, <sndx> being the weight of the calculated soundex comparison and <trig> being the weight of the calculated trigram similarity. To enable Levenshtein similarity only, use -law 100:0:0. Conversely, to enable soundex only you should use: -law 0:100:0, to enable trigrams only you should use -law 0:0:100 and to enable an equal mix of all three, you should use -law 100:100:100. Valid values for each of these three weights are in the range [0, 100]"));
        options.addOption(new Option(ENABLE_SCIENTIFIC_NAME_MATCHING, false, "Enables the scientific name matching"));
        options.addOption(new Option(SCIENTIFIC_NAME_MATCHING_WEIGHT, true, "Sets the scientific name matching weight (0.0, n]"));
        options.addOption(new Option(SCIENTIFIC_NAME_MATCHING_THRESHOLD, true, "Sets the scientific name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_GENUS_NAME_MATCHING, false, "Enables the genus name matching"));
        options.addOption(new Option(GENUS_NAME_MATCHING_WEIGHT, true, "Sets the genus name matching weight (0.0, n]"));
        options.addOption(new Option(GENUS_NAME_MATCHING_THRESHOLD, true, "Sets the genus name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_NORMALIZED_GENUS_NAME_MATCHING, false, "Enables the normalized genus name matching"));
        options.addOption(new Option(NORMALIZED_GENUS_NAME_MATCHING_WEIGHT, true, "Sets the normalized genus name matching weight (0.0, n]"));
        options.addOption(new Option(NORMALIZED_GENUS_NAME_MATCHING_THRESHOLD, true, "Sets the normalized genus name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_SPECIES_NAME_MATCHING, false, "Enables the species name matching"));
        options.addOption(new Option(SPECIES_NAME_MATCHING_WEIGHT, true, "Sets the species name matching weight (0.0, n]"));
        options.addOption(new Option(SPECIES_NAME_MATCHING_THRESHOLD, true, "Sets the species name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_NORMALIZED_SPECIES_NAME_MATCHING, false, "Enables the normalized species name matching"));
        options.addOption(new Option(NORMALIZED_SPECIES_NAME_MATCHING_WEIGHT, true, "Sets the normalized species name matching weight (0.0, n]"));
        options.addOption(new Option(NORMALIZED_SPECIES_NAME_MATCHING_THRESHOLD, true, "Sets the normalized species name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_AUTHORITY_NAME_MATCHING, false, "Enables the authority name matching"));
        options.addOption(new Option(AUTHORITY_NAME_MATCHING_WEIGHT, true, "Sets the authority name matching weight (0.0, n]"));
        options.addOption(new Option(AUTHORITY_NAME_MATCHING_THRESHOLD, true, "Sets the authority name matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_AUTHORITY_YEAR_MATCHING, false, "Enables the authority year matching"));
        options.addOption(new Option(AUTHORITY_YEAR_MATCHING_WEIGHT, true, "Sets the authority year matching weight (0.0, n]"));
        options.addOption(new Option(AUTHORITY_YEAR_MATCHING_THRESHOLD, true, "Sets the authority year matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_FUZZY_TAXAMATCH_MATCHING, false, "Enables the FuzzyTaxamatch matching"));
        options.addOption(new Option(FUZZY_TAXAMATCH_MATCHING_WEIGHT, true, "Sets the FuzzyTaxamatch matching weight (0.0, n]"));
        options.addOption(new Option(FUZZY_TAXAMATCH_MATCHING_THRESHOLD, true, "Sets the FuzzyTaxamatch matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(ENABLE_GSAY_MATCHING, false, "Enables the GSAy matching"));
        options.addOption(new Option(GSAY_MATCHING_WEIGHT, true, "Sets the GSAy matching weight (0.0, n]"));
        options.addOption(new Option(GSAY_MATCHING_THRESHOLD, true, "Sets the GSAy matching results minimum score threshold (0.0, 1.0]"));
        options.addOption(new Option(OUTPUT_FILE, true, "Results will be written to this file. When not set defaults to standard output."));
        options.addOption(new Option(XML_OUTPUT, false, "Results will be emitted in XML format"));
        options.addOption(new Option(XSLT_TEMPLATE, true, "Specifies an embedded transformation template for the XML output among { " + CollectionsUtils.join(XMLOutputTransformer.AVAILABLE_TEMPLATES, ", ") + " }"));
        options.addOption(new Option(XSLT_TEMPLATE_FILE, true, "Apply the given XSL stylesheet to the XML output before emitting the results"));
        options.addOption(new Option(REPORT_OUTPUT, false, "Results are emitted in human-readable format"));
        options.addOption(new Option(MATERIALIZE_TARGETS, false, "If enabled, target data will be materialized in-memory before actually launching the process [ EXPERIMENTAL FEATURE ]"));
        options.addOption(new Option(PARALLEL_THREADS, true, "Specifies the number of threads for parallel execution. It can either be an absolute number (e.g. -pt 4 - use 4 parallel threads) or a relative number with respect to the number of cores (e.g. -pt 4.5x - use a number of thread that is 4.5 times the number of available cores) [ EXPERIMENTAL FEATURE ]"));
        options.addOption(new Option(INPUT_FILE, true, "Path to a text file containing the parsed input data (one per line)"));
        options.addOption(new Option(DONT_SKIP_HEADER, false, "Set this option if the parsed input data file doesn't start with a CSV header row"));
        options.addOption(new Option(WAIT_USER, false, "Request to wait for users hitting ENTER before starting the process"));
        options.addOption(new Option(VERBOSE, false, "Enables emitting some (very) verbose messages during the process"));
        options.addOption(new Option(HELP, false, "Print this message"));
        return options;
    }

    private CommandLine buildCommandLine(String[] args) throws ParseException {
        return new PosixParser().parse(this.buildOptions(), args);
    }

    private void route(CommandLine commandLine) throws Throwable {
        Options options = this.buildOptions();
        if (commandLine.hasOption(HELP)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(128);
            formatter.printHelp(" ", options);
            System.exit(0);
        }
        try {
            this.initializeAndLaunch(commandLine);
        }
        catch (MatchingEngineConfigurationException MECe) {
            LOG.error(MECe.getMessage());
        }
    }

    private StreamingSpeciesReferenceDataProvider getTargetDataProviderByProtocol(String URL2) {
        String protocol = URL2.substring(0, Math.max(0, URL2.indexOf(":")));
        ServiceLoader<StreamingSpeciesReferenceDataProvider> loader = ServiceLoader.load(StreamingSpeciesReferenceDataProvider.class);
        StreamingSpeciesReferenceDataProvider provider = null;
        for (StreamingSpeciesReferenceDataProvider serviceProvider : loader) {
            if (!serviceProvider.isProtocolValid(protocol)) continue;
            provider = serviceProvider;
        }
        if (provider == null) {
            throw new RuntimeException("No provider is available for protocol " + protocol);
        }
        return provider;
    }

    private SizeAwareDataProvider<ReferenceSpeciesData> getTargetDataProvider(boolean verbose, boolean materialize, int lexicalFlags, int taxaFlags, int vernacularFlags, Set<Pair<?, ?>[]> targets) throws Exception {
        CollectionBackedDelegateDataProvider<ReferenceSpeciesData> collectionBackedDelegateDataProvider;
        block14: {
            DataProviderSkeleton toReturn;
            block13: {
                toReturn = null;
                try {
                    if (materialize) {
                        ArrayList materialized = new ArrayList();
                        for (Pair<?, ?>[] target : targets) {
                            long start = System.currentTimeMillis();
                            Pair<?, ?> taxaRef = target[0];
                            Pair<?, ?> vernacularRef = target.length == 1 ? null : target[1];
                            String providerID = taxaRef.getLeftPart().toString();
                            LOG.info("{} : Materializing [ {} @ {} ] reference data in memory...", new Object[]{LOG_CONFIGURATION, providerID, taxaRef.getRightPart()});
                            if (vernacularRef != null) {
                                LOG.info("{} : Materialized reference data for {} will also include vernacular names available at {}", new Object[]{LOG_CONFIGURATION, taxaRef.getLeftPart(), vernacularRef.getRightPart()});
                            }
                            providerID = taxaRef.getLeftPart().toString();
                            StreamingSpeciesReferenceDataProvider provider = this.getTargetDataProviderByProtocol(taxaRef.getRightPart().toString());
                            provider.setProviderID(providerID);
                            provider.setURIs(taxaRef.getRightPart().toString(), vernacularRef == null ? null : vernacularRef.getRightPart().toString());
                            DefaultTAFReferenceDataConverter converter = new DefaultTAFReferenceDataConverter(lexicalFlags, taxaFlags, vernacularFlags);
                            provider.setConverter(converter);
                            int numMaterialized = 0;
                            for (ProvidedData data : provider) {
                                materialized.add(data);
                                if (++numMaterialized % 1000 != 0 || !verbose) continue;
                                LOG.info("{} : - Materialized {} reference data so far...", (Object)LOG_CONFIGURATION, (Object)numMaterialized);
                            }
                            if (numMaterialized % 1000 != 0 && verbose) {
                                LOG.info("{} : - Materialized {} reference data so far...", (Object)LOG_CONFIGURATION, (Object)numMaterialized);
                            }
                            long end = System.currentTimeMillis();
                            LOG.info("{} : OK. {} Reference data have been materialized in {} mSec.", new Object[]{LOG_CONFIGURATION, providerID, end - start});
                        }
                        toReturn = new CollectionBackedDelegateDataProvider<ReferenceSpeciesData>(materialized);
                    } else {
                        ArrayList<StreamingSpeciesReferenceDataProvider> currentTargets = new ArrayList<StreamingSpeciesReferenceDataProvider>();
                        for (Pair<?, ?>[] target : targets) {
                            Pair<?, ?> taxaRef = target[0];
                            Pair<?, ?> vernacularRef = target.length == 1 ? null : target[1];
                            String providerID = taxaRef.getLeftPart().toString();
                            StreamingSpeciesReferenceDataProvider provider = this.getTargetDataProviderByProtocol(taxaRef.getRightPart().toString());
                            provider.setURIs(taxaRef.getRightPart().toString(), vernacularRef == null ? null : vernacularRef.getRightPart().toString());
                            provider.setProviderID(providerID);
                            currentTargets.add(provider);
                        }
                        toReturn = new MultipleSizeAwareDataProvider(currentTargets.toArray(new SizeAwareDataProvider[currentTargets.size()]));
                        LOG.info("{} : Reference data will be streamed as necessary via {}", (Object)LOG_CONFIGURATION, (Object)toReturn.getClass().getSimpleName());
                    }
                    collectionBackedDelegateDataProvider = toReturn;
                    if (toReturn != null) break block13;
                }
                catch (Throwable throwable) {
                    if (toReturn == null) {
                        LOG.warn("{} : Unable to retrieve reference data...", (Object)LOG_EXECUTION);
                    } else if (materialize) {
                        int availableRefData = toReturn.getAvailableDataSize();
                        AssertionUtils.$true(availableRefData > 0, "No reference data are currently available according to configured providers", new Object[0]);
                        LOG.info("{} : {} available distinct reference species data", (Object)LOG_CONFIGURATION, (Object)availableRefData);
                    }
                    throw throwable;
                }
                LOG.warn("{} : Unable to retrieve reference data...", (Object)LOG_EXECUTION);
                break block14;
            }
            if (materialize) {
                int availableRefData = toReturn.getAvailableDataSize();
                AssertionUtils.$true(availableRefData > 0, "No reference data are currently available according to configured providers", new Object[0]);
                LOG.info("{} : {} available distinct reference species data", (Object)LOG_CONFIGURATION, (Object)availableRefData);
            }
        }
        return collectionBackedDelegateDataProvider;
    }

    private BasicPair<String, String> extractURL(String targetURL, String cd, String basePath, String providerID) {
        String protocol = targetURL.replaceAll("^([a-zA-Z]+)(:)(.+)", "$1");
        boolean isFile = "file".equals(protocol);
        boolean isClasspath = "classpath".equals(protocol);
        String expandedURL = targetURL.replaceAll("\\{providerId\\}", Matcher.quoteReplacement(providerID));
        if (isFile) {
            expandedURL = expandedURL.replaceAll("\\{cd\\}", Matcher.quoteReplacement(cd));
        } else if (isClasspath) {
            expandedURL = expandedURL.replaceAll("\\{basePath\\}", basePath);
        }
        if (!expandedURL.equals(targetURL)) {
            LOG.info("{} : Provided URL for {} is: {}", new Object[]{LOG_CONFIGURATION, providerID, targetURL});
            LOG.info("{} : Expanded URL for {} is: {}", new Object[]{LOG_CONFIGURATION, providerID, expandedURL});
            LOG.info("{} : - {providerId} has been expanded to: {}", (Object)LOG_CONFIGURATION, (Object)providerID);
            if (isFile) {
                LOG.info("{} : - {cd} has been expanded to: {}", (Object)LOG_CONFIGURATION, (Object)cd);
            } else if (isClasspath) {
                LOG.info("{} : - {basePath} has been expanded to: {}", (Object)LOG_CONFIGURATION, (Object)basePath);
            }
        }
        try {
            if (!isClasspath) {
                InputStream is = null;
                try {
                    is = new URL(expandedURL).openStream();
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable t) {
                            LOG.info("{} : Unable to close URL stream: {}", (Object)LOG_CONFIGURATION, (Object)t.getMessage());
                        }
                    }
                }
            }
            LOG.info("{} : Adding [ {} @ {} ] to the list of reference data providers", new Object[]{LOG_CONFIGURATION, providerID, expandedURL});
            return new BasicPair<String, String>(providerID, expandedURL);
        }
        catch (IOException IOe) {
            LOG.error("{} : Unable to access URL '{}' for provider with ID '{}'. Reason: [ {} ]", new Object[]{LOG_CONFIGURATION, expandedURL, providerID, IOe.getMessage()});
            return null;
        }
    }

    private SizeAwareDataProvider<ReferenceSpeciesData> getSourceDataProvider(ReferenceSpeciesData[] sourceData) {
        return new ArrayBackedDataProvider("UserProvidedData", (Serializable[])sourceData);
    }

    private void reportResultsHandler(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> result, String outFile) throws Throwable {
        PrintStream writer;
        File outputFile;
        boolean toStdout = outFile == null;
        File file = outputFile = toStdout ? null : new File(outFile);
        if (toStdout) {
            writer = System.out;
            LOG.info("{} : ############## OUTPUT DUMP - BEGIN", (Object)LOG_EXECUTION);
        } else {
            writer = new PrintStream(outputFile);
        }
        writer.println("************************");
        writer.println("Matching process result:");
        writer.println("************************");
        int dataCounter = 1;
        for (MatchingDetails<ReferenceSpeciesData, ReferenceSpeciesData> details : result.getResults().getMatchingDetails()) {
            String tempLine;
            writer.println();
            if (details.getSource() instanceof InputSpeciesData) {
                InputSpeciesData source = (InputSpeciesData)details.getSource();
                tempLine = "Input #" + dataCounter++ + " [ " + "Data source: " + details.getSourceProviderId() + ", " + "ID: " + details.getSourceId() + ", " + "Data [ " + "Original: " + source.getOriginal() + ", " + "Post-parsed: " + source.getPostParsedScientificName() + (source.getPostParsedAuthority() == null ? "" : " (" + source.getPostParsedAuthority() + ")") + ", " + "Parser: " + source.getParser() + " ]" + " ]";
            } else {
                tempLine = "Input #" + dataCounter++ + " [ Data source: " + details.getSourceProviderId() + " - ID: " + details.getSourceId() + " ]";
            }
            writer.println(StringUtils.rightPad("", '#', tempLine.length()));
            writer.println(tempLine);
            writer.println(StringUtils.rightPad("", '#', tempLine.length()));
            writer.println();
            writer.println("Number of identified matching candidates: " + details.getTotalCandidates());
            writer.println();
            int counter = 1;
            for (Matching<ReferenceSpeciesData, ReferenceSpeciesData> matching : details.getSortedUniqueMatchings()) {
                tempLine = "Matching candidate #" + counter++ + " [ Weighted score: " + matching.getScore() + " ]";
                writer.println(StringUtils.rightPad("", '=', tempLine.length()));
                writer.println(tempLine);
                writer.println(StringUtils.rightPad("", '=', tempLine.length()));
                writer.println();
                writer.println("Data source: " + matching.getTargetProviderId() + " - ID: " + matching.getTargetId());
                writer.println("Target data (as XML): ");
                writer.println();
                writer.println(JAXBUtils.toXML(new Class[]{ReferenceSpeciesData.class}, (ReferenceSpeciesData)matching.getTarget(), JAXBUtils.OMIT_XML_DECLARATION));
                writer.println();
                tempLine = "Triggered macthlets for this candidate: " + matching.getMatchingResults().size();
                writer.println(StringUtils.rightPad("", '-', tempLine.length()));
                writer.println(tempLine);
                int matchletCounter = 1;
                for (MatchingResult<?, ?> matchingResult : matching.getMatchingResults()) {
                    writer.println(StringUtils.rightPad("", '-', tempLine.length()));
                    writer.println("Macthlet #" + matchletCounter++ + " [ " + matchingResult.getOriginatingMatchletName() + " ]");
                    writer.println("Macthlet weight: " + matchingResult.getOriginatingMatchletWeight());
                    writer.println("Macthlet score : " + matchingResult.getMatchletScoreValue() + " [ " + matchingResult.getMatchletScoreType() + " ]");
                    writer.println();
                }
            }
        }
        if (!toStdout) {
            writer.flush();
            writer.close();
            LOG.info("{} : Matching results have been stored in {}", (Object)LOG_EXECUTION, (Object)outputFile.getAbsolutePath());
        } else {
            LOG.info("{} : ############## OUTPUT DUMP - END", (Object)LOG_EXECUTION);
        }
    }

    private void xmlResultsHandler(MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> result, String outFile, String XSLTemplate, String XSLTFile) throws Throwable {
        PrintStream printStream;
        File outputFile;
        long start = System.currentTimeMillis();
        LOG.info("{} : Converting matching results XML into chosen format...", (Object)LOG_EXECUTION);
        boolean toStdout = outFile == null;
        File file = outputFile = toStdout ? null : new File(outFile);
        if (toStdout) {
            printStream = System.out;
            LOG.info("{} : ############## OUTPUT DUMP - BEGIN", (Object)LOG_EXECUTION);
        } else {
            printStream = new PrintStream(outputFile, "UTF-8");
        }
        if (XSLTFile == null && XSLTemplate == null) {
            XSLTemplate = "identity";
        }
        XMLOutputTransformer transformer = new XMLOutputTransformer();
        if (XSLTemplate != null) {
            transformer.applyEmbeddedTemplate(result, XSLTemplate, printStream);
        } else {
            transformer.applyExternalTemplate(result, XSLTFile, printStream);
        }
        if (!toStdout) {
            printStream.flush();
            printStream.close();
            LOG.info("{} : Matching results have been stored in {}", (Object)LOG_EXECUTION, (Object)outputFile.getAbsolutePath());
        } else {
            LOG.info("{} : ############## OUTPUT DUMP - END", (Object)LOG_EXECUTION);
        }
        long end = System.currentTimeMillis();
        LOG.info("{} : Matching reults XML has been converted in {} mSec.", (Object)LOG_EXECUTION, (Object)(end - start));
    }

    private void initializeAndLaunch(CommandLine commandLine) throws Throwable {
        int flag;
        Double matchingThreshold;
        boolean enableScientificNameMatchlet = commandLine.hasOption(ENABLE_SCIENTIFIC_NAME_MATCHING);
        boolean waitForUser = commandLine.hasOption(WAIT_USER);
        boolean enableGenusNameMatchlet = commandLine.hasOption(ENABLE_GENUS_NAME_MATCHING);
        boolean enableNormalizedGenusNameMatchlet = commandLine.hasOption(ENABLE_NORMALIZED_GENUS_NAME_MATCHING);
        boolean enableSpeciesNameMatchlet = commandLine.hasOption(ENABLE_SPECIES_NAME_MATCHING);
        boolean enableNormalizedSpeciesNameMatchlet = commandLine.hasOption(ENABLE_NORMALIZED_SPECIES_NAME_MATCHING);
        boolean enableVernacularNameMatchlet = commandLine.hasOption(ENABLE_VERNACULAR_NAME_MATCHING);
        boolean enableFuzzyTaxamatchMatchlet = commandLine.hasOption(ENABLE_FUZZY_TAXAMATCH_MATCHING);
        boolean enableGSAyMatchlet = commandLine.hasOption(ENABLE_GSAY_MATCHING);
        boolean enableAuthorityNameMatchlet = commandLine.hasOption(ENABLE_AUTHORITY_NAME_MATCHING);
        boolean enableAuthorityYearMatchlet = commandLine.hasOption(ENABLE_AUTHORITY_YEAR_MATCHING);
        if (enableVernacularNameMatchlet && (enableScientificNameMatchlet || enableGenusNameMatchlet || enableNormalizedGenusNameMatchlet || enableSpeciesNameMatchlet || enableNormalizedSpeciesNameMatchlet || enableAuthorityNameMatchlet || enableAuthorityYearMatchlet || enableFuzzyTaxamatchMatchlet || enableGSAyMatchlet)) {
            throw new IllegalArgumentException("Language name matchlet cannot be enabled in combination with other matchlets");
        }
        String outputFile = StringUtils.rawTrim(commandLine.getOptionValue(OUTPUT_FILE));
        boolean outputXML = commandLine.hasOption(XML_OUTPUT);
        String XSLTemplate = StringUtils.rawTrim(commandLine.getOptionValue(XSLT_TEMPLATE));
        boolean setsXSLTemplate = XSLTemplate != null;
        String XSLTFile = StringUtils.rawTrim(commandLine.getOptionValue(XSLT_TEMPLATE_FILE));
        boolean setsXSLTFile = XSLTFile != null;
        boolean outputReport = commandLine.hasOption(REPORT_OUTPUT);
        if (!(enableScientificNameMatchlet || enableGenusNameMatchlet || enableNormalizedGenusNameMatchlet || enableSpeciesNameMatchlet || enableNormalizedSpeciesNameMatchlet || enableVernacularNameMatchlet || enableAuthorityNameMatchlet || enableAuthorityYearMatchlet || enableFuzzyTaxamatchMatchlet || enableGSAyMatchlet)) {
            enableScientificNameMatchlet = true;
        }
        if (!outputXML && !outputReport) {
            outputReport = true;
        }
        if (outputXML && outputReport) {
            throw new IllegalArgumentException("Please set only one output format option (either -xml or -report)");
        }
        if (!outputXML && setsXSLTFile) {
            throw new IllegalArgumentException("XSLT file option (xslTemplateFile) can be set only in combination with the XML output option (xml)");
        }
        if (!outputXML && setsXSLTemplate) {
            throw new IllegalArgumentException("XSLT embedded template option (xslTemplate) can be set only in combination with the XML output option (xml)");
        }
        if (setsXSLTemplate && setsXSLTFile) {
            throw new IllegalArgumentException("XSLT embedded template option (xslTemplate) and XSLT external template option (xslTemplateFile) cannot be both set at the same time");
        }
        if (setsXSLTemplate) {
            AssertionUtils.$true(XMLOutputTransformer.hasAValidTemplate(XSLTemplate), "XSLT embedded template can be set to one of the following values only: " + CollectionsUtils.join(XMLOutputTransformer.AVAILABLE_TEMPLATES, ", "), new Object[0]);
        }
        if (setsXSLTFile && !new File(XSLTFile).exists()) {
            throw new IllegalArgumentException("The specified XSLT file (" + XSLTFile + ") does not exist or is not accessible");
        }
        long start = System.currentTimeMillis();
        LOG.info("### YASMEEN - {} v{} : matching process configuration and evaluation tool", (Object)MatchingEngine.class.getSimpleName(), (Object)VERSION);
        Double scientificNameWeight = commandLine.hasOption(SCIENTIFIC_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(SCIENTIFIC_NAME_MATCHING_WEIGHT))) : null;
        Double scientificNameThreshold = commandLine.hasOption(SCIENTIFIC_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(SCIENTIFIC_NAME_MATCHING_THRESHOLD))) : null;
        Double genusNameWeight = commandLine.hasOption(GENUS_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(GENUS_NAME_MATCHING_WEIGHT))) : null;
        Double genusNameThreshold = commandLine.hasOption(GENUS_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(GENUS_NAME_MATCHING_THRESHOLD))) : null;
        Double normalizedGenusNameWeight = commandLine.hasOption(NORMALIZED_GENUS_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(NORMALIZED_GENUS_NAME_MATCHING_WEIGHT))) : null;
        Double normalizedGenusNameThreshold = commandLine.hasOption(NORMALIZED_GENUS_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(NORMALIZED_GENUS_NAME_MATCHING_THRESHOLD))) : null;
        Double speciesNameWeight = commandLine.hasOption(SPECIES_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(SPECIES_NAME_MATCHING_WEIGHT))) : null;
        Double speciesNameThreshold = commandLine.hasOption(SPECIES_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(SPECIES_NAME_MATCHING_THRESHOLD))) : null;
        Double normalizedSpeciesNameWeight = commandLine.hasOption(NORMALIZED_SPECIES_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(NORMALIZED_SPECIES_NAME_MATCHING_WEIGHT))) : null;
        Double normalizedSpeciesNameThreshold = commandLine.hasOption(NORMALIZED_SPECIES_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(NORMALIZED_SPECIES_NAME_MATCHING_THRESHOLD))) : null;
        Double languageNameWeight = commandLine.hasOption(VERNACULAR_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(VERNACULAR_NAME_MATCHING_WEIGHT))) : null;
        Double languageNameThreshold = commandLine.hasOption(VERNACULAR_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(VERNACULAR_NAME_MATCHING_THRESHOLD))) : null;
        Double authorityNameWeight = commandLine.hasOption(AUTHORITY_NAME_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(AUTHORITY_NAME_MATCHING_WEIGHT))) : null;
        Double authorityNameThreshold = commandLine.hasOption(AUTHORITY_NAME_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(AUTHORITY_NAME_MATCHING_THRESHOLD))) : null;
        Double authorityYearWeight = commandLine.hasOption(AUTHORITY_YEAR_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(AUTHORITY_YEAR_MATCHING_WEIGHT))) : null;
        Double authorityYearThreshold = commandLine.hasOption(AUTHORITY_YEAR_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(AUTHORITY_YEAR_MATCHING_THRESHOLD))) : null;
        Double fuzzyTaxamatchWeight = commandLine.hasOption(FUZZY_TAXAMATCH_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(FUZZY_TAXAMATCH_MATCHING_WEIGHT))) : null;
        Double fuzzyTaxamatchThreshold = commandLine.hasOption(FUZZY_TAXAMATCH_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(FUZZY_TAXAMATCH_MATCHING_THRESHOLD))) : null;
        Double gsayWeight = commandLine.hasOption(GSAY_MATCHING_WEIGHT) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(GSAY_MATCHING_WEIGHT))) : null;
        Double gsayThreshold = commandLine.hasOption(GSAY_MATCHING_THRESHOLD) ? Double.valueOf(Double.parseDouble(commandLine.getOptionValue(GSAY_MATCHING_THRESHOLD))) : null;
        String suggestedLanguages = commandLine.hasOption(LANGUAGE_NAME_SUGGESTION) ? commandLine.getOptionValue(LANGUAGE_NAME_SUGGESTION) : null;
        Boolean haltAtFirstMatch = commandLine.hasOption(HALT_AT_FIRST_MATCH);
        boolean partitionByLength = commandLine.hasOption(PARTITION_DATA_BY_LENGTH);
        boolean partitionByInitials = commandLine.hasOption(PARTITION_DATA_BY_INITIALS);
        AssertionUtils.$false(partitionByLength && partitionByInitials, "You can't enable both partitioning by length and partitioning by initials at the same time", new Object[0]);
        boolean setPartitionThreshold = commandLine.hasOption(DATA_PARTITIONING_THRESHOLD);
        if (setPartitionThreshold && !partitionByLength && !partitionByInitials) {
            LOG.warn("{} : No partition strategy specified: using length-based partitioning as default...", (Object)LOG_CONFIGURATION);
            partitionByLength = true;
        }
        if (partitionByLength || partitionByInitials) {
            LOG.info("{} : Enabling {}-based partitioning", (Object)LOG_CONFIGURATION, (Object)(partitionByLength ? "length" : "initials"));
            AssertionUtils.$true(setPartitionThreshold, "Please specify a data partitioning threshold", new Object[0]);
        }
        Integer dataPartitioningThreshold = commandLine.hasOption(DATA_PARTITIONING_THRESHOLD) ? Integer.valueOf(commandLine.getOptionValue(DATA_PARTITIONING_THRESHOLD)) : (partitionByLength ? -1 : 0);
        if (partitionByLength && dataPartitioningThreshold != -1) {
            AssertionUtils.$nNeg(dataPartitioningThreshold, "The data partitioning threshold for length-based partitioning must be non-negative (currently: {})", dataPartitioningThreshold);
        } else if (partitionByInitials) {
            AssertionUtils.$gte(dataPartitioningThreshold, 0, "The data partitioning threshold for initials-based partitioning must be non-negative (currently: {})", dataPartitioningThreshold);
        }
        Integer maxCandidates = commandLine.hasOption(MAX_MATCH_CANDIDATES) ? Integer.valueOf(commandLine.getOptionValue(MAX_MATCH_CANDIDATES)) : new Integer(0);
        Integer numParallelThreads = 1;
        if (commandLine.hasOption(PARALLEL_THREADS)) {
            String pt = commandLine.getOptionValue(PARALLEL_THREADS);
            try {
                boolean relative = Pattern.matches("\\d*\\.?\\d+x", pt);
                numParallelThreads = relative ? Integer.valueOf(new Long(Math.round((double)Runtime.getRuntime().availableProcessors() * Double.parseDouble(pt.replace("x", "")))).intValue()) : Integer.valueOf(Integer.parseInt(pt));
                LOG.info("{} : Using {} as actual number of threads according to -{} {} and available number of cores / processors ({})", new Object[]{LOG_CONFIGURATION, numParallelThreads, PARALLEL_THREADS, pt, Runtime.getRuntime().availableProcessors()});
            }
            catch (NumberFormatException NFe) {
                throw new RuntimeException("Invalid number of parallel thread: " + pt);
            }
        }
        String lexicalWeights = "70:30:0";
        if (commandLine.hasOption(LEXICAL_ALGORITHMS_WEIGHT)) {
            lexicalWeights = commandLine.getOptionValue(LEXICAL_ALGORITHMS_WEIGHT);
            AssertionUtils.$true(Pattern.matches("\\d+\\:\\d+\\:\\d+", lexicalWeights), "Invalid lexical algorithms weights {}", lexicalWeights);
        }
        if (scientificNameWeight != null || scientificNameThreshold != null) {
            AssertionUtils.$true(enableScientificNameMatchlet, "You cannot set the scientific name weight or scientific name matching threshold without enabling the scientific name matching", new Object[0]);
        }
        if (scientificNameThreshold != null) {
            AssertionUtils.$gt(scientificNameThreshold, 0.0, "The scientific name threshold must be higher than 0.0 (currently: {})", scientificNameThreshold);
            AssertionUtils.$lte(scientificNameThreshold, 1.0, "The scientific name threshold must be lower than (or equal to) 1.0 (currently: {})", scientificNameThreshold);
        }
        if (scientificNameWeight != null) {
            AssertionUtils.$pos(scientificNameWeight, "The scientific name weight must be higher than 0.0 (currently: {})", scientificNameWeight);
        }
        if (genusNameWeight != null || genusNameThreshold != null) {
            AssertionUtils.$true(enableGenusNameMatchlet, "You cannot set the genus name weight or genus name matching threshold without enabling the genus name matching", new Object[0]);
        }
        if (genusNameThreshold != null) {
            AssertionUtils.$gt(genusNameThreshold, 0.0, "The genus name threshold must be higher than 0.0 (currently: {})", genusNameThreshold);
            AssertionUtils.$lte(genusNameThreshold, 1.0, "The genus name threshold must be lower than (or equal to) 1.0 (currently: {})", genusNameThreshold);
        }
        if (genusNameWeight != null) {
            AssertionUtils.$pos(genusNameWeight, "The genus name weight must be higher than 0.0 (currently: {})", genusNameWeight);
        }
        if (speciesNameWeight != null || speciesNameThreshold != null) {
            AssertionUtils.$true(enableSpeciesNameMatchlet, "You cannot set the species name weight or species name matching threshold without enabling the species name matching", new Object[0]);
        }
        if (speciesNameThreshold != null) {
            AssertionUtils.$gt(speciesNameThreshold, 0.0, "The species name threshold must be higher than 0.0 (currently: {})", speciesNameThreshold);
            AssertionUtils.$lte(speciesNameThreshold, 1.0, "The species name threshold must be lower than (or equal to) 1.0 (currently: {})", speciesNameThreshold);
        }
        if (speciesNameWeight != null) {
            AssertionUtils.$pos(speciesNameWeight, "The species name weight must be higher than 0.0 (currently: {})", speciesNameWeight);
        }
        if (normalizedGenusNameWeight != null || normalizedGenusNameThreshold != null) {
            AssertionUtils.$true(enableNormalizedGenusNameMatchlet, "You cannot set the normalized genus name weight or normalized genus name matching threshold without enabling the normalized genus name matching", new Object[0]);
        }
        if (normalizedGenusNameThreshold != null) {
            AssertionUtils.$gt(normalizedGenusNameThreshold, 0.0, "The normalized genus name threshold must be higher than 0.0 (currently: {})", normalizedGenusNameThreshold);
            AssertionUtils.$lte(normalizedGenusNameThreshold, 1.0, "The normalized genus name threshold must be lower than (or equal to) 1.0 (currently: {})", normalizedGenusNameThreshold);
        }
        if (normalizedGenusNameWeight != null) {
            AssertionUtils.$pos(normalizedGenusNameWeight, "The normalized genus name weight must be higher than 0.0 (currently: {})", normalizedGenusNameWeight);
        }
        if (normalizedSpeciesNameWeight != null || normalizedSpeciesNameThreshold != null) {
            AssertionUtils.$true(enableNormalizedSpeciesNameMatchlet, "You cannot set the normalized species name weight or normalized species name matching threshold without enabling the normalized species name matching", new Object[0]);
        }
        if (normalizedSpeciesNameThreshold != null) {
            AssertionUtils.$gt(normalizedSpeciesNameThreshold, 0.0, "The normalized species name threshold must be higher than 0.0 (currently: {})", normalizedSpeciesNameThreshold);
            AssertionUtils.$lte(normalizedSpeciesNameThreshold, 1.0, "The normalized species name threshold must be lower than (or equal to) 1.0 (currently: {})", normalizedSpeciesNameThreshold);
        }
        if (normalizedSpeciesNameWeight != null) {
            AssertionUtils.$pos(normalizedSpeciesNameWeight, "The normalized species name weight must be higher than 0.0 (currently: {})", normalizedSpeciesNameWeight);
        }
        if (authorityNameWeight != null || authorityNameThreshold != null) {
            AssertionUtils.$true(enableAuthorityNameMatchlet, "You cannot set the authority name weight or authority name matching threshold without enabling the authority name matching", new Object[0]);
        }
        if (authorityNameThreshold != null) {
            AssertionUtils.$gt(authorityNameThreshold, 0.0, "The authority name threshold must be higher than 0.0 (currently: {})", authorityNameThreshold);
            AssertionUtils.$lte(authorityNameThreshold, 1.0, "The authority name threshold must be lower than (or equal to) 1.0 (currently: {})", authorityNameThreshold);
        }
        if (authorityNameWeight != null) {
            AssertionUtils.$pos(authorityNameWeight, "The authority name weight must be higher than 0.0 (currently: {})", authorityNameWeight);
        }
        if (authorityYearWeight != null || authorityYearThreshold != null) {
            AssertionUtils.$true(enableAuthorityYearMatchlet, "You cannot set the authority year weight or authority year matching threshold without enabling the authority year matching", new Object[0]);
        }
        if (authorityYearThreshold != null) {
            AssertionUtils.$gt(authorityYearThreshold, 0.0, "The authority year threshold must be higher than 0.0 (currently: {})", authorityYearThreshold);
            AssertionUtils.$lte(authorityYearThreshold, 1.0, "The authority year threshold must be lower than (or equal to) 1.0 (currently: {})", authorityYearThreshold);
        }
        if (authorityYearWeight != null) {
            AssertionUtils.$pos(authorityYearWeight, "The authority year weight must be higher than 0.0 (currently: {})", authorityYearWeight);
        }
        if (languageNameWeight != null || languageNameThreshold != null) {
            AssertionUtils.$true(enableVernacularNameMatchlet, "You cannot set the language name weight or language name matching threshold without enabling the language name matching", new Object[0]);
        }
        if (languageNameThreshold != null) {
            AssertionUtils.$gt(languageNameThreshold, 0.0, "The language name threshold must be higher than 0.0 (currently: {})", languageNameThreshold);
            AssertionUtils.$lte(languageNameThreshold, 1.0, "The language name threshold must be lower than (or equal to) 1.0 (currently: {})", languageNameThreshold);
        }
        if (languageNameWeight != null) {
            AssertionUtils.$pos(languageNameWeight, "The language name weight must be higher than 0.0 (currently: {})", languageNameWeight);
        }
        if (suggestedLanguages != null) {
            AssertionUtils.$true(enableVernacularNameMatchlet, "You cannot set the suggested language without enabling the language name matching", new Object[0]);
            String[] stringArray = suggestedLanguages.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String language = stringArray[n2];
                language = StringUtils.rawTrim(language);
                ++n2;
            }
        }
        if (fuzzyTaxamatchWeight != null || fuzzyTaxamatchThreshold != null) {
            AssertionUtils.$true(enableFuzzyTaxamatchMatchlet, "You cannot set the FuzzyTaxamatch weight or FuzzyTaxamatch matching threshold without enabling the FuzzyTaxamatch matching", new Object[0]);
        }
        if (fuzzyTaxamatchThreshold != null) {
            AssertionUtils.$gt(fuzzyTaxamatchThreshold, 0.0, "The FuzzyTaxamatch threshold must be higher than 0.0 (currently: {})", fuzzyTaxamatchThreshold);
            AssertionUtils.$lte(fuzzyTaxamatchThreshold, 1.0, "The FuzzyTaxamatch threshold must be lower than (or equal to) 1.0 (currently: {})", fuzzyTaxamatchThreshold);
        }
        if (fuzzyTaxamatchWeight != null) {
            AssertionUtils.$pos(fuzzyTaxamatchWeight, "The GSAy weight must be higher than 0.0 (currently: {})", fuzzyTaxamatchWeight);
        }
        if (gsayWeight != null || gsayThreshold != null) {
            AssertionUtils.$true(enableGSAyMatchlet, "You cannot set the GSAy weight or GSAy matching threshold without enabling the GSAy matching", new Object[0]);
        }
        if (gsayThreshold != null) {
            AssertionUtils.$gt(gsayThreshold, 0.0, "The GSAy threshold must be higher than 0.0 (currently: {})", gsayThreshold);
            AssertionUtils.$lte(gsayThreshold, 1.0, "The GSAy threshold must be lower than (or equal to) 1.0 (currently: {})", gsayThreshold);
        }
        double levenshteinWeight = 70.0;
        double soundexWeight = 30.0;
        double trigramWeight = 0.0;
        if (lexicalWeights != null) {
            Pattern extractor = Pattern.compile("^(\\d+)\\:(\\d+)\\:(\\d+)$");
            Matcher matcher = extractor.matcher(lexicalWeights);
            if (matcher.matches()) {
                levenshteinWeight = Double.parseDouble(matcher.group(1));
                soundexWeight = Double.parseDouble(matcher.group(2));
                trigramWeight = Double.parseDouble(matcher.group(3));
            }
            AssertionUtils.$gte(levenshteinWeight, 0.0, "The Levenshtein weight must be greater than (or equal to) 0 (currently: {})", levenshteinWeight);
            AssertionUtils.$lte(levenshteinWeight, 100.0, "The Levenshtein weight must be lower than (or equal to) 100 (currently: {})", levenshteinWeight);
            AssertionUtils.$gte(soundexWeight, 0.0, "The soundex weight must be greater than (or equal to) 0 (currently: {})", soundexWeight);
            AssertionUtils.$lte(soundexWeight, 100.0, "The soundex weight must be lower than (or equal to) 100 (currently: {})", soundexWeight);
            AssertionUtils.$gte(trigramWeight, 0.0, "The trigram weight must be greater than (or equal to) 0 (currently: {})", trigramWeight);
            AssertionUtils.$lte(trigramWeight, 100.0, "The trigram weight must be lower than (or equal to) 100 (currently: {})", trigramWeight);
        }
        if (maxCandidates != null) {
            AssertionUtils.$true(maxCandidates >= 0, "The max number of candidates must be higher than or equal to 0 (currently {})", maxCandidates);
        }
        if ((matchingThreshold = Double.valueOf(commandLine.hasOption(MIN_SCORE_THRESHOLD) ? Double.parseDouble(commandLine.getOptionValue(MIN_SCORE_THRESHOLD)) : new Double(0.5))) != null) {
            AssertionUtils.$gt(matchingThreshold, 0.0, "The matching results threshold must be higher than 0.0 (currently: {})", matchingThreshold);
            AssertionUtils.$lte(matchingThreshold, 1.0, "The matching results threshold must be lower than (or equal to) 1.0 (currently: {})", matchingThreshold);
        }
        if (enableScientificNameMatchlet) {
            scientificNameThreshold = ObjectsUtils.coalesce(scientificNameThreshold, new Double(0.5));
            scientificNameWeight = ObjectsUtils.coalesce(scientificNameWeight, new Double(200.0));
        }
        if (enableGenusNameMatchlet) {
            genusNameThreshold = ObjectsUtils.coalesce(genusNameThreshold, new Double(0.7));
            genusNameWeight = ObjectsUtils.coalesce(genusNameWeight, new Double(50.0));
        }
        if (enableNormalizedGenusNameMatchlet) {
            normalizedGenusNameThreshold = ObjectsUtils.coalesce(normalizedGenusNameThreshold, new Double(0.7));
            normalizedGenusNameWeight = ObjectsUtils.coalesce(normalizedGenusNameWeight, new Double(50.0));
        }
        if (enableSpeciesNameMatchlet) {
            speciesNameThreshold = ObjectsUtils.coalesce(speciesNameThreshold, new Double(0.4));
            speciesNameWeight = ObjectsUtils.coalesce(speciesNameWeight, new Double(50.0));
        }
        if (enableNormalizedSpeciesNameMatchlet) {
            normalizedSpeciesNameThreshold = ObjectsUtils.coalesce(normalizedSpeciesNameThreshold, new Double(0.4));
            normalizedSpeciesNameWeight = ObjectsUtils.coalesce(normalizedSpeciesNameWeight, new Double(50.0));
        }
        if (enableAuthorityNameMatchlet) {
            authorityNameThreshold = ObjectsUtils.coalesce(authorityNameThreshold, new Double(0.6));
            authorityNameWeight = ObjectsUtils.coalesce(authorityNameWeight, new Double(70.0));
        }
        if (enableAuthorityYearMatchlet) {
            authorityYearThreshold = ObjectsUtils.coalesce(authorityYearThreshold, new Double(0.5));
            authorityYearWeight = ObjectsUtils.coalesce(authorityYearWeight, new Double(40.0));
        }
        if (enableVernacularNameMatchlet) {
            languageNameThreshold = ObjectsUtils.coalesce(languageNameThreshold, new Double(0.6));
            languageNameWeight = ObjectsUtils.coalesce(languageNameWeight, new Double(100.0));
        }
        if (enableFuzzyTaxamatchMatchlet) {
            fuzzyTaxamatchThreshold = ObjectsUtils.coalesce(fuzzyTaxamatchThreshold, new Double(0.5));
            fuzzyTaxamatchWeight = ObjectsUtils.coalesce(fuzzyTaxamatchWeight, new Double(50.0));
        }
        if (enableGSAyMatchlet) {
            gsayThreshold = ObjectsUtils.coalesce(gsayThreshold, new Double(0.5));
            gsayWeight = ObjectsUtils.coalesce(gsayWeight, new Double(50.0));
        }
        AssertionUtils.$false(maxCandidates > 1 && haltAtFirstMatch != false, "You cannot set the maximum number of candidates to a value higher than 1 (currently: {}) and enable the 'halt at first valid matching' flag (-{})", maxCandidates, HALT_AT_FIRST_MATCH);
        if (haltAtFirstMatch.booleanValue()) {
            maxCandidates = 1;
        }
        AssertionUtils.$pos(numParallelThreads, "The maximum number of threads must be greater than zero (currently: {})", numParallelThreads);
        AssertionUtils.$lte(numParallelThreads, 64, "The maximum number of threads must be lower than (or equal to) {} (currently: {})", 64, numParallelThreads);
        String inputFile = StringUtils.rawTrim(commandLine.getOptionValue(INPUT_FILE));
        AssertionUtils.$nNull(inputFile, "Please provide a valid input file", new Object[0]);
        File input = new File(inputFile);
        AssertionUtils.$true(input.exists(), "Unable to find specified input file: {}", input.getAbsolutePath());
        Boolean dontSkipHeader = Boolean.valueOf(commandLine.getOptionValue(DONT_SKIP_HEADER));
        this.SPECIES_SIMPLIFIER = LexicalProcessorsUtils.getProcessor(SpeciesSimplifier.class);
        this.AUTHORITIES_SIMPLIFIER = LexicalProcessorsUtils.getProcessor(AuthoritiesSimplifier.class);
        this.SPECIES_NORMALIZER = LexicalProcessorsUtils.getProcessor(SpeciesNormalizer.class);
        ReferenceSpeciesData[] inputData = this.PARSED_INPUT_DATA_READER.readData(input, dontSkipHeader == false, this.SPECIES_SIMPLIFIER, this.SPECIES_NORMALIZER, this.AUTHORITIES_SIMPLIFIER, this.AUTHORITIES_NORMALIZER, this.PHRASE_SOUNDEXER, this.SOUNDEXER);
        AssertionUtils.$true(inputData.length > 0, "User provided data resolve to an empty input data set", new Object[0]);
        ArrayList<MatchletSkeleton> matchlets = new ArrayList<MatchletSkeleton>();
        MatchletSkeleton m = null;
        int taxaFlags = 0;
        taxaFlags |= 0x100;
        taxaFlags |= 0x40;
        taxaFlags |= 0x80;
        taxaFlags |= 0x800;
        if (enableScientificNameMatchlet) {
            m = new ScientificCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(scientificNameWeight).setMinimumAllowedScore(scientificNameThreshold).setOptional(false);
            matchlets.add(m);
        }
        if (enableGenusNameMatchlet) {
            m = new GenusCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(genusNameWeight).setMinimumAllowedScore(genusNameThreshold).setOptional(false);
            matchlets.add(m);
        }
        if (enableNormalizedGenusNameMatchlet) {
            m = new NormalizedGenusCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(normalizedGenusNameWeight).setMinimumAllowedScore(normalizedGenusNameThreshold).setOptional(false);
            matchlets.add(m);
            taxaFlags |= 0x200;
        }
        if (enableSpeciesNameMatchlet) {
            m = new SpeciesCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(speciesNameWeight).setMinimumAllowedScore(speciesNameThreshold).setOptional(false);
            matchlets.add(m);
        }
        if (enableNormalizedSpeciesNameMatchlet) {
            m = new NormalizedSpeciesCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(normalizedSpeciesNameWeight).setMinimumAllowedScore(normalizedSpeciesNameThreshold).setOptional(false);
            matchlets.add(m);
            taxaFlags |= 0x400;
        }
        if (enableAuthorityNameMatchlet) {
            m = new AuthorityCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight);
            m.setWeight(authorityNameWeight).setMinimumAllowedScore(authorityNameThreshold).setOptional(true);
            matchlets.add(m);
            taxaFlags |= 0x1000;
        }
        if (enableAuthorityYearMatchlet) {
            m = new AuthorityYearMatchlet();
            m.setWeight(authorityYearWeight).setMinimumAllowedScore(authorityYearThreshold).setOptional(true);
            matchlets.add(m);
            taxaFlags |= 0x2000;
        }
        if (enableVernacularNameMatchlet) {
            m = new VernacularCNameMatchlet(levenshteinWeight, soundexWeight, trigramWeight, suggestedLanguages == null ? null : suggestedLanguages, Boolean.TRUE);
            m.setWeight(languageNameWeight).setMinimumAllowedScore(languageNameThreshold).setOptional(false);
            matchlets.add(m);
        }
        if (enableFuzzyTaxamatchMatchlet) {
            m = new FuzzyTaxamatchMatchlet();
            m.setWeight(fuzzyTaxamatchWeight).setMinimumAllowedScore(fuzzyTaxamatchThreshold).setOptional(false);
            matchlets.add(m);
            taxaFlags |= 0x200;
            taxaFlags |= 0x400;
        }
        if (enableGSAyMatchlet) {
            m = new GSAyMatchlet();
            m.setWeight(gsayWeight).setMinimumAllowedScore(gsayThreshold).setOptional(false);
            matchlets.add(m);
            taxaFlags |= 0x400;
            taxaFlags |= 0x2000;
        }
        if (matchlets.size() == 1) {
            Matchlet matchlet = (Matchlet)matchlets.get(0);
            Double processThreshold = (double)matchingThreshold;
            Double matchletThreshold = matchlet.getMinimumScore();
            Double d = matchletThreshold = matchletThreshold == null ? processThreshold : matchletThreshold;
            if (Double.compare(processThreshold, matchletThreshold) != 0) {
                LOG.warn("{} : Minimum score threshold and (single) matchlet minimum score do differ ({} and {} respectively): equalizing their value to {}", new Object[]{LOG_CONFIGURATION, matchingThreshold, matchletThreshold, Math.min(processThreshold, matchletThreshold)});
                matchingThreshold = Math.min(matchingThreshold, matchletThreshold);
                matchlet.setMinimumAllowedScore(matchingThreshold);
            }
        }
        UMatchingEngineCore engine = new UMatchingEngineCore(numParallelThreads);
        MatchingEngineProcessConfiguration configuration = new MatchingEngineProcessConfiguration();
        configuration.setMinimumAllowedWeightedScore(matchingThreshold);
        configuration.setMaxCandidatesPerEntry(maxCandidates);
        configuration.setHaltAtFirstValidMatching(haltAtFirstMatch);
        String[] specifiedTargets = commandLine.hasOption(REFERENCE_DATA) ? commandLine.getOptionValues(REFERENCE_DATA) : null;
        AssertionUtils.$nNull(specifiedTargets, "Please specify at least one reference data (target) with the -{} option", REFERENCE_DATA);
        Pattern refDataPattern = Pattern.compile("^[^@]+@([a-zA-Z]+://.+)(,[a-zA-Z]+://.)?$");
        ListSet<Pair<?, ?>[]> allReferences = new ListSet<Pair<?, ?>[]>();
        String CD = new File("").getAbsolutePath();
        String BASE_PATH = "org/fao/fi/comet/domain/species/data/resources";
        String[] stringArray = specifiedTargets;
        int n = specifiedTargets.length;
        int n3 = 0;
        while (n3 < n) {
            String target = stringArray[n3];
            AssertionUtils.$true(refDataPattern.matcher(target).matches(), "Wrong {} specification: {}. {} must be in the form <REF_ID>@<protocol>://<Taxa data URI>(,<protocol>://<Vernacular names URI>", REFERENCE_DATA, target, REFERENCE_DATA);
            String providerID = target.replaceAll("^([^@]+)@.+", "$1");
            String actualURLs = target.replaceAll("^([^@]+)@(.+)", "$2");
            String[] actualURLsComponents = actualURLs.split("\\,", -1);
            AssertionUtils.$true(actualURLsComponents.length <= 2, "Wrong {} specification: {}. {} must be in the form <REF_ID>@<protocol>://<Taxa data URI>(,<protocol>://<Vernacular names URI>", REFERENCE_DATA, target, REFERENCE_DATA);
            BasicPair[] currentReferences = new BasicPair[2];
            currentReferences[0] = this.extractURL(actualURLsComponents[0], CD, "org/fao/fi/comet/domain/species/data/resources", providerID);
            if (actualURLsComponents.length == 2) {
                currentReferences[1] = this.extractURL(actualURLsComponents[1], CD, "org/fao/fi/comet/domain/species/data/resources", providerID);
            }
            if (currentReferences[0] == null) {
                LOG.warn("{} : Missing or invalid URL for {} taxa reference data file. This reference data set will not be available", (Object)LOG_EXECUTION, (Object)providerID);
            } else {
                if (currentReferences[1] == null) {
                    LOG.warn("{} : Missing or invalid URL for {} vernacular reference data file. Vernacular names will not be available for this reference data set", (Object)LOG_CONFIGURATION, (Object)providerID);
                }
                allReferences.add(currentReferences);
            }
            ++n3;
        }
        double wTot = levenshteinWeight + soundexWeight + trigramWeight;
        double wLev = (double)Math.round(levenshteinWeight / wTot * 10000.0) * 0.01;
        double wSnd = (double)Math.round(soundexWeight / wTot * 10000.0) * 0.01;
        double wTri = (double)Math.round(trigramWeight / wTot * 10000.0) * 0.01;
        AssertionUtils.$true(levenshteinWeight + soundexWeight + trigramWeight > 0.0, "Please specify at least one non-zero weight for the lexical algorithms with the -{} option", LEXICAL_ALGORITHMS_WEIGHT);
        LOG.info("{} : Using {} as LEV:SNDX:TRIG lexical algorithm weights, resolving to the following composition of weighted lexical score values: ", (Object)LOG_CONFIGURATION, (Object)lexicalWeights);
        LOG.info("{} : [ Levenshtein: {}% | Soundex: {}% | Trigram: {}% ]", new Object[]{LOG_CONFIGURATION, wLev, wSnd, wTri});
        LOG.info("{} : Currently configured matchlets: {}", (Object)LOG_CONFIGURATION, (Object)matchlets.size());
        for (Matchlet matchlet : matchlets) {
            LOG.info("{} : - [ {} - Weight: {} - Score threshold: {} - Optional: {} ]", new Object[]{LOG_CONFIGURATION, matchlet.getName(), matchlet.getWeight(), matchlet.getMinimumScore(), matchlet.isOptional()});
        }
        boolean bl = Double.compare(wLev, 0.0) > 0;
        boolean includeSoundex = Double.compare(wSnd, 0.0) > 0;
        boolean includeTrigrams = Double.compare(wTri, 0.0) > 0;
        int lexicalFlags = 0;
        if (bl) {
            lexicalFlags |= 2;
        }
        if (includeSoundex) {
            lexicalFlags |= 4;
        }
        if (includeTrigrams) {
            lexicalFlags |= 8;
        }
        Object[][] TAXA_MASKS = new Object[][]{{"Kingdom", 2}, {"Phylum", 4}, {"Class", 8}, {"Order", 16}, {"Faimily", 32}, {"Genus", 64}, {"Species", 128}, {"Scientific name", 256}, {"Normalized genus", 512}, {"Normalized species", 1024}, {"Author", 2048}, {"Authorities", 4096}, {"Authority year", 8192}};
        LOG.info("{} : List of attributes that will be retrieved from the dataset (according to currently set matchers):", (Object)LOG_CONFIGURATION);
        Object[][] objectArrayArray = TAXA_MASKS;
        int n4 = TAXA_MASKS.length;
        int n5 = 0;
        while (n5 < n4) {
            Object[] mask = objectArrayArray[n5];
            boolean retrieve = taxaFlags == 0;
            flag = (Integer)mask[1];
            if (!retrieve) {
                boolean bl2 = retrieve = (flag & taxaFlags) == flag;
            }
            if (retrieve) {
                LOG.info("{} : - [ {} ]", (Object)LOG_CONFIGURATION, mask[0]);
            }
            ++n5;
        }
        Object[][] LEXICAL_MASKS = new Object[][]{{"Simplified name", 2}, {"Simplified name soundex", 4}, {"Simplified name trigrams", 8}};
        LOG.info("{} : List of lexical indexes that will be retrieved from the dataset (according to currently set lexical algorithm weights):", (Object)LOG_CONFIGURATION);
        Object[][] objectArrayArray2 = LEXICAL_MASKS;
        int n6 = LEXICAL_MASKS.length;
        int n7 = 0;
        while (n7 < n6) {
            Object[] mask = objectArrayArray2[n7];
            boolean include = lexicalFlags == 0;
            flag = (Integer)mask[1];
            if (!include) {
                boolean bl3 = include = (flag & lexicalFlags) == flag;
            }
            if (include) {
                LOG.info("{} : - [ {} ]", (Object)LOG_CONFIGURATION, mask[0]);
            }
            ++n7;
        }
        SizeAwareDataProvider<ReferenceSpeciesData> sources = this.getSourceDataProvider(inputData);
        SizeAwareDataProvider<ReferenceSpeciesData> targets = this.getTargetDataProvider(commandLine.hasOption(VERBOSE), commandLine.hasOption(MATERIALIZE_TARGETS), lexicalFlags, taxaFlags, 0, allReferences);
        if (waitForUser) {
            LOG.info("Press ENTER to continue...");
            System.in.read();
        }
        String banner = "Starting matching process for " + inputData.length + " user-provided entries...";
        LOG.info("{} : {}", (Object)LOG_EXECUTION, (Object)StringUtils.pad("", '=', banner.length(), true));
        LOG.info("{} : {}", (Object)LOG_EXECUTION, (Object)banner);
        LOG.info("{} : {}", (Object)LOG_EXECUTION, (Object)StringUtils.pad("", '=', banner.length(), true));
        ArrayList<MatchletConfiguration> matchletsConfiguration = new ArrayList<MatchletConfiguration>();
        for (Matchlet matchlet : matchlets) {
            MatchletConfiguration mConfiguration = new MatchletConfiguration();
            mConfiguration.setMatchletId(matchlet.getName());
            mConfiguration.setMatchletName(matchlet.getName());
            mConfiguration.setMatchletType(matchlet.getType());
            mConfiguration.setMatchletParameters(matchlet.getConfiguration());
            matchletsConfiguration.add(mConfiguration);
        }
        configuration.setMatchletsConfiguration(matchletsConfiguration);
        Object var100_108 = null;
        InputSpeciesIDHandler sourceIDHandler = new InputSpeciesIDHandler();
        TargetSpeciesIDHandler targetIDHandler = new TargetSpeciesIDHandler();
        long startTime = System.currentTimeMillis();
        SilentMatchingProcessHandler tracker = new SilentMatchingProcessHandler();
        MatchingEngineProcessResult<ReferenceSpeciesData, ReferenceSpeciesData, MatchingEngineProcessConfiguration> matchingEngineProcessResult = engine.compareAll(configuration, tracker, sources, setPartitionThreshold ? (partitionByLength ? new LengthBasedSpeciesDataPartitioner(dataPartitioningThreshold) : new InitialsBasedSpeciesDataPartitioner(dataPartitioningThreshold)) : new IdentityDataPartitioner(), targets, sourceIDHandler, targetIDHandler);
        long endTime = System.currentTimeMillis();
        long elapsed = endTime - startTime;
        LOG.info("{} : ", (Object)LOG_EXECUTION);
        LOG.info("{} : Matching process completed in {} mSec.", (Object)LOG_EXECUTION, (Object)elapsed);
        LOG.info("{} : ", (Object)LOG_EXECUTION);
        LOG.info("{} : Number of threads: {}", (Object)LOG_EXECUTION, (Object)numParallelThreads);
        int totalAtomicComparisons = tracker.getTotalNumberOfAtomicComparisonsPerformed();
        int skippedAtomicComparisons = tracker.getNumberOfAtomicComparisonsSkipped();
        int effectiveAtomicComparisons = totalAtomicComparisons - skippedAtomicComparisons;
        double atomicThroughput = 1.0 * (double)totalAtomicComparisons * 1000.0 / (double)elapsed;
        double effectiveAtomicThroughput = 1.0 * (double)effectiveAtomicComparisons * 1000.0 / (double)elapsed;
        double throughput = 1.0 * (double)sources.getAvailableDataSize() * 1000.0 / (double)elapsed;
        LOG.info("{} : Max. number of atomic comparisons : {}", (Object)LOG_EXECUTION, (Object)totalAtomicComparisons);
        LOG.info("{} : Number of effective atomic comparisons: {}", (Object)LOG_EXECUTION, (Object)effectiveAtomicComparisons);
        LOG.info("{} : Number of skipped atomic comparisons: {}", (Object)LOG_EXECUTION, (Object)skippedAtomicComparisons);
        LOG.info("{} : ", (Object)LOG_EXECUTION);
        LOG.info("{} : Effective atomic comparisons throughput: {} comparisons / second", (Object)LOG_EXECUTION, (Object)effectiveAtomicThroughput);
        LOG.info("{} : Estimated atomic comparisons throughput: {} comparisons / second", (Object)LOG_EXECUTION, (Object)atomicThroughput);
        LOG.info("{} : Comparison throughput: {} source data comparison rounds / second", (Object)LOG_EXECUTION, (Object)throughput);
        startTime = System.currentTimeMillis();
        LOG.info("{} : ", (Object)LOG_EXECUTION);
        matchingEngineProcessResult.setResults(matchingEngineProcessResult.getResults().filter(matchingThreshold, maxCandidates == null ? 0 : maxCandidates));
        endTime = System.currentTimeMillis();
        LOG.info("{} : Done. Joined results have been filtered in {} mSec.", (Object)LOG_EXECUTION, (Object)(endTime - startTime));
        LOG.info("{} : ", (Object)LOG_EXECUTION);
        if (outputXML) {
            this.xmlResultsHandler(matchingEngineProcessResult, outputFile, XSLTemplate, XSLTFile);
        } else {
            this.reportResultsHandler(matchingEngineProcessResult, outputFile);
        }
        long end = System.currentTimeMillis();
        LOG.info("{} : Overall execution time (mSec.) {}", (Object)LOG_EXECUTION, (Object)(end - start));
        LOG.info("{} : Process execution time (mSec.) {}", (Object)LOG_EXECUTION, (Object)elapsed);
        LOG.info("{} : Overhead               (mSec.) {}", (Object)LOG_EXECUTION, (Object)(end - start - elapsed));
    }

    private void execute(String[] args) throws Throwable {
        this.route(this.buildCommandLine(args));
    }

    public static void main(String[] args) throws Throwable {
        try {
            new MatchingEngine().execute(args);
            System.exit(0);
        }
        catch (IllegalArgumentException IAe) {
            LOG.error("{}: [ configuration error ] : {}", (Object)MatchingEngine.class.getSimpleName(), (Object)IAe.getMessage());
        }
        catch (Throwable t) {
            LOG.error("{}: [ unexpected error ] : {}", (Object)MatchingEngine.class.getSimpleName(), (Object)t.getMessage());
        }
        System.exit(-1);
    }
}

