/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;

public class AssertionUtils
extends AbstractHelperSingleton {
    private static boolean ASSERTS_ARE_ENABLED = false;

    static {
        try {
            assert (false) : "Asserts are enabled";
        }
        catch (AssertionError Ae) {
            ASSERTS_ARE_ENABLED = true;
        }
    }

    private AssertionUtils() {
    }

    public static void $true(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(condition, IllegalArgumentException.class, messageTemplate, params);
    }

    public static void $false(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_nAssert(condition, IllegalArgumentException.class, messageTemplate, params);
    }

    public static void $nNull(Object nonNullable, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(nonNullable != null, messageTemplate, params);
    }

    public static void $em(Map<?, ?> map, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(map != null && map.isEmpty(), messageTemplate, params);
    }

    public static void $em(Collection<?> collection, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(collection != null && collection.isEmpty(), messageTemplate, params);
    }

    public static void $em(Object[] array, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(array != null && array.length == 0, messageTemplate, params);
    }

    public static void $em(CharSequence sequence, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(sequence != null && sequence.length() == 0, messageTemplate, params);
    }

    public static void $emn(Map<?, ?> map, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(map == null || map.isEmpty(), messageTemplate, params);
    }

    public static void $emn(Collection<?> collection, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(collection == null || collection.isEmpty(), messageTemplate, params);
    }

    public static void $emn(Object[] array, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(array == null || array.length == 0, messageTemplate, params);
    }

    public static void $emn(CharSequence sequence, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(sequence == null || sequence.length() > 0, messageTemplate, params);
    }

    public static void $nEm(Map<?, ?> map, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(map != null && !map.isEmpty(), messageTemplate, params);
    }

    public static void $nEm(Collection<?> collection, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(collection != null && !collection.isEmpty(), messageTemplate, params);
    }

    public static void $nEm(Object[] array, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(array != null && array.length > 0, messageTemplate, params);
    }

    public static void $nEm(CharSequence sequence, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(sequence != null && sequence.length() > 0, messageTemplate, params);
    }

    public static void $eq(Object first, Object second, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(first == null && second == null || first != null && first.equals(second), messageTemplate, params);
    }

    public static void $z(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) == 0, messageTemplate, params);
    }

    public static void $nZ(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) != 0, messageTemplate, params);
    }

    public static void $neg(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) < 0, messageTemplate, params);
    }

    public static void $nNeg(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) >= 0, messageTemplate, params);
    }

    public static void $pos(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) > 0, messageTemplate, params);
    }

    public static void $nPos(Number number, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(number != null && Double.compare(number.doubleValue(), 0.0) <= 0, messageTemplate, params);
    }

    public static void $lte(Number first, Number second, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(first != null && second != null && Double.compare(first.doubleValue(), second.doubleValue()) <= 0, messageTemplate, params);
    }

    public static void $lt(Number first, Number second, String messageTemplate, Object ... params) {
        AssertionUtils.$_iArg(first != null && second != null && Double.compare(first.doubleValue(), second.doubleValue()) < 0, messageTemplate, params);
    }

    public static void $gt(Number first, Double second, String messageTemplate, Object ... params) {
        AssertionUtils.$lt(second, first, messageTemplate, params);
    }

    public static void $gte(Number first, Number second, String messageTemplate, Object ... params) {
        AssertionUtils.$lte(second, first, messageTemplate, params);
    }

    public static void $_iArg(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(condition, IllegalArgumentException.class, messageTemplate, params);
    }

    public static void $_uOp(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(condition, UnsupportedOperationException.class, messageTemplate, params);
    }

    public static <O> O $_failRet(Class<O> fakeReturnType, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(false, AssertionError.class, messageTemplate, params);
        return null;
    }

    public static <O, T extends Throwable> O $_failRet(Class<T> thrown, Class<O> fakeReturnType, String messageTemplate, Object ... params) throws T {
        AssertionUtils.$_assert(false, thrown, messageTemplate, params);
        return null;
    }

    public static void $_fail(String messageTemplate, Object ... params) {
        AssertionUtils.$_failRet(Void.class, messageTemplate, params);
    }

    public static <T extends Throwable> void $_fail(String messageTemplate, Class<T> thrown, Object ... params) throws T {
        AssertionUtils.$_failRet(thrown, Void.class, messageTemplate, params);
    }

    public static void $_assert(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(condition, AssertionError.class, messageTemplate, params);
    }

    public static void $_nAssert(boolean condition, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(!condition, AssertionError.class, messageTemplate, params);
    }

    public static void $_nAssert(boolean condition, Class<? extends RuntimeException> uncheckedException, String messageTemplate, Object ... params) {
        AssertionUtils.$_assert(!condition, uncheckedException, messageTemplate, params);
    }

    public static <T extends Throwable> void $_assert(boolean condition, Class<T> thrownException, String messageTemplate, Object ... params) throws T {
        String expandedMessage = null;
        if (!($assertionsDisabled || ASSERTS_ARE_ENABLED && condition)) {
            expandedMessage = AssertionUtils.$_expand(messageTemplate, params);
            throw new AssertionError((Object)expandedMessage);
        }
        if (!ASSERTS_ARE_ENABLED && !condition) {
            if (thrownException != null) {
                Constructor<T> toThrow = null;
                expandedMessage = AssertionUtils.$_expand(messageTemplate, params);
                try {
                    toThrow = thrownException.isAssignableFrom(AssertionError.class) ? thrownException.getConstructor(Object.class) : thrownException.getConstructor(String.class);
                }
                catch (NoSuchMethodException NSMe) {
                    AssertionUtils.getLogger(AssertionUtils.class).warn("Provided exception class ({}) doesn't have a constructor with one argument of type java.lang.String: using default constructor instead", thrownException);
                }
                if (toThrow != null) {
                    try {
                        Object[] objectArray;
                        if (expandedMessage == null) {
                            objectArray = new Object[]{};
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = expandedMessage;
                        }
                        throw (Throwable)toThrow.newInstance(objectArray);
                    }
                    catch (InvocationTargetException ITe) {
                        AssertionUtils.getLogger(AssertionUtils.class).error("Unable to throw provided exception ({})", thrownException, (Object)ITe);
                    }
                    catch (IllegalAccessException IAe) {
                        AssertionUtils.getLogger(AssertionUtils.class).error("Unable to throw provided exception ({})", thrownException, (Object)IAe);
                    }
                    catch (InstantiationException Ie) {
                        AssertionUtils.getLogger(AssertionUtils.class).error("Unable to throw provided exception ({})", thrownException, (Object)Ie);
                    }
                }
            }
            throw expandedMessage == null ? new AssertionError() : new AssertionError((Object)AssertionUtils.$_expand(messageTemplate, params));
        }
    }

    private static String $_expand(String messageTemplate, Object ... params) {
        if (messageTemplate == null || params == null || params.length == 0) {
            return messageTemplate;
        }
        String expanded = messageTemplate;
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object param = objectArray[n2];
            expanded = expanded.replaceFirst("\\{\\}", Matcher.quoteReplacement(param == null ? "<NULL>" : param.toString()));
            ++n2;
        }
        return expanded;
    }
}

