/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.mongodb.storeharvested.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.gcube.datatransformation.harvester.core.db.HarvestedInfoObject;
import org.gcube.datatransformation.harvester.core.harvestedmanagement.utils.SHAHashing;
import org.gcube.datatransformation.harvester.core.harvestedmanagement.utils.XmlNodeTransform;
import org.gcube.datatransformation.harvester.core.utils.retrieveinfo.ParseDomForIdentifier;
import org.gcube.datatransformation.harvester.core.utils.retrieveinfo.ParseDomForStatus;
import org.gcube.datatransformation.harvester.mongodb.harvestedmanagement.entities.EmbeddedInfo;
import org.gcube.datatransformation.harvester.mongodb.harvestedmanagement.entities.HarvestedInfoObjsInMongoDB;
import org.gcube.datatransformation.harvester.mongodb.harvestedmanagement.entities.HarvestedObjectOnMongoDB;
import org.gcube.datatransformation.harvester.mongodb.harvestedmanagement.entities.XmlByMetadataPrefixOnMongoDB;
import org.gcube.datatransformation.harvester.mongodb.storeharvested.db.MorphiaManager;
import org.mongodb.morphia.Datastore;
import org.w3c.dom.Node;

public class DatabaseManagerMongoDB {
    private static DatabaseManagerMongoDB dbManager = null;
    private Datastore datastore = null;

    protected DatabaseManagerMongoDB(String dbName) {
        this.datastore = MorphiaManager.getMorphiaManagerInstance(dbName);
    }

    public static DatabaseManagerMongoDB getDatabaseManagerInstance(String dbName) {
        if (dbManager == null) {
            dbManager = new DatabaseManagerMongoDB(dbName);
        }
        return dbManager;
    }

    public boolean storeToDB(HarvestedInfoObject harvestedInfoObject) throws IOException {
        if (!harvestedInfoObject.getVerb().equals("ListRecords")) {
            return false;
        }
        HarvestedInfoObjsInMongoDB harvestedInfo = this.fetchObjectByUri(harvestedInfoObject.getUri());
        if (harvestedInfo != null) {
            this.updateOnExistingHarvestedInfo(harvestedInfo, harvestedInfoObject);
        } else {
            boolean counter = false;
            HashMap hashMap = new HashMap();
        }
        return true;
    }

    public boolean removeFromDB(String uri) {
        HarvestedInfoObjsInMongoDB harvestedInfo = this.fetchObjectByUri(uri);
        if (harvestedInfo != null) {
            this.datastore.delete((Object)harvestedInfo);
        }
        return true;
    }

    private boolean fetchNewRecords(HashMap<String, EmbeddedInfo> storedHarvestedDocInfo, List<Node> aboutToStore) {
        boolean somethingChanged = false;
        for (Node node : aboutToStore) {
            EmbeddedInfo embeddedInfo;
            EmbeddedInfoOnDoc info = DatabaseManagerMongoDB.createHarvestedDocumentObj(node);
            if (!info.getStatusDeleted()) {
                embeddedInfo = storedHarvestedDocInfo.get(info.getId());
                if (embeddedInfo != null) {
                    if (embeddedInfo.getHashedValue().equals(info.getHashedV())) continue;
                    embeddedInfo.setHashedValue(info.getHashedV());
                    embeddedInfo.setNode(info.getNode());
                    storedHarvestedDocInfo.put(info.getId(), embeddedInfo);
                    somethingChanged = true;
                    continue;
                }
                embeddedInfo = new EmbeddedInfo();
                embeddedInfo.setHashedValue(info.getHashedV());
                embeddedInfo.setNode(info.getNode());
                storedHarvestedDocInfo.put(info.getId(), embeddedInfo);
                somethingChanged = true;
                continue;
            }
            embeddedInfo = storedHarvestedDocInfo.get(info.getId());
            if (embeddedInfo == null) continue;
            storedHarvestedDocInfo.remove(info);
            somethingChanged = true;
        }
        return somethingChanged;
    }

    private static EmbeddedInfoOnDoc createHarvestedDocumentObj(Node node) {
        EmbeddedInfoOnDoc info = new EmbeddedInfoOnDoc();
        try {
            String identifier = ParseDomForIdentifier.extractIdentifier((Node)node);
            info.setId(identifier);
            info.setNode(XmlNodeTransform.nodeToString((Node)node));
            info.setHashedV(SHAHashing.getHashedValue((String)ParseDomForIdentifier.extractMetadata((Node)node)));
            String statusForDeletion = ParseDomForStatus.extractIdentifier((Node)node);
            if (statusForDeletion != null && statusForDeletion.equals("deleted")) {
                info.setStatusDeleted(true);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return info;
    }

    private HarvestedInfoObjsInMongoDB fetchObjectByUri(String uri) {
        HarvestedInfoObjsInMongoDB hO = (HarvestedInfoObjsInMongoDB)this.datastore.createQuery(HarvestedInfoObjsInMongoDB.class).filter("uri", (Object)uri).get();
        return hO;
    }

    public HarvestedInfoObjsInMongoDB fetchObjectByUriAndSchema(String uri, String schema) {
        HarvestedInfoObjsInMongoDB hO = schema != null ? (HarvestedInfoObjsInMongoDB)this.datastore.createQuery(HarvestedInfoObjsInMongoDB.class).filter("uri =", (Object)uri).filter("harvestedObjects.verb =", (Object)"ListRecords").filter("harvestedObjects.objects.metadataPrefix =", (Object)schema).get() : (HarvestedInfoObjsInMongoDB)this.datastore.createQuery(HarvestedInfoObjsInMongoDB.class).filter("uri =", (Object)uri).get();
        return hO;
    }

    public boolean insertOnMongo(HarvestedInfoObject harvestedInfoObject, HashMap<String, EmbeddedInfo> nodesToInsert) throws IOException {
        HarvestedInfoObjsInMongoDB insertObject = new HarvestedInfoObjsInMongoDB();
        insertObject.setUri(harvestedInfoObject.getUri());
        ArrayList<HarvestedObjectOnMongoDB> harvestedObjsList = new ArrayList<HarvestedObjectOnMongoDB>();
        HarvestedObjectOnMongoDB harvestedObj = new HarvestedObjectOnMongoDB();
        harvestedObj.setVerb(harvestedInfoObject.getVerb());
        ArrayList<XmlByMetadataPrefixOnMongoDB> xmlList = new ArrayList<XmlByMetadataPrefixOnMongoDB>();
        XmlByMetadataPrefixOnMongoDB xml = new XmlByMetadataPrefixOnMongoDB();
        xml.setMetadataPrefix(harvestedInfoObject.getMetadataPrefix());
        xml.setHarvestedDocument(nodesToInsert);
        xmlList.add(xml);
        harvestedObj.setObjects(xmlList);
        harvestedObjsList.add(harvestedObj);
        insertObject.setHarvestedObjects(harvestedObjsList);
        this.datastore.save((Object)insertObject);
        return true;
    }

    public boolean updateOnExistingHarvestedInfo(HarvestedInfoObjsInMongoDB hi, HarvestedInfoObject harvestedInfoObject) {
        boolean xmlFound = false;
        boolean verbFound = false;
        HarvestedObjectOnMongoDB harvestedObj = null;
        boolean somethingChanged = false;
        block0: for (HarvestedObjectOnMongoDB ho : hi.getHarvestedObjects()) {
            if (!ho.getVerb().equals(harvestedInfoObject.getVerb())) continue;
            verbFound = true;
            harvestedObj = ho;
            for (XmlByMetadataPrefixOnMongoDB xml : ho.getObjects()) {
                if (!xml.getMetadataPrefix().equals(harvestedInfoObject.getMetadataPrefix())) continue;
                xmlFound = true;
                continue block0;
            }
        }
        if (somethingChanged) {
            this.datastore.save((Object)hi);
        } else if (verbFound) {
            if (!xmlFound) {
                XmlByMetadataPrefixOnMongoDB xml = new XmlByMetadataPrefixOnMongoDB();
                xml.setMetadataPrefix(harvestedInfoObject.getMetadataPrefix());
                HashMap<String, EmbeddedInfo> embeddedInfo = new HashMap<String, EmbeddedInfo>();
                int count = 0;
                EmbeddedInfo ei = new EmbeddedInfo();
                ++count;
                xml.setHarvestedDocument(embeddedInfo);
                harvestedObj.addToObjects(xml);
                this.datastore.save((Object)hi);
            }
        } else if (!xmlFound) {
            HarvestedObjectOnMongoDB harvestedObjectOnMongoDB = new HarvestedObjectOnMongoDB();
            harvestedObjectOnMongoDB.setVerb(harvestedInfoObject.getVerb());
            XmlByMetadataPrefixOnMongoDB xml = new XmlByMetadataPrefixOnMongoDB();
            xml.setMetadataPrefix(harvestedInfoObject.getMetadataPrefix());
            int count = 0;
            HashMap<String, EmbeddedInfo> embeddedInfo = new HashMap<String, EmbeddedInfo>();
            EmbeddedInfo ei = new EmbeddedInfo();
            ++count;
            xml.setHarvestedDocument(embeddedInfo);
            harvestedObjectOnMongoDB.addToObjects(xml);
            hi.addToHarvestedObjects(harvestedObjectOnMongoDB);
            this.datastore.save((Object)hi);
        }
        return true;
    }

    public static class EmbeddedInfoOnDoc {
        private String id;
        private String node;
        private String hashedV;
        private boolean statusDeleted;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public String getHashedV() {
            return this.hashedV;
        }

        public void setHashedV(String hashedV) {
            this.hashedV = hashedV;
        }

        public boolean getStatusDeleted() {
            return this.statusDeleted;
        }

        public void setStatusDeleted(boolean statusDeleted) {
            this.statusDeleted = statusDeleted;
        }
    }
}

