/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.filesmanagement.times;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.filesmanagement.manager.FilesManagerRead;
import org.gcube.datatransformation.harvester.filesmanagement.times.TimesFormatInJsonFile;
import org.gcube.datatransformation.harvester.filesmanagement.times.TimesReader;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class ReadUrls
implements FilesManagerRead {
    private static final Logger logger = Logger.getLogger(ReadUrls.class);

    public void readFromFile(boolean initialization) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            File file = new File(GetProperties.getPropertiesInstance().getTimesFile());
            if (file != null && file.canRead() && file.length() != 0L) {
                TimesFormatInJsonFile timesFormatInJsonFile = (TimesFormatInJsonFile)objectMapper.readValue(file, TimesFormatInJsonFile.class);
                TimesReader.getTimesReaderInstance().setConfiguredTime(timesFormatInJsonFile.getConfiguredTime());
                TimesReader.getTimesReaderInstance().setTimesMapping(timesFormatInJsonFile.getTimesMapping());
            }
        }
        catch (FileNotFoundException e) {
            logger.info((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.info((Object)e.getMessage());
        }
    }
}

