(function() {
'use strict';

var pageState = {};


var renderURL = "";
var resourceURL = "";
var contextPath = "";



function init(renderURL, resourceURL) {

	renderURL = renderURL;
	resourceURL = resourceURL;
	
	initNavBar(resourceURL);
	
	$.ajax({
		url: createLink(resourceURL, 'registerurl/getInfoForRegisteredUris'),
		type: 'get',
		dataType: 'json',
		contentType: 'application/json',
		success: function(registeredUrlsInfo) {
			
			for (var i=0; i<registeredUrlsInfo.length; i++) {
				$("#listOfUris").append("<li><a> " +  registeredUrlsInfo[i].uri +"</a></li>");
				$.data($('#dropdownForUri').closest('.btn-group').find('ul li:last-child')[0], 'categoryValue', registeredUrlsInfo[i]);
			}
			
			if(registeredUrlsInfo.length === 0) {
				$('#dropdownForUri').dropdownDisplayMode = $('#dropdownForUri').css('display');
				$('#dropdownForUri').hide();
			} else 
				$('#dropdownForUri').css('display', $('#dropdownForUri').dropdownDisplayMode);
			
			$('#dropdownForUri').closest('.btn-group').find('ul li').on('click', function(e) {
				$('.getRecordContainer').hide();
				$('.listMetadataFormatsContainer').hide();
				$('.listRecordsContainer').hide();
				$('.listIdentifiersContainer').hide();
				$('.identifyContainer').hide();
				$('.listSetsContainer').hide();
				
				var li = $(e.target).is('li') ? e.target : $(e.target).closest('li')[0];
		    	var catValue = $.data(li, 'categoryValue');
		    	$('#dropdownForUri').find('div.categoryName').html($(li).find('a').text());
		    	$('#dropdownForUri').find('.categoryAdd div.caret').removeClass('empty');
		    	$('#dropdownForUri').currentCategory = catValue;
		    	$('#dropdownForUri').addingTwoPhase = true;
		    
		    	pageState.catValue = catValue;
		    	
		    	
		    	for (var j=0; j<catValue.message.length; j++) {
		    		if (catValue.message[j].infoForHarvesting.verb === "ListRecords") {
		    			$('.listRecordsContainer').show();
		    			$('#setLRMetadataPrefix').prop('required',true);
		    		
		    			$('#setLRVerb').html(catValue.message[j].infoForHarvesting.verb);
		    			
		    			if (catValue.message[j].infoForHarvesting.listRecords.metadataPrefix)
		    				$('#setLRMetadataPrefix').val(catValue.message[j].infoForHarvesting.listRecords.metadataPrefix);
		    			else $('#setLRMetadataPrefix').val('');
		    			
		    			if (catValue.message[j].infoForHarvesting.listRecords.from)
		    				$('#setLRFrom').val(catValue.message[j].infoForHarvesting.listRecords.from);
		    			else $('#setLRFrom').val('');
		    			
		    			if (catValue.message[j].infoForHarvesting.listRecords.until)
		    				$('#setLRUntil').val(catValue.message[j].infoForHarvesting.listRecords.until);
		    			else $('#setLRUntil').val('');
		    			
		    			if (catValue.message[j].infoForHarvesting.listRecords.set)
		    				$('#setLRSet').val(catValue.message[j].infoForHarvesting.listRecords.set);
		    			else $('#setLRSet').val('');
		    			
		    			$('#setSizeOfRList').val(catValue.message[j].sizetOfList);
		    		} else if (catValue.message[j].infoForHarvesting.verb === "GetRecord") {
						$('.getRecordContainer').show();
			    		$('#setRIdentifier').prop('required',true);
			    		$('#setRMetadataPrefix').prop('required',true);
		    		
		    			$('#setGRVerb').html(catValue.message[j].infoForHarvesting.verb);
			    		
			    		if (catValue.message[j].infoForHarvesting.getRecord.identifier)
			    			$('#setRIdentifier').val(catValue.message[j].infoForHarvesting.getRecord.identifier);
			    		else $('#setRIdentifier').val('');
			    		
			    		if (catValue.message[j].infoForHarvesting.getRecord.metadataPrefix)
			    			$('#setRMetadataPrefix').val(catValue.message[j].infoForHarvesting.getRecord.metadataPrefix);
			    		else $('#setRMetadataPrefix').val('');
		    		} else if (catValue.message[j].infoForHarvesting.verb === "ListIdentifiers") {
						$('.listIdentifiersContainer').show();
			    		$('#setLIMetadataPrefix').prop('required',true);

			    		$('#setLIVerb').html(catValue.message[j].infoForHarvesting.verb);
			    		
			    		if (catValue.message[j].infoForHarvesting.listIdentifiers.from)
			    			$('#setLIFrom').val(catValue.message[j].infoForHarvesting.listIdentifiers.from);
			    		else $('#setLIFrom').val('');
			    		
			    		if (catValue.message[j].infoForHarvesting.listIdentifiers.until)
			    			$('#setLIUntil').val(catValue.message[j].infoForHarvesting.listIdentifiers.until);
			    		else $('#setLIUntil').val('');
			    		
			    		if (catValue.message[j].infoForHarvesting.listIdentifiers.set)
			    			$('#setLISet').val(catValue.message[j].infoForHarvesting.listIdentifiers.set);
			    		else $('#setLISet').val('');
			    		$('#setSizeOfIList').val(catValue.message[j].sizetOfList);
					} else if (catValue.message[j].infoForHarvesting.verb === "ListMetadataFormats") {
						$('.listMetadataFormatsContainer').show();
					
						$('#setLMVerb').html(catValue.message[j].infoForHarvesting.verb);
						
						if (catValue.message[j].infoForHarvesting.listMetadataFormats.identifier)
							$('#setMFIdentifier').val(catValue.message[j].infoForHarvesting.listMetadataFormats.identifier);
						else $('#setMFIdentifier').val('');
						$('#setSizeOfMFList').val(catValue.message[j].sizetOfList);
					} else if (catValue.message[j].infoForHarvesting.verb === "ListSets") {
					
						$('#setLSVerb').html(catValue.message[j].infoForHarvesting.verb);
						
					} else if (catValue.message[j].infoForHarvesting.verb === "Identify") {
					
						$('#setIVerb').html(catValue.message[j].infoForHarvesting.verb);
						$('#setSizeOfSList').val(catValue.message[j].sizetOfList);	
					}
		    	}
				$('#setTime').val(catValue.time);
	    	});
			
			$("#dropdownForUri li:first-child").click();
		},
		error: function(jqXHR, textStatus, errorThrown) {
    		$('html').removeClass('loading');
   			alert("The following error occured: " + textStatus, errorThrown);
   		}
	});
	$('.dropdown-toggle').dropdown();
	
	
}
		




function postDataToServer(json, postUrl, callback) {
	$.ajax({
		url: postUrl,
		type: 'post',
		cache: false,
	    contentType: "application/json",
	    dataType: "json",
		data: JSON.stringify(json),
		success: function(response) {
			if(response.status != 200) {
				alert(response.message);
				return;
			}
			if(callback) callback();
		},
		error : function(jqXHR, textStatus, errorThrown) {
			alert("An error occured");
	     }
	});	
}

function createLink(url, resource, param) {
	var link;
	if (param === undefined) {
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', '');
		if (link.charAt(link.length - 1) == "?")
			link = link.slice(0, -1);
			
	} else
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', param);
	
	return link;
}

window.Harvester = {};
window.Harvester.init = init;

}());