/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.api;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.gcube.data.access.bean.GSInstance;
import org.gcube.data.access.bean.GSInstanceList;
import org.gcube.data.access.bean.GSUser;
import org.gcube.data.access.bean.Group;
import org.gcube.data.access.bean.Instance;
import org.gcube.data.access.bean.Rule;
import org.gcube.data.access.bean.RuleList;
import org.gcube.data.access.bean.Rules;
import org.gcube.data.access.bean.User;
import org.gcube.data.access.bean.UserGroup;
import org.gcube.data.access.bean.UserGroupList;
import org.gcube.data.access.bean.UserList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class GeoFence {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static RestTemplate restTemplate = null;
    private String geofenceRestUrl = null;

    public GeoFence(String geofenceRestUrl) {
        if (restTemplate == null) {
            restTemplate = new RestTemplate();
        }
        this.logger.debug("RestTemplate instance: " + restTemplate);
        this.geofenceRestUrl = geofenceRestUrl;
        this.logger.info("GeoFenceRestUrl used: " + this.geofenceRestUrl);
    }

    public GSUser getUserById(String id) {
        String url = this.geofenceRestUrl + "/users/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        this.logger.info("Call to getUserById with url: " + url + " [" + map + "]");
        GSUser gsuser = (GSUser)restTemplate.getForObject(url, GSUser.class, map);
        this.logger.debug(this.marshal(gsuser, GSUser.class));
        return gsuser;
    }

    public GSUser getUserByUsername(String userName) {
        String url = this.geofenceRestUrl + "/users/name/{userName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        this.logger.info("Call to getUserByUsername with url: " + url + " [" + map + "]");
        GSUser gsuser = (GSUser)restTemplate.getForObject(url, GSUser.class, map);
        this.logger.debug(this.marshal(gsuser, GSUser.class));
        return gsuser;
    }

    public HttpStatus createUser(User user) {
        String url = this.geofenceRestUrl + "/users";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to createUser with url: " + url);
        try {
            HttpEntity request = new HttpEntity((Object)user, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus updateUser(User user) {
        String id = user.getId();
        if (StringUtils.hasText((String)id)) {
            this.logger.info("Call to updateUser with id " + id);
            return this.updateUserById(id, user.getPassword(), user.getEmailAddress(), user.isAdmin(), user.isEnabled());
        }
        String userName = user.getName();
        if (StringUtils.hasText((String)userName)) {
            this.logger.info("Call to updateUser with userName " + userName);
            return this.updateUserByUsername(userName, user.getPassword(), user.getEmailAddress(), user.isAdmin(), user.isEnabled());
        }
        return HttpStatus.BAD_REQUEST;
    }

    public HttpStatus updateUserById(String id, String password, String email, boolean admin, boolean enabled) {
        String url = this.geofenceRestUrl + "/users/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateUserById with url: " + url + " [" + map + "]");
        User user = new User(password, email, enabled, admin);
        this.logger.debug(this.marshal(user, User.class));
        try {
            HttpEntity request = new HttpEntity((Object)user, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus updateUserByUsername(String userName, String password, String email, boolean admin, boolean enabled) {
        String url = this.geofenceRestUrl + "/users/name/{userName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateUserByUsername with url: " + url + " [" + map + "]");
        User user = new User(password, email, enabled, admin);
        this.logger.debug(this.marshal(user, User.class));
        try {
            HttpEntity request = new HttpEntity((Object)user, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteUserById(String id, boolean removeAllRules) {
        String url = this.geofenceRestUrl + "/users/id/{id}?cascade={removeAllRules}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("removeAllRules", Boolean.toString(removeAllRules));
        this.logger.info("Call to deleteUserById with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteUserByUsername(String userName, boolean removeAllRules) {
        String url = this.geofenceRestUrl + "/users/name/{userName}?cascade={removeAllRules}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("removeAllRules", Boolean.toString(removeAllRules));
        this.logger.info("Call to deleteUserByUsername with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public UserList getUserList() {
        String url = this.geofenceRestUrl + "/users";
        this.logger.info("Call to getUserList with url: " + url);
        UserList ul = (UserList)restTemplate.getForObject(url, UserList.class, new Object[0]);
        this.logger.debug(this.marshal(ul, UserList.class));
        return ul;
    }

    public HttpStatus createUserGroup(UserGroup userGroup) {
        String url = this.geofenceRestUrl + "/groups";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to createUserGroup with url: " + url);
        try {
            HttpEntity request = new HttpEntity((Object)userGroup, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public Group getUserGroupById(String id) {
        String url = this.geofenceRestUrl + "/groups/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        this.logger.info("Call to getUserGroupById with url: " + url + " [" + map + "]");
        Group g = (Group)restTemplate.getForObject(url, Group.class, map);
        this.logger.debug(this.marshal(g, Group.class));
        return g;
    }

    public Group getUserGroupByName(String userName) {
        String url = this.geofenceRestUrl + "/groups/name/{userName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        this.logger.info("Call to getUserGroupByName with url: " + url + " [" + map + "]");
        Group g = (Group)restTemplate.getForObject(url, Group.class, map);
        this.logger.debug(this.marshal(g, Group.class));
        return g;
    }

    public HttpStatus updateUserGroup(Group group) {
        String id = group.getId();
        this.logger.info("Call to updateUserGroup - id " + id);
        if (StringUtils.hasText((String)id)) {
            return this.updateUserGroupById(id, group.isEnabled());
        }
        String name = group.getName();
        this.logger.info("Call to updateUserGroup - name " + name);
        if (StringUtils.hasText((String)name)) {
            return this.updateUserGroupByName(name, group.isEnabled());
        }
        return HttpStatus.BAD_REQUEST;
    }

    public HttpStatus updateUserGroupById(String id, boolean enabled) {
        String url = this.geofenceRestUrl + "/groups/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateUserGroupById with url: " + url + " [" + map + "]");
        UserGroup group = new UserGroup(enabled);
        this.logger.debug(this.marshal(group, UserGroup.class));
        try {
            HttpEntity request = new HttpEntity((Object)group, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus updateUserGroupByName(String name, boolean enabled) {
        String url = this.geofenceRestUrl + "/groups/name/{name}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateUserGroupByName with url: " + url + " [" + map + "]");
        UserGroup group = new UserGroup(enabled);
        this.logger.debug(this.marshal(group, UserGroup.class));
        try {
            HttpEntity request = new HttpEntity((Object)group, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteUserGroupById(String groupId) {
        String url = this.geofenceRestUrl + "/groups/id/{groupId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupId", groupId);
        this.logger.info("Call to deleteUserGroupById with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteUserGroupByName(String groupName) {
        String url = this.geofenceRestUrl + "/groups/name/{groupName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupName", groupName);
        this.logger.info("Call to deleteUserGroupByName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public UserGroupList getUserGroupList() {
        String url = this.geofenceRestUrl + "/groups";
        this.logger.info("Call to getUserGroupList with url: " + url);
        UserGroupList ugl = (UserGroupList)restTemplate.getForObject(url, UserGroupList.class, new Object[0]);
        this.logger.debug(this.marshal(ugl, UserGroupList.class));
        return ugl;
    }

    public HttpStatus assignToUserGroupByUserIdGroupId(String userId, String groupId) {
        String url = this.geofenceRestUrl + "/users/id/{userId}/group/id/{groupId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("groupId", groupId);
        this.logger.info("Call to assignToUserGroupByUserIdGroupId with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus assignToUserGroupByUserIdGroupName(String userId, String groupName) {
        String url = this.geofenceRestUrl + "/users/id/{userId}/group/name/{groupName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("groupName", groupName);
        this.logger.info("Call to assignToUserGroupByUserIdGroupName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus assignToUserGroupByUserNameGroupId(String userName, String groupId) {
        String url = this.geofenceRestUrl + "/users/name/{userName}/group/id/{groupId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("groupId", groupId);
        this.logger.info("Call to assignToUserGroupByUserNameGroupId with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus assignToUserGroupByUserNameGroupName(String userName, String groupName) {
        String url = this.geofenceRestUrl + "/users/name/{userName}/group/name/{groupName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("groupName", groupName);
        this.logger.info("Call to assignToUserGroupByUserIdGroupName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus removeUserGroupByUserIdGroupId(String userId, String groupId) {
        String url = this.geofenceRestUrl + "/users/id/{userId}/group/id/{groupId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("groupId", groupId);
        this.logger.info("Call to removeUserGroupByUserIdGroupId with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus removeUserGroupByUserIdGroupName(String userId, String groupName) {
        String url = this.geofenceRestUrl + "/users/id/{userId}/group/name/{groupName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("groupName", groupName);
        this.logger.info("Call to removeUserGroupByUserIdGroupName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus removeUserGroupByUserNameGroupId(String userName, String groupId) {
        String url = this.geofenceRestUrl + "/users/name/{userName}/group/id/{groupId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("groupId", groupId);
        this.logger.info("Call to removeUserGroupByUserNameGroupId with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus removeUserGroupByUserNameGroupName(String userName, String groupName) {
        String url = this.geofenceRestUrl + "/users/name/{userName}/group/name/{groupName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("groupName", groupName);
        this.logger.info("Call to removeUserGroupByUserNameGroupName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus createInstance(Instance instance) {
        String url = this.geofenceRestUrl + "/instances";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to createInstance with url: " + url);
        try {
            HttpEntity request = new HttpEntity((Object)instance, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public GSInstance getInstanceById(String instanceId) {
        String url = this.geofenceRestUrl + "/instances/id/{instanceId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instanceId", instanceId);
        this.logger.info("Call to getInstanceById with url: " + url + " [" + map + "]");
        GSInstance instance = (GSInstance)restTemplate.getForObject(url, GSInstance.class, map);
        this.logger.debug(this.marshal(instance, GSInstance.class));
        return instance;
    }

    public GSInstance getInstanceByName(String instanceName) {
        String url = this.geofenceRestUrl + "/instances/name/{instanceName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instanceName", instanceName);
        this.logger.info("Call to getInstanceByName with url: " + url + " [" + map + "]");
        GSInstance instance = (GSInstance)restTemplate.getForObject(url, GSInstance.class, map);
        this.logger.debug(this.marshal(instance, GSInstance.class));
        return instance;
    }

    public HttpStatus updateInstance(Instance instance) {
        String id = instance.getId();
        if (StringUtils.hasText((String)id)) {
            this.logger.info("Call to updateInstance with id " + id);
            return this.updateInstanceById(id, instance.getUsername(), instance.getPassword(), instance.getBaseURL(), instance.getDescription());
        }
        String name = instance.getName();
        if (StringUtils.hasText((String)name)) {
            this.logger.info("Call to updateInstance with name " + name);
            return this.updateInstanceByName(name, instance.getUsername(), instance.getPassword(), instance.getBaseURL(), instance.getDescription());
        }
        return HttpStatus.BAD_REQUEST;
    }

    public HttpStatus updateInstanceById(String id, String username, String password, String baseURL, String description) {
        String url = this.geofenceRestUrl + "/instances/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateUserGroupById with url: " + url + " [" + map + "]");
        Instance instance = new Instance(username, password, baseURL, description);
        this.logger.debug(this.marshal(instance, Instance.class));
        try {
            HttpEntity request = new HttpEntity((Object)instance, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus updateInstanceByName(String instanceName, String username, String password, String baseURL, String description) {
        String url = this.geofenceRestUrl + "/instances/name/{instanceName}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instanceName", instanceName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateInstanceByName with url: " + url + " [" + map + "]");
        Instance instance = new Instance(username, password, baseURL, description);
        this.logger.debug(this.marshal(instance, Instance.class));
        try {
            HttpEntity request = new HttpEntity((Object)instance, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, request, String.class, map);
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteInstanceById(String instanceId) {
        String url = this.geofenceRestUrl + "/instances/id/{instanceId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instanceId", instanceId);
        this.logger.info("Call to deleteInstanceById with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteInstanceByName(String instanceName, boolean removeAllRules) {
        String url = this.geofenceRestUrl + "/instances/name/{instanceName}?cascade={removeAllRules}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instanceName", instanceName);
        map.put("removeAllRules", Boolean.toString(removeAllRules));
        this.logger.info("Call to deleteInstanceByName with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public GSInstanceList getInstanceList() {
        String url = this.geofenceRestUrl + "/instances";
        this.logger.info("Call to getInstanceList with url: " + url);
        GSInstanceList instances = (GSInstanceList)restTemplate.getForObject(url, GSInstanceList.class, new Object[0]);
        this.logger.debug(this.marshal(instances, GSInstanceList.class));
        return instances;
    }

    public HttpStatus createRule(Rule rule) {
        String url = this.geofenceRestUrl + "/rules";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to createInstance with url: " + url);
        try {
            HttpEntity request = new HttpEntity((Object)rule, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public Rules getRulesById(String id) {
        String url = this.geofenceRestUrl + "/rules/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        this.logger.info("Call to getRulesById with url: " + url + " [" + map + "]");
        Rules rules = (Rules)restTemplate.getForObject(url, Rules.class, map);
        this.logger.debug(this.marshal(rules, Rules.class));
        return rules;
    }

    public HttpStatus updateRule(Rule rule) {
        String id = rule.getId();
        if (StringUtils.hasText((String)id)) {
            this.logger.info("Call to updateInstance with id " + id);
            return this.updateRuleById(id, rule.getPriority(), rule.getService(), rule.getRequest(), rule.getWorkspace(), rule.getLayer(), rule.getUser().getId(), rule.getGroup().getId(), rule.getInstance().getId());
        }
        return HttpStatus.BAD_REQUEST;
    }

    public HttpStatus updateRuleById(String id, String priority, String service, String request, String workspace, String layer, String userId, String groupId, String instanceId) {
        String url = this.geofenceRestUrl + "/rules/id/{id}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        this.logger.info("Call to updateRule with url: " + url + " [" + map + "]");
        Rule rule = new Rule(priority, service, request, workspace, layer, userId, groupId, instanceId);
        this.logger.debug(this.marshal(rule, Rule.class));
        try {
            HttpEntity req = new HttpEntity((Object)rule, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.PUT, req, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public HttpStatus deleteRule(String ruleId) {
        String url = this.geofenceRestUrl + "/rules/id/{ruleId}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ruleId", ruleId);
        this.logger.info("Call to deleteRule with url: " + url + " [" + map + "]");
        try {
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.DELETE, null, String.class, map);
            this.logger.debug("StatusCode: " + this.printHttpStatus(response.getStatusCode()));
            return response.getStatusCode();
        }
        catch (HttpStatusCodeException ex) {
            this.logger.debug("StatusCode: " + this.printHttpStatus(ex.getStatusCode()));
            return ex.getStatusCode();
        }
    }

    public RuleList getRulesList() {
        String url = this.geofenceRestUrl + "/rules";
        this.logger.info("Call to getRulesList with url: " + url);
        RuleList rl = (RuleList)restTemplate.getForObject(url, RuleList.class, new Object[0]);
        this.logger.debug(this.marshal(rl, RuleList.class));
        return rl;
    }

    private String printHttpStatus(HttpStatus status) {
        return status.value() + " - " + status.name();
    }

    private <T> String marshal(T object, Class<T> marshalClass) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{marshalClass});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter sw = new StringWriter();
            jaxbMarshaller.marshal(object, (Writer)sw);
            return sw.toString();
        }
        catch (JAXBException e) {
            return null;
        }
    }
}

